% Determine if current MATLAB version is below given release string
%
% The built-in verLessThan function can be used to compare the current
% MATLAB version to a version number, e.g. verLessThan('MATLAB', 8.3').
% Because it's sometimes inconvenient to know the MATLAB version number,
% this function can be used to compare the current MATLAB version to a
% given release string (e.g. '2012a' or 'R2012a').
%
% Syntax: tf = lessThanR(release)
%
% Inputs
%   release - char array string with the release string. For valid inputs
%             see numFromRelease function in same namespace.
% 
% Outputs
%   TF - true if current MATLAB version is older than specified version,
%        otherwise false
%
% Examples
%   Called in MATLAB R2014b
%   >> TF = lessThanR('2013b')    % TF = false
%
%   Called in MATLAB R2013a
%   >> TF = lessThanR('2013b')    % TF = true
