% Determine if char array string is in another string
%
% As Matlab's contains function is only available since R2016b, this
% function is a rudimentary substitute for older Matlab versions.
% As the original, this function is case-sensitive and returns always true
% if the second input is the empty string.
% Currently, function is 'rudimentary' substitute of the original as it
% does not support:
% (1) the pattern parameter as cell array;
% (2) the 'IgnoreCase' option to explicitly determine case sensitivy.
%
% Syntax: TF = contains(str, pattern)
%
% Inputs
%   str     - char array string whose content is searched for second input,
%             or cell array of char array strings
%   pattern - char array string that is searched inside the first input
% 
% Outputs
%   TF - true if first input contains second input, otherwise false
%
% Examples
%   >> contains('hello', 'foo')    % ans = false
%   >> contains('hello', 'll')     % ans = true
