%positionShouldBeIgnored Determines if the deviation of 'Position' of the
%given elements should be ignored.
%
%   tf = positionShouldBeIgnored(oldElement, newElement, parameterName)
%   determines if differences of the parameters 'Position' of subsystems,
%   port blocks and ports in the TL simulation frame should be ignored.
%   These differences are caused by calling the TL operation tl_check_ports
%   in different TL versions and lead to failures in the test runs that
%   should be ignored by the test framework.
%
%   The function returns true if parameterName is 'Position', the elements
%   to be compared (oldElement and newElement) are subsystems, port blocks
%   or ports in the TL simulation frame, and the deviation of 'Position' is
%   not greater than 50 pixels (this is the greatest deviation observed in
%   the test runs so far and can be adjusted if necessary). Any amount of
%   deviation is ignored if the TatgetLink version is 5.2, 22.1 or 23.1.
