% result = ini2struct(fileNames)
%
% This function parses *.ini files fileNames and returns them as a
% structure with section names and keys as fields. fileNames can be a
% single file name or a cell array containing various file names.
%
% Sections from *.ini files are returned as fields of result structure.
% Each field contains a structure of the keys and values.
%
% Key value pairs at the beginning of a *.ini file, not belonging to a
% section are returned as fields of the result struct.
%
% Lines starting with ';' and '#' are ignored (comments).
%
% The ini2struct function uses the GENVARNAME to convert names into
% valid fieldnames
%
% [ example.ini ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
%
%     VarWithNoSection1=Foo
%     VarWithNoSection2=Baa
%     [General]
%     FirstGen = nice stuff
%     lastGen = c:\MyFolder\MyFile.txt
%     MagicNumber = 2
%     [1st section]
%     param1 = val1
%     Param 2 = Val 2
%     [Section #2]
%     param1 = val1
%     Param 2 = Val 2
%
% ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
%
% The function converts this INI file it to the following structure:
%
% [ MatLab session (R2018a) ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
%  >> result = ini2struct('example.ini')
%  >> disp(result)
%       varwithnosection1: 'Foo'
%       varwithnosection2: 'Baa'
%                 general: [1x1 struct]
%             x1stSection: [1x1 struct]
%            section0x232: [1x1 struct]
%
%  >> disp(result.general)
%                 firstgen: 'nice stuff'
%                  lastgen: 'c:\MyFolder\MyFile.txt'
%              magicnumber: '2'
%
%  >> disp(result.x1stSection)
%         param1: 'val1'
%         param2: 'Val 2'
%
%  >> disp(result.section0x232)
%         param1: 'val1'
%         param2: 'Val 2'
%
