/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_emf.ecore.resource.impl;

import com.modelengineers.MoRe_emf.common.util.URI;
import com.modelengineers.MoRe_emf.ecore.resource.ContentHandler;
import com.modelengineers.MoRe_emf.ecore.resource.impl.ContentHandlerImpl;
import com.modelengineers.MoRe_emf.ecore.resource.impl.PlatformResourceURIHandlerImpl;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlatformContentHandlerImpl
extends ContentHandlerImpl {
    private static final Map<String, QualifiedName> PROPERTY_CACHE = new HashMap<String, QualifiedName>();

    protected QualifiedName getQualifiedName(String property) {
        QualifiedName result = PROPERTY_CACHE.get(property);
        if (result == null) {
            int index = property.lastIndexOf(":");
            result = index == -1 ? new QualifiedName(null, property) : new QualifiedName(property.substring(0, index), property.substring(index + 1));
            PROPERTY_CACHE.put(property, result);
        }
        return result;
    }

    protected Object getDescriptionValue(QualifiedName qualifiedName, Object value) {
        if (value == null) {
            return null;
        }
        if (IContentDescription.BYTE_ORDER_MARK.equals((Object)qualifiedName)) {
            ContentHandler.ByteOrderMark[] byteOrderMarkArray = ContentHandler.ByteOrderMark.values();
            int n = byteOrderMarkArray.length;
            int n2 = 0;
            while (n2 < n) {
                ContentHandler.ByteOrderMark byteOrderMarker = byteOrderMarkArray[n2];
                if (value == byteOrderMarker.bytes()) {
                    return byteOrderMarker;
                }
                ++n2;
            }
            return null;
        }
        return value;
    }

    @Override
    public Map<String, Object> contentDescription(URI uri, InputStream inputStream, Map<?, ?> options, Map<Object, Object> context) throws IOException {
        IContentDescription contentDescription;
        try {
            contentDescription = uri.isPlatformResource() && PlatformResourceURIHandlerImpl.workspaceRoot != null ? PlatformResourceURIHandlerImpl.WorkbenchHelper.getContentDescription(uri.toPlatformString(true), options) : Platform.getContentTypeManager().getDescriptionFor(inputStream, uri.lastSegment(), IContentDescription.ALL);
        }
        catch (Throwable exception) {
            return super.contentDescription(uri, inputStream, options, context);
        }
        if (contentDescription == null) {
            return INVALID_CONTENT_DESCRIPTION;
        }
        Map<String, Object> result = PlatformContentHandlerImpl.createContentDescription(ContentHandler.Validity.VALID);
        result.put("com.modelengineers.MoRe_emf.ecore:contentType", contentDescription.getContentType().getId());
        Set<String> requestedProperties = this.getRequestedProperties(options);
        if (requestedProperties == null) {
            Object lineDelimiter;
            Object charset;
            Object bom = this.getDescriptionValue(IContentDescription.BYTE_ORDER_MARK, contentDescription.getProperty(IContentDescription.BYTE_ORDER_MARK));
            if (bom != null) {
                result.put("org.eclipse.core.runtime:bom", bom);
            }
            if ((charset = this.getDescriptionValue(IContentDescription.CHARSET, contentDescription.getProperty(IContentDescription.CHARSET))) != null) {
                result.put("org.eclipse.core.runtime:charset", charset);
            }
            if ((lineDelimiter = this.getDescriptionValue(ContentHandlerImpl.Describer.LINE_DELIMITER, contentDescription.getProperty(ContentHandlerImpl.Describer.LINE_DELIMITER))) == null) {
                lineDelimiter = this.getLineDelimiter(uri, inputStream, options, context);
            }
            if (lineDelimiter != null) {
                result.put("com.modelengineers.MoRe_emf.ecore:lineDelimiter", lineDelimiter);
            }
        } else {
            for (String property : requestedProperties) {
                Object value;
                if ("com.modelengineers.MoRe_emf.ecore:lineDelimiter".equals(property)) {
                    Object lineDelimiter = this.getDescriptionValue(ContentHandlerImpl.Describer.LINE_DELIMITER, contentDescription.getProperty(ContentHandlerImpl.Describer.LINE_DELIMITER));
                    if (lineDelimiter == null) {
                        lineDelimiter = this.getLineDelimiter(uri, inputStream, options, context);
                    }
                    if (lineDelimiter == null) continue;
                    result.put(property, lineDelimiter);
                    continue;
                }
                QualifiedName qualifiedName = this.getQualifiedName(property);
                if (qualifiedName == null || (value = this.getDescriptionValue(qualifiedName, contentDescription.getProperty(qualifiedName))) == null) continue;
                result.put(property, value);
            }
        }
        return result;
    }

    @Override
    protected String getCharset(URI uri, InputStream inputStream, Map<?, ?> options, Map<Object, Object> context) throws IOException {
        if (uri.isPlatformResource() && PlatformResourceURIHandlerImpl.workspaceRoot != null) {
            return PlatformResourceURIHandlerImpl.WorkbenchHelper.getCharset(uri.toPlatformString(true), options);
        }
        return super.getCharset(uri, inputStream, options, context);
    }

    @Override
    protected String getLineDelimiter(URI uri, InputStream inputStream, Map<?, ?> options, Map<Object, Object> context) throws IOException {
        if (uri.isPlatformResource() && PlatformResourceURIHandlerImpl.workspaceRoot != null) {
            return PlatformResourceURIHandlerImpl.WorkbenchHelper.getLineDelimiter(uri.toPlatformString(true), options);
        }
        return super.getCharset(uri, inputStream, options, context);
    }
}

