/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_emf.ecore.plugin;

import com.modelengineers.MoRe_emf.ecore.EValidator;
import com.modelengineers.MoRe_emf.ecore.plugin.EcorePlugin;
import com.modelengineers.MoRe_emf.ecore.plugin.RegistryReader;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.RegistryFactory;

class ValidationDelegateRegistryReader
extends RegistryReader {
    static final String TAG_DELEGATE = "delegate";
    static final String ATT_URI = "uri";
    static final String ATT_CLASS = "class";

    public ValidationDelegateRegistryReader() {
        super(RegistryFactory.getRegistry(), EcorePlugin.INSTANCE.getSymbolicName(), "validation_delegate");
    }

    protected boolean readElement(IConfigurationElement element, boolean add) {
        if (element.getName().equals(TAG_DELEGATE)) {
            String uri = element.getAttribute(ATT_URI);
            if (uri == null) {
                this.logMissingAttribute(element, ATT_URI);
            } else if (element.getAttribute(ATT_CLASS) == null) {
                this.logMissingAttribute(element, ATT_CLASS);
            } else {
                if (add) {
                    ValidationDelegateDescriptor previous = EValidator.ValidationDelegate.Registry.INSTANCE.put(uri, new ValidationDelegateDescriptor(element, ATT_CLASS));
                    if (previous instanceof ValidationDelegateDescriptor) {
                        ValidationDelegateDescriptor descriptor = previous;
                        EcorePlugin.INSTANCE.log("Both '" + descriptor.element.getContributor().getName() + "' and '" + element.getContributor().getName() + "' register a validation delegate for '" + uri + "'");
                    }
                    return true;
                }
                EValidator.ValidationDelegate.Registry.INSTANCE.remove(uri);
                return true;
            }
        }
        return false;
    }

    static class ValidationDelegateDescriptor
    extends RegistryReader.PluginClassDescriptor
    implements EValidator.ValidationDelegate.Descriptor {
        protected EValidator.ValidationDelegate validationDelegate;

        public ValidationDelegateDescriptor(IConfigurationElement e, String attrName) {
            super(e, attrName);
        }

        public EValidator.ValidationDelegate getValidationDelegate() {
            if (this.validationDelegate == null) {
                this.validationDelegate = (EValidator.ValidationDelegate)this.createInstance();
            }
            return this.validationDelegate;
        }
    }
}

