/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_emf.common.util;

import com.modelengineers.MoRe_emf.common.util.CommonUtil;
import com.modelengineers.MoRe_emf.common.util.Pool;
import com.modelengineers.MoRe_emf.common.util.SegmentSequence;
import com.modelengineers.MoRe_emf.common.util.UniqueEList;
import com.modelengineers.MoRe_emf.common.util.WeakInterningHashSet;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class URI {
    protected static final boolean DEBUG = false;
    protected int hashCode;
    protected static final URIPool POOL = new URIPool(CommonUtil.REFERENCE_CLEARING_QUEUE);
    protected static final String[] ARCHIVE_SCHEMES;
    protected static final String SCHEME_FILE = "file";
    protected static final String SCHEME_JAR = "jar";
    protected static final String SCHEME_ZIP = "zip";
    protected static final String SCHEME_ARCHIVE = "archive";
    protected static final String SCHEME_PLATFORM = "platform";
    protected static final String SCHEME_HTTP = "http";
    protected static final int SCHEME_FILE_HASH_CODE;
    protected static final int SCHEME_JAR_HASH_CODE;
    protected static final int SCHEME_ZIP_HASH_CODE;
    protected static final int SCHEME_ARCHIVE_HASH_CODE;
    protected static final int SCHEME_PLATFORM_HASH_CODE;
    protected static final int SCHEME_HTTP_HASH_CODE;
    protected static final String SEGMENT_EMPTY = "";
    protected static final String SEGMENT_SELF = ".";
    protected static final String SEGMENT_PARENT = "..";
    protected static final String SEGMENT_PLUGIN = "plugin";
    protected static final String SEGMENT_RESOURCE = "resource";
    protected static final String[] NO_SEGMENTS;
    protected static final String[] ONE_EMPTY_SEGMENT;
    protected static final String[] ONE_SELF_SEGMENT;
    protected static final char SCHEME_SEPARATOR = ':';
    protected static final String AUTHORITY_SEPARATOR = "//";
    protected static final int AUTHORITY_SEPARATOR_HASH_CODE;
    protected static final char DEVICE_IDENTIFIER = ':';
    protected static final char SEGMENT_SEPARATOR = '/';
    protected static final char QUERY_SEPARATOR = '?';
    protected static final char FRAGMENT_SEPARATOR = '#';
    protected static final char USER_INFO_SEPARATOR = '@';
    protected static final char PORT_SEPARATOR = ':';
    protected static final char FILE_EXTENSION_SEPARATOR = '.';
    protected static final char ARCHIVE_IDENTIFIER = '!';
    protected static final String ARCHIVE_SEPARATOR = "!/";
    protected static final char ESCAPE = '%';
    protected static final char[] HEX_DIGITS;
    protected static final long ALPHA_HI;
    protected static final long ALPHA_LO;
    protected static final long DIGIT_HI;
    protected static final long DIGIT_LO;
    protected static final long ALPHANUM_HI;
    protected static final long ALPHANUM_LO;
    protected static final long HEX_HI;
    protected static final long HEX_LO;
    protected static final long UNRESERVED_HI;
    protected static final long UNRESERVED_LO;
    protected static final long RESERVED_HI;
    protected static final long RESERVED_LO;
    protected static final long URIC_HI;
    protected static final long URIC_LO;
    protected static final long SEGMENT_CHAR_HI;
    protected static final long SEGMENT_CHAR_LO;
    protected static final long PATH_CHAR_HI;
    protected static final long PATH_CHAR_LO;
    protected static final long MAJOR_SEPARATOR_HI;
    protected static final long MAJOR_SEPARATOR_LO;
    protected static final long SEGMENT_END_HI;
    protected static final long SEGMENT_END_LO;
    protected static final long PLATFORM_SEGMENT_RESERVED_HI;
    protected static final long PLATFORM_SEGMENT_RESERVED_LO;
    protected static final boolean ENCODE_PLATFORM_RESOURCE_URIS;
    public static final int FRAGMENT_NONE = 0;
    public static final int FRAGMENT_FIRST_SEPARATOR = 1;
    public static final int FRAGMENT_LAST_SEPARATOR = 2;

    static {
        SCHEME_FILE_HASH_CODE = SCHEME_FILE.hashCode();
        SCHEME_JAR_HASH_CODE = SCHEME_JAR.hashCode();
        SCHEME_ZIP_HASH_CODE = SCHEME_ZIP.hashCode();
        SCHEME_ARCHIVE_HASH_CODE = SCHEME_ARCHIVE.hashCode();
        SCHEME_PLATFORM_HASH_CODE = SCHEME_PLATFORM.hashCode();
        SCHEME_HTTP_HASH_CODE = SCHEME_HTTP.hashCode();
        CommonUtil.STRING_POOL.javaIntern(SCHEME_FILE);
        CommonUtil.STRING_POOL.javaIntern(SCHEME_JAR);
        CommonUtil.STRING_POOL.javaIntern(SCHEME_ZIP);
        CommonUtil.STRING_POOL.javaIntern(SCHEME_ARCHIVE);
        CommonUtil.STRING_POOL.javaIntern(SCHEME_PLATFORM);
        CommonUtil.STRING_POOL.javaIntern(SCHEME_HTTP);
        CommonUtil.STRING_POOL.javaIntern(SEGMENT_EMPTY);
        CommonUtil.STRING_POOL.javaIntern(SEGMENT_SELF);
        CommonUtil.STRING_POOL.javaIntern(SEGMENT_PARENT);
        CommonUtil.STRING_POOL.javaIntern(SEGMENT_PLUGIN);
        CommonUtil.STRING_POOL.javaIntern(SEGMENT_RESOURCE);
        NO_SEGMENTS = SegmentSequence.EMPTY_ARRAY;
        ONE_EMPTY_SEGMENT = SegmentSequence.EMPTY_STRING_ARRAY;
        ONE_SELF_SEGMENT = SegmentSequence.STRING_ARRAY_POOL.intern(SEGMENT_SELF, false);
        AUTHORITY_SEPARATOR_HASH_CODE = AUTHORITY_SEPARATOR.hashCode();
        HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        ALPHA_HI = URI.highBitmask('a', 'z') | URI.highBitmask('A', 'Z');
        ALPHA_LO = URI.lowBitmask('a', 'z') | URI.lowBitmask('A', 'Z');
        DIGIT_HI = URI.highBitmask('0', '9');
        DIGIT_LO = URI.lowBitmask('0', '9');
        ALPHANUM_HI = ALPHA_HI | DIGIT_HI;
        ALPHANUM_LO = ALPHA_LO | DIGIT_LO;
        HEX_HI = DIGIT_HI | URI.highBitmask('A', 'F') | URI.highBitmask('a', 'f');
        HEX_LO = DIGIT_LO | URI.lowBitmask('A', 'F') | URI.lowBitmask('a', 'f');
        UNRESERVED_HI = ALPHANUM_HI | URI.highBitmask("-_.!~*'()");
        UNRESERVED_LO = ALPHANUM_LO | URI.lowBitmask("-_.!~*'()");
        RESERVED_HI = URI.highBitmask(";/?:@&=+$,");
        RESERVED_LO = URI.lowBitmask(";/?:@&=+$,");
        URIC_HI = RESERVED_HI | UNRESERVED_HI;
        URIC_LO = RESERVED_LO | UNRESERVED_LO;
        SEGMENT_CHAR_HI = UNRESERVED_HI | URI.highBitmask(";:@&=+$,");
        SEGMENT_CHAR_LO = UNRESERVED_LO | URI.lowBitmask(";:@&=+$,");
        PATH_CHAR_HI = SEGMENT_CHAR_HI | URI.highBitmask('/');
        PATH_CHAR_LO = SEGMENT_CHAR_LO | URI.lowBitmask('/');
        MAJOR_SEPARATOR_HI = URI.highBitmask(":/?#");
        MAJOR_SEPARATOR_LO = URI.lowBitmask(":/?#");
        SEGMENT_END_HI = URI.highBitmask("/?#");
        SEGMENT_END_LO = URI.lowBitmask("/?#");
        PLATFORM_SEGMENT_RESERVED_HI = URI.highBitmask("/?#\\");
        PLATFORM_SEGMENT_RESERVED_LO = URI.lowBitmask("/?#\\");
        ENCODE_PLATFORM_RESOURCE_URIS = System.getProperty("com.modelengineers.MoRe_emf.common.util.URI.encodePlatformResourceURIs") != null && !"false".equalsIgnoreCase(System.getProperty("com.modelengineers.MoRe_emf.common.util.URI.encodePlatformResourceURIs"));
        UniqueEList<String> list = new UniqueEList<String>();
        String propertyValue = System.getProperty("com.modelengineers.MoRe_emf.common.util.URI.archiveSchemes");
        list.add(SCHEME_JAR);
        list.add(SCHEME_ZIP);
        list.add(SCHEME_ARCHIVE);
        if (propertyValue != null) {
            StringTokenizer t = new StringTokenizer(propertyValue);
            while (t.hasMoreTokens()) {
                String token = t.nextToken().toLowerCase();
                if (!URI.validScheme(token)) continue;
                String scheme = CommonUtil.javaIntern(token);
                list.add(scheme);
            }
        }
        ARCHIVE_SCHEMES = list.toArray(new String[list.size()]);
    }

    protected static long lowBitmask(char c) {
        return c < '@' ? 1L << c : 0L;
    }

    protected static long highBitmask(char c) {
        return c >= '@' && c < '\u0080' ? 1L << c - 64 : 0L;
    }

    protected static long lowBitmask(char from, char to) {
        long result = 0L;
        if (from < '@' && from <= to) {
            to = to < '@' ? to : (char)'?';
            char c = from;
            while (c <= to) {
                result |= 1L << c;
                c = (char)(c + '\u0001');
            }
        }
        return result;
    }

    protected static long highBitmask(char from, char to) {
        return to < '@' ? 0L : URI.lowBitmask((char)(from < '@' ? 0 : from - 64), (char)(to - 64));
    }

    protected static long lowBitmask(String chars) {
        long result = 0L;
        int i = 0;
        int len = chars.length();
        while (i < len) {
            char c = chars.charAt(i);
            if (c < '@') {
                result |= 1L << c;
            }
            ++i;
        }
        return result;
    }

    protected static long highBitmask(String chars) {
        long result = 0L;
        int i = 0;
        int len = chars.length();
        while (i < len) {
            char c = chars.charAt(i);
            if (c >= '@' && c < '\u0080') {
                result |= 1L << c - 64;
            }
            ++i;
        }
        return result;
    }

    protected static boolean matches(char c, long highBitmask, long lowBitmask) {
        if (c >= '\u0080') {
            return false;
        }
        return c < '@' ? (1L << c & lowBitmask) != 0L : (1L << c - 64 & highBitmask) != 0L;
    }

    public static URI createGenericURI(String scheme, String opaquePart, String fragment) {
        if (scheme == null) {
            throw new IllegalArgumentException("relative non-hierarchical URI");
        }
        if (URI.isArchiveScheme(scheme)) {
            throw new IllegalArgumentException("non-hierarchical archive URI");
        }
        return POOL.intern(false, -2, false, scheme, opaquePart, null, false, null, null).appendFragment(fragment);
    }

    public static URI createHierarchicalURI(String scheme, String authority, String device, String query, String fragment) {
        if (scheme != null && authority == null && device == null) {
            throw new IllegalArgumentException("absolute hierarchical URI without authority, device, path");
        }
        if (URI.isArchiveScheme(scheme)) {
            throw new IllegalArgumentException("archive URI with no path");
        }
        return POOL.intern(false, -2, true, scheme, authority, device, false, NO_SEGMENTS, query).appendFragment(fragment);
    }

    public static URI createHierarchicalURI(String scheme, String authority, String device, String[] segments, String query, String fragment) {
        if (device != null) {
            if (URI.isArchiveScheme(scheme)) {
                throw new IllegalArgumentException("archive URI with device");
            }
            if (SCHEME_PLATFORM.equals(scheme)) {
                throw new IllegalArgumentException("platform URI with device");
            }
        }
        return POOL.intern(false, -2, true, scheme, authority, device, true, segments, query).appendFragment(fragment);
    }

    public static URI createHierarchicalURI(String[] segments, String query, String fragment) {
        return POOL.intern(false, -2, true, null, null, null, false, segments, query).appendFragment(fragment);
    }

    public static URI createURI(String uri) {
        return URI.createURIWithCache(uri);
    }

    public static URI createURI(String uri, boolean ignoreEscaped) {
        return URI.createURIWithCache(URI.encodeURI(uri, ignoreEscaped, 2));
    }

    public static URI createURI(String uri, boolean ignoreEscaped, int fragmentLocationStyle) {
        return URI.createURIWithCache(URI.encodeURI(uri, ignoreEscaped, fragmentLocationStyle));
    }

    @Deprecated
    public static URI createDeviceURI(String uri) {
        return URI.createURIWithCache(uri);
    }

    @Deprecated
    public static URI createURIWithCache(String uri) {
        int index = uri.indexOf(35);
        return index == -1 ? POOL.intern(uri) : POOL.intern(uri.substring(0, index)).appendFragment(uri.substring(index + 1));
    }

    public static URI createFileURI(String pathName) {
        return POOL.internFile(pathName);
    }

    @Deprecated
    public static URI createPlatformResourceURI(String pathName) {
        return URI.createPlatformResourceURI(pathName, ENCODE_PLATFORM_RESOURCE_URIS);
    }

    public static URI createPlatformResourceURI(String pathName, boolean encode) {
        return POOL.intern(SEGMENT_RESOURCE, pathName, encode);
    }

    public static URI createPlatformPluginURI(String pathName, boolean encode) {
        return POOL.intern(SEGMENT_PLUGIN, pathName, encode);
    }

    protected static CharSequence splitInternFragment(String fragment) {
        if (fragment.length() > 0 && fragment.charAt(0) == '/') {
            return SegmentSequence.create("/", fragment);
        }
        return CommonUtil.intern(fragment);
    }

    protected URI(int hashCode) {
        this.hashCode = hashCode;
    }

    protected static boolean validateURI(boolean hierarchical, String scheme, String authority, String device, boolean absolutePath, String[] segments, String query, String fragment) {
        if (!URI.validScheme(scheme)) {
            throw new IllegalArgumentException("invalid scheme: " + scheme);
        }
        if (!hierarchical) {
            if (!URI.validOpaquePart(authority)) {
                throw new IllegalArgumentException("invalid opaquePart: " + authority);
            }
        } else {
            if (URI.isArchiveScheme(scheme) ? !URI.validArchiveAuthority(authority) : !URI.validAuthority(authority)) {
                throw new IllegalArgumentException("invalid authority: " + authority);
            }
            if (!URI.validSegments(segments)) {
                String s = segments == null ? "invalid segments: null" : "invalid segment: " + URI.firstInvalidSegment(segments);
                throw new IllegalArgumentException(s);
            }
        }
        if (!URI.validDevice(device)) {
            throw new IllegalArgumentException("invalid device: " + device);
        }
        if (!URI.validQuery(query)) {
            throw new IllegalArgumentException("invalid query: " + query);
        }
        if (!URI.validFragment(fragment)) {
            throw new IllegalArgumentException("invalid fragment: " + fragment);
        }
        return true;
    }

    public static boolean validScheme(String value) {
        return value == null || !URI.contains(value, MAJOR_SEPARATOR_HI, MAJOR_SEPARATOR_LO);
    }

    public static boolean validOpaquePart(String value) {
        return value != null && value.indexOf(35) == -1 && value.length() > 0 && value.charAt(0) != '/';
    }

    public static boolean validAuthority(String value) {
        return value == null || !URI.contains(value, SEGMENT_END_HI, SEGMENT_END_LO);
    }

    public static boolean validArchiveAuthority(String value) {
        if (value != null && value.length() > 0 && value.charAt(value.length() - 1) == '!') {
            try {
                URI archiveURI = URI.createURI(value.substring(0, value.length() - 1));
                return !archiveURI.hasFragment();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return false;
    }

    @Deprecated
    public static boolean validJarAuthority(String value) {
        return URI.validArchiveAuthority(value);
    }

    public static boolean validDevice(String value) {
        if (value == null) {
            return true;
        }
        int len = value.length();
        return len > 0 && value.charAt(len - 1) == ':' && !URI.contains(value, SEGMENT_END_HI, SEGMENT_END_LO);
    }

    public static boolean validSegment(String value) {
        return value != null && !URI.contains(value, SEGMENT_END_HI, SEGMENT_END_LO);
    }

    public static boolean validSegments(String[] value) {
        if (value == null) {
            return false;
        }
        int i = 0;
        int len = value.length;
        while (i < len) {
            if (!URI.validSegment(value[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected static String firstInvalidSegment(String[] value) {
        if (value == null) {
            return null;
        }
        int i = 0;
        int len = value.length;
        while (i < len) {
            if (!URI.validSegment(value[i])) {
                return value[i];
            }
            ++i;
        }
        return null;
    }

    public static boolean validQuery(String value) {
        return value == null || value.indexOf(35) == -1;
    }

    public static boolean validFragment(String value) {
        return true;
    }

    protected static boolean contains(String s, long highBitmask, long lowBitmask) {
        int i = 0;
        int len = s.length();
        while (i < len) {
            if (URI.matches(s.charAt(i), highBitmask, lowBitmask)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void flushCachedString() {
    }

    protected void cacheString(String string) {
    }

    protected String getCachedString() {
        return null;
    }

    public boolean isRelative() {
        return false;
    }

    protected boolean isBase() {
        return false;
    }

    public boolean isHierarchical() {
        return false;
    }

    public boolean hasAuthority() {
        return false;
    }

    public boolean hasOpaquePart() {
        return false;
    }

    public boolean hasDevice() {
        return false;
    }

    protected boolean hasDeviceOrPath() {
        return false;
    }

    public boolean hasPath() {
        return false;
    }

    public boolean hasAbsolutePath() {
        return false;
    }

    public boolean hasRelativePath() {
        return false;
    }

    public boolean hasEmptyPath() {
        return false;
    }

    public boolean hasQuery() {
        return false;
    }

    public boolean hasFragment() {
        return false;
    }

    public boolean isCurrentDocumentReference() {
        return false;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isFile() {
        return false;
    }

    public boolean isPlatform() {
        return false;
    }

    public boolean isPlatformResource() {
        return false;
    }

    public boolean isPlatformPlugin() {
        return false;
    }

    public boolean isArchive() {
        return false;
    }

    public static boolean isArchiveScheme(String value) {
        String[] stringArray = ARCHIVE_SCHEMES;
        int n = ARCHIVE_SCHEMES.length;
        int n2 = 0;
        while (n2 < n) {
            String scheme = stringArray[n2];
            if (scheme.equals(value)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    protected boolean segmentsEqual(URI uri) {
        return false;
    }

    protected static boolean equals(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }

    public String scheme() {
        return null;
    }

    public String opaquePart() {
        return null;
    }

    public String authority() {
        return null;
    }

    public String userInfo() {
        return null;
    }

    public String host() {
        return null;
    }

    public String port() {
        return null;
    }

    public String device() {
        return null;
    }

    public String[] segments() {
        return NO_SEGMENTS;
    }

    protected String[] rawSegments() {
        return NO_SEGMENTS;
    }

    public List<String> segmentsList() {
        return Collections.emptyList();
    }

    public int segmentCount() {
        return 0;
    }

    public String segment(int i) {
        throw new IndexOutOfBoundsException("No such segment: " + i);
    }

    public String lastSegment() {
        return null;
    }

    public String path() {
        return null;
    }

    public String devicePath() {
        return null;
    }

    public String query() {
        return null;
    }

    public URI appendQuery(String query) {
        if (!URI.validQuery(query)) {
            throw new IllegalArgumentException("invalid query portion: " + query);
        }
        return this;
    }

    public URI trimQuery() {
        return this;
    }

    public String fragment() {
        return null;
    }

    public URI appendFragment(String fragment) {
        if (fragment == null) {
            return this;
        }
        if (URI.POOL.externalQueue != null) {
            Fragment result = new Fragment(0, this, fragment);
            new LazyFragmentInitializer(result, URI.POOL.externalQueue, fragment);
            return result;
        }
        int hashCode = (this.hashCode * 31 + 35) * CommonUtil.powerOf31(fragment.length()) + fragment.hashCode();
        return new Fragment(hashCode, this, URI.splitInternFragment(fragment));
    }

    protected URI rawAppendFragment(CharSequence fragment) {
        if (fragment == null) {
            return this;
        }
        int hashCode = (this.hashCode * 31 + 35) * CommonUtil.powerOf31(fragment.length()) + fragment.hashCode();
        return new Fragment(hashCode, this, fragment);
    }

    public URI trimFragment() {
        return this;
    }

    public URI resolve(URI base) {
        return this.resolve(base, true);
    }

    public URI resolve(URI base, boolean preserveRootParents) {
        if (!base.isHierarchical() || base.isRelative()) {
            throw new IllegalArgumentException("resolve against non-hierarchical or relative base");
        }
        return this;
    }

    public URI deresolve(URI base) {
        return this.deresolve(base, true, false, true);
    }

    public URI deresolve(URI base, boolean preserveRootParents, boolean anyRelPath, boolean shorterRelPath) {
        return this;
    }

    protected String[] collapseSegments(boolean preserveRootParents) {
        return NO_SEGMENTS;
    }

    protected boolean matches(String string) {
        return false;
    }

    protected boolean matches(int validate, boolean hierarchical, String scheme, String authority, String device, boolean absolutePath, String[] segments, String query) {
        return false;
    }

    protected boolean matches(String base, String path) {
        return false;
    }

    public String toFileString() {
        return null;
    }

    public String toPlatformString(boolean decode) {
        return null;
    }

    public URI appendSegment(String segment) {
        if (!URI.validSegment(segment)) {
            throw new IllegalArgumentException("invalid segment: " + segment);
        }
        return this;
    }

    public URI appendSegments(String[] segments) {
        if (!URI.validSegments(segments)) {
            String s = segments == null ? "invalid segments: null" : "invalid segment: " + URI.firstInvalidSegment(segments);
            throw new IllegalArgumentException(s);
        }
        return this;
    }

    public URI trimSegments(int i) {
        return this;
    }

    public boolean hasTrailingPathSeparator() {
        return false;
    }

    public String fileExtension() {
        return null;
    }

    public URI appendFileExtension(String fileExtension) {
        if (!URI.validSegment(fileExtension)) {
            throw new IllegalArgumentException("invalid segment portion: " + fileExtension);
        }
        return this;
    }

    public URI trimFileExtension() {
        return this;
    }

    public boolean isPrefix() {
        return false;
    }

    public URI replacePrefix(URI oldPrefix, URI newPrefix) {
        if (!oldPrefix.isPrefix() || !newPrefix.isPrefix()) {
            String which = oldPrefix.isPrefix() ? "new" : "old";
            throw new IllegalArgumentException("non-prefix " + which + " value");
        }
        return null;
    }

    public static String encodeOpaquePart(String value, boolean ignoreEscaped) {
        String result = URI.encode(value, URIC_HI, URIC_LO, ignoreEscaped);
        return result != null && result.length() > 0 && result.charAt(0) == '/' ? "%2F" + result.substring(1) : result;
    }

    public static String encodeAuthority(String value, boolean ignoreEscaped) {
        return URI.encode(value, SEGMENT_CHAR_HI, SEGMENT_CHAR_LO, ignoreEscaped);
    }

    public static String encodeSegment(String value, boolean ignoreEscaped) {
        return URI.encode(value, SEGMENT_CHAR_HI, SEGMENT_CHAR_LO, ignoreEscaped);
    }

    public static String encodeQuery(String value, boolean ignoreEscaped) {
        return URI.encode(value, URIC_HI, URIC_LO, ignoreEscaped);
    }

    public static String encodeFragment(String value, boolean ignoreEscaped) {
        return URI.encode(value, URIC_HI, URIC_LO, ignoreEscaped);
    }

    protected static String encodeURI(String uri, boolean ignoreEscaped, int fragmentLocationStyle) {
        int j;
        if (uri == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        int i = uri.indexOf(58);
        if (i != -1) {
            String scheme = uri.substring(0, i);
            result.append(scheme);
            result.append(':');
        }
        int n = fragmentLocationStyle == 1 ? uri.indexOf(35) : (j = fragmentLocationStyle == 2 ? uri.lastIndexOf(35) : -1);
        if (j != -1) {
            String sspart = uri.substring(++i, j);
            result.append(URI.encode(sspart, URIC_HI, URIC_LO, ignoreEscaped));
            result.append('#');
            String fragment = uri.substring(++j);
            result.append(URI.encode(fragment, URIC_HI, URIC_LO, ignoreEscaped));
        } else {
            String sspart = uri.substring(++i);
            result.append(URI.encode(sspart, URIC_HI, URIC_LO, ignoreEscaped));
        }
        return result.toString();
    }

    protected static String encode(String value, long highBitmask, long lowBitmask, boolean ignoreEscaped) {
        if (value == null) {
            return null;
        }
        StringBuffer result = null;
        int i = 0;
        int len = value.length();
        while (i < len) {
            char c = value.charAt(i);
            if (!(URI.matches(c, highBitmask, lowBitmask) || c >= '\u00a0' || ignoreEscaped && URI.isEscaped(value, i))) {
                if (result == null) {
                    result = new StringBuffer(value.substring(0, i));
                }
                URI.appendEscaped(result, (byte)c);
            } else if (result != null) {
                result.append(c);
            }
            ++i;
        }
        return result == null ? value : result.toString();
    }

    protected static boolean isEscaped(String s, int i) {
        return s.charAt(i) == '%' && s.length() > i + 2 && URI.matches(s.charAt(i + 1), HEX_HI, HEX_LO) && URI.matches(s.charAt(i + 2), HEX_HI, HEX_LO);
    }

    protected static void appendEscaped(StringBuffer result, byte b) {
        result.append('%');
        result.append(HEX_DIGITS[b >> 4 & 0xF]);
        result.append(HEX_DIGITS[b & 0xF]);
    }

    public static String decode(String value) {
        if (value == null) {
            return null;
        }
        int i = value.indexOf(37);
        if (i < 0) {
            return value;
        }
        StringBuilder result = new StringBuilder(value.substring(0, i));
        byte[] bytes = new byte[4];
        int receivedBytes = 0;
        int expectedBytes = 0;
        int len = value.length();
        while (i < len) {
            if (URI.isEscaped(value, i)) {
                char character = URI.unescape(value.charAt(i + 1), value.charAt(i + 2));
                i += 2;
                if (expectedBytes > 0) {
                    if ((character & 0xC0) == 128) {
                        bytes[receivedBytes++] = (byte)character;
                    } else {
                        expectedBytes = 0;
                    }
                } else if (character >= '\u0080') {
                    if ((character & 0xE0) == 192) {
                        bytes[receivedBytes++] = (byte)character;
                        expectedBytes = 2;
                    } else if ((character & 0xF0) == 224) {
                        bytes[receivedBytes++] = (byte)character;
                        expectedBytes = 3;
                    } else if ((character & 0xF8) == 240) {
                        bytes[receivedBytes++] = (byte)character;
                        expectedBytes = 4;
                    }
                }
                if (expectedBytes > 0) {
                    if (receivedBytes == expectedBytes) {
                        switch (receivedBytes) {
                            case 2: {
                                result.append((char)((bytes[0] & 0x1F) << 6 | bytes[1] & 0x3F));
                                break;
                            }
                            case 3: {
                                result.append((char)((bytes[0] & 0xF) << 12 | (bytes[1] & 0x3F) << 6 | bytes[2] & 0x3F));
                                break;
                            }
                            case 4: {
                                result.appendCodePoint((bytes[0] & 7) << 18 | (bytes[1] & 0x3F) << 12 | (bytes[2] & 0x3F) << 6 | bytes[3] & 0x3F);
                            }
                        }
                        receivedBytes = 0;
                        expectedBytes = 0;
                    }
                } else {
                    int j = 0;
                    while (j < receivedBytes) {
                        result.append((char)bytes[j]);
                        ++j;
                    }
                    receivedBytes = 0;
                    result.append(character);
                }
            } else {
                int j = 0;
                while (j < receivedBytes) {
                    result.append((char)bytes[j]);
                    ++j;
                }
                receivedBytes = 0;
                result.append(value.charAt(i));
            }
            ++i;
        }
        return result.toString();
    }

    protected static char unescape(char highHexDigit, char lowHexDigit) {
        return (char)(URI.valueOf(highHexDigit) << 4 | URI.valueOf(lowHexDigit));
    }

    protected static int valueOf(char hexDigit) {
        if (hexDigit <= '9') {
            if (hexDigit >= '0') {
                return hexDigit - 48;
            }
        } else if (hexDigit <= 'F') {
            if (hexDigit >= 'A') {
                return hexDigit - 65 + 10;
            }
        } else if (hexDigit >= 'a' && hexDigit <= 'f') {
            return hexDigit - 97 + 10;
        }
        return 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class Fragment
    extends URI {
        protected final URI uri;
        protected CharSequence fragment;

        protected Fragment(int hashCode, URI uri, CharSequence fragment) {
            super(hashCode);
            this.uri = uri;
            this.fragment = fragment;
            assert (fragment != null);
            assert (hashCode == 0 || hashCode == this.toString().hashCode());
        }

        @Override
        public boolean isRelative() {
            return this.uri.isRelative();
        }

        @Override
        protected boolean isBase() {
            return this.uri.isBase();
        }

        @Override
        public boolean isHierarchical() {
            return this.uri.isHierarchical();
        }

        @Override
        public boolean hasAuthority() {
            return this.uri.hasAuthority();
        }

        @Override
        public boolean hasOpaquePart() {
            return this.uri.hasOpaquePart();
        }

        @Override
        public boolean hasDevice() {
            return this.uri.hasDevice();
        }

        @Override
        public boolean hasPath() {
            return this.uri.hasPath();
        }

        @Override
        protected boolean hasDeviceOrPath() {
            return this.uri.hasDeviceOrPath();
        }

        @Override
        public boolean hasAbsolutePath() {
            return this.uri.hasAbsolutePath();
        }

        @Override
        public boolean hasRelativePath() {
            return this.uri.hasRelativePath();
        }

        @Override
        public boolean hasEmptyPath() {
            return this.uri.hasEmptyPath();
        }

        @Override
        public boolean hasQuery() {
            return this.uri.hasQuery();
        }

        @Override
        public boolean hasFragment() {
            return true;
        }

        @Override
        public boolean isCurrentDocumentReference() {
            return this.uri.isCurrentDocumentReference();
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean isFile() {
            return this.uri.isFile();
        }

        @Override
        public boolean isPlatform() {
            return this.uri.isPlatform();
        }

        @Override
        public boolean isPlatformResource() {
            return this.uri.isPlatformResource();
        }

        @Override
        public boolean isPlatformPlugin() {
            return this.uri.isPlatformPlugin();
        }

        @Override
        public boolean isArchive() {
            return this.uri.isArchive();
        }

        @Override
        protected boolean segmentsEqual(URI uri) {
            return uri.segmentsEqual(uri);
        }

        @Override
        public String scheme() {
            return this.uri.scheme();
        }

        @Override
        public String opaquePart() {
            return this.uri.opaquePart();
        }

        @Override
        public String authority() {
            return this.uri.authority();
        }

        @Override
        public String userInfo() {
            return this.uri.userInfo();
        }

        @Override
        public String host() {
            return this.uri.host();
        }

        @Override
        public String port() {
            return this.uri.port();
        }

        @Override
        public String device() {
            return this.uri.device();
        }

        @Override
        public String[] segments() {
            return this.uri.segments();
        }

        @Override
        protected String[] rawSegments() {
            return this.uri.rawSegments();
        }

        @Override
        public List<String> segmentsList() {
            return this.uri.segmentsList();
        }

        @Override
        public int segmentCount() {
            return this.uri.segmentCount();
        }

        @Override
        public String segment(int i) {
            return this.uri.segment(i);
        }

        @Override
        public String lastSegment() {
            return this.uri.lastSegment();
        }

        @Override
        public String path() {
            return this.uri.path();
        }

        @Override
        public String devicePath() {
            return this.uri.devicePath();
        }

        @Override
        public String query() {
            return this.uri.query();
        }

        private URI appendFragment(URI uri) {
            return this.hashCode == 0 ? uri.appendFragment(this.fragment.toString()) : uri.rawAppendFragment(this.fragment);
        }

        @Override
        public URI appendQuery(String query) {
            return this.appendFragment(this.uri.appendQuery(query));
        }

        @Override
        public URI trimQuery() {
            URI result = this.uri.trimQuery();
            return result == this.uri ? this : this.appendFragment(result);
        }

        @Override
        public String fragment() {
            if (this.hashCode == 0) {
                this.hashCode();
            }
            return this.fragment.toString();
        }

        @Override
        public URI appendFragment(String fragment) {
            return this.uri.appendFragment(fragment);
        }

        @Override
        public URI trimFragment() {
            return this.uri;
        }

        @Override
        public URI resolve(URI base, boolean preserveRootParents) {
            URI result = this.uri.resolve(base, preserveRootParents);
            return result == this.uri ? this : this.appendFragment(result);
        }

        @Override
        public URI deresolve(URI base, boolean preserveRootParents, boolean anyRelPath, boolean shorterRelPath) {
            URI result = this.uri.deresolve(base, preserveRootParents, anyRelPath, shorterRelPath);
            return result == this.uri ? this : this.appendFragment(result);
        }

        @Override
        protected String[] collapseSegments(boolean preserveRootParents) {
            return this.uri.collapseSegments(preserveRootParents);
        }

        public String toString() {
            CommonUtil.StringPool.StringsAccessUnit result = CommonUtil.STRING_POOL.getStringBuilder();
            result.append(this.uri.toString());
            result.append('#');
            result.append(this.fragment);
            return CommonUtil.STRING_POOL.intern(result);
        }

        @Override
        public int hashCode() {
            if (this.hashCode == 0) {
                this.hashCode = (this.uri.hashCode * 31 + 35) * CommonUtil.powerOf31(this.fragment.length()) + this.fragment.hashCode();
                if (this.fragment instanceof String) {
                    this.fragment = Fragment.splitInternFragment(this.fragment.toString());
                }
            }
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Fragment)) {
                return false;
            }
            Fragment that = (Fragment)object;
            return this.uri == that.uri && (this.fragment == that.fragment || this.fragment.toString().equals(that.fragment().toString()));
        }

        @Override
        public String toFileString() {
            return this.uri.toFileString();
        }

        @Override
        public String toPlatformString(boolean decode) {
            return this.uri.toPlatformString(decode);
        }

        @Override
        public URI appendSegment(String segment) {
            URI result = this.uri.appendSegment(segment);
            return result == this.uri ? this : this.appendFragment(result);
        }

        @Override
        public URI appendSegments(String[] segments) {
            URI result = this.uri.appendSegments(segments);
            return result == this.uri ? this : this.appendFragment(result);
        }

        @Override
        public URI trimSegments(int i) {
            URI result = this.uri.trimSegments(i);
            return result == this.uri ? this : this.appendFragment(result);
        }

        @Override
        public boolean hasTrailingPathSeparator() {
            return this.uri.hasTrailingPathSeparator();
        }

        @Override
        public String fileExtension() {
            return this.uri.fileExtension();
        }

        @Override
        public URI appendFileExtension(String fileExtension) {
            URI result = this.uri.appendFileExtension(fileExtension);
            return result == this.uri ? this : this.appendFragment(result);
        }

        @Override
        public URI trimFileExtension() {
            URI result = this.uri.trimFileExtension();
            return result == this.uri ? this : result.rawAppendFragment(this.fragment);
        }

        @Override
        public URI replacePrefix(URI oldPrefix, URI newPrefix) {
            URI result = this.uri.replacePrefix(oldPrefix, newPrefix);
            return result == this.uri ? this : (result == null ? null : this.appendFragment(result));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class Hierarchical
    extends URI {
        protected static final int HAS_ABSOLUTE_PATH = 1;
        protected static final int HAS_RELATIVE_PATH = 2;
        protected static final int HAS_EMPTY_PATH = 4;
        protected static final int IS_CURRENT_DOCUMENT_REFERENCE = 8;
        protected static final int IS_FILE = 16;
        protected static final int IS_PLATFORM = 32;
        protected static final int IS_PLATFORM_RESOURCE = 64;
        protected static final int IS_PLATFORM_PLUGIN = 128;
        protected static final int IS_ARCHIVE = 256;
        protected static final int HAS_TRAILING_PATH_SEPARATOR = 512;
        protected static final int IS_PREFIX = 1024;
        protected static final int HAS_PATH = 3;
        protected final int flags;
        protected final String scheme;
        protected final String authority;
        protected final String device;
        protected final String[] segments;
        protected final String query;
        protected WeakReference<String> toString;

        protected Hierarchical(int hashCode, boolean hierarchical, String scheme, String authority, String device, boolean absolutePath, String[] segments, String query) {
            int flags;
            block20: {
                block22: {
                    String firstSegment;
                    block23: {
                        block21: {
                            super(hashCode);
                            flags = 0;
                            if (absolutePath) {
                                flags |= 1;
                            } else if (device == null && authority == null) {
                                flags |= 2;
                                if (segments == NO_SEGMENTS) {
                                    flags |= 4;
                                    if (query == null) {
                                        flags |= 8;
                                    }
                                }
                                if (query == null) {
                                    flags |= 0x10;
                                }
                            }
                            if (scheme == null) break block20;
                            if (scheme != URI.SCHEME_FILE) break block21;
                            flags |= 0x10;
                            break block20;
                        }
                        if (scheme != URI.SCHEME_PLATFORM) break block22;
                        if (authority != null || device != null || segments.length < 2) break block20;
                        flags |= 0x20;
                        firstSegment = segments[0];
                        if (firstSegment != URI.SEGMENT_RESOURCE) break block23;
                        flags |= 0x40;
                        break block20;
                    }
                    if (firstSegment != URI.SEGMENT_PLUGIN) break block20;
                    flags |= 0x80;
                    break block20;
                }
                String[] stringArray = ARCHIVE_SCHEMES;
                int n = ARCHIVE_SCHEMES.length;
                int n2 = 0;
                while (n2 < n) {
                    String archiveScheme = stringArray[n2];
                    if (scheme == archiveScheme) {
                        flags |= 0x100;
                        break;
                    }
                    ++n2;
                }
            }
            if (segments == NO_SEGMENTS) {
                if (absolutePath && query == null) {
                    flags |= 0x400;
                }
            } else if (segments[segments.length - 1] == URI.SEGMENT_EMPTY) {
                flags |= 0x200;
                if (query == null) {
                    flags |= 0x400;
                }
            }
            this.flags = flags;
            this.scheme = scheme;
            this.authority = authority;
            this.device = device;
            this.segments = segments;
            this.query = query;
            assert (segments == SegmentSequence.STRING_ARRAY_POOL.intern(true, true, segments, segments.length));
            assert (scheme == CommonUtil.internToLowerCase(scheme));
            assert (authority == CommonUtil.intern(authority));
            assert (query == CommonUtil.intern(query));
            assert (device == CommonUtil.intern(device));
            assert (Hierarchical.validateURI(true, scheme, authority, device, this.hasAbsolutePath(), segments, query, null));
            assert (hashCode == this.toString().hashCode());
        }

        @Override
        public boolean isRelative() {
            return this.scheme == null;
        }

        @Override
        protected boolean isBase() {
            return this.scheme != null;
        }

        @Override
        public boolean isHierarchical() {
            return true;
        }

        @Override
        public boolean hasAuthority() {
            return this.authority != null;
        }

        @Override
        public boolean hasDevice() {
            return this.device != null;
        }

        @Override
        public boolean hasPath() {
            return (this.flags & 3) != 0;
        }

        @Override
        protected boolean hasDeviceOrPath() {
            return (this.flags & 3) != 0 || this.device != null;
        }

        @Override
        public boolean hasAbsolutePath() {
            return (this.flags & 1) != 0;
        }

        @Override
        public boolean hasRelativePath() {
            return (this.flags & 2) != 0;
        }

        @Override
        public boolean hasEmptyPath() {
            return (this.flags & 4) != 0;
        }

        @Override
        public boolean hasQuery() {
            return this.query != null;
        }

        @Override
        public boolean isCurrentDocumentReference() {
            return (this.flags & 8) != 0;
        }

        @Override
        public boolean isEmpty() {
            return (this.flags & 8) != 0;
        }

        @Override
        public boolean isFile() {
            return (this.flags & 0x10) != 0;
        }

        @Override
        public boolean isPlatform() {
            return (this.flags & 0x20) != 0;
        }

        @Override
        public boolean isPlatformResource() {
            return (this.flags & 0x40) != 0;
        }

        @Override
        public boolean isPlatformPlugin() {
            return (this.flags & 0x80) != 0;
        }

        @Override
        public boolean isArchive() {
            return (this.flags & 0x100) != 0;
        }

        @Override
        protected boolean segmentsEqual(URI uri) {
            String[] segments = this.segments;
            int length = segments.length;
            if (length != uri.segmentCount()) {
                return false;
            }
            int i = 0;
            while (i < length) {
                if (segments[i] != uri.segment(i)) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        @Override
        public String scheme() {
            return this.scheme;
        }

        @Override
        public String authority() {
            return this.authority;
        }

        @Override
        public String userInfo() {
            if (!this.hasAuthority()) {
                return null;
            }
            int i = this.authority.indexOf(64);
            return i < 0 ? null : this.authority.substring(0, i);
        }

        @Override
        public String host() {
            if (!this.hasAuthority()) {
                return null;
            }
            int i = this.authority.indexOf(64);
            int j = this.authority.indexOf(58, i);
            return j < 0 ? this.authority.substring(i + 1) : this.authority.substring(i + 1, j);
        }

        @Override
        public String port() {
            if (!this.hasAuthority()) {
                return null;
            }
            int i = this.authority.indexOf(64);
            int j = this.authority.indexOf(58, i);
            return j < 0 ? null : this.authority.substring(j + 1);
        }

        @Override
        public String device() {
            return this.device;
        }

        @Override
        public String[] segments() {
            return (String[])this.segments.clone();
        }

        @Override
        protected String[] rawSegments() {
            return this.segments;
        }

        @Override
        public List<String> segmentsList() {
            return Collections.unmodifiableList(Arrays.asList(this.segments));
        }

        @Override
        public int segmentCount() {
            return this.segments.length;
        }

        @Override
        public String segment(int i) {
            return this.segments[i];
        }

        @Override
        public String lastSegment() {
            int len = this.segments.length;
            if (len == 0) {
                return null;
            }
            return this.segments[len - 1];
        }

        @Override
        public String path() {
            if (!this.hasPath()) {
                return null;
            }
            CommonUtil.StringPool.StringsAccessUnit result = CommonUtil.STRING_POOL.getStringBuilder();
            if (this.hasAbsolutePath()) {
                result.append('/');
            }
            String[] segments = this.segments;
            int i = 0;
            int len = segments.length;
            while (i < len) {
                if (i != 0) {
                    result.append('/');
                }
                result.append(segments[i]);
                ++i;
            }
            return CommonUtil.STRING_POOL.intern(result);
        }

        @Override
        public String devicePath() {
            if (!this.hasPath()) {
                return null;
            }
            CommonUtil.StringPool.StringsAccessUnit result = CommonUtil.STRING_POOL.getStringBuilder();
            if (this.hasAuthority()) {
                if (!this.isArchive()) {
                    result.append(URI.AUTHORITY_SEPARATOR);
                }
                result.append(this.authority);
                if (this.hasDevice()) {
                    result.append('/');
                }
            }
            if (this.hasDevice()) {
                result.append(this.device);
            }
            if (this.hasAbsolutePath()) {
                result.append('/');
            }
            String[] segments = this.segments;
            int i = 0;
            int len = segments.length;
            while (i < len) {
                if (i != 0) {
                    result.append('/');
                }
                result.append(segments[i]);
                ++i;
            }
            return CommonUtil.STRING_POOL.intern(result);
        }

        @Override
        public String query() {
            return this.query;
        }

        @Override
        public URI appendQuery(String query) {
            return POOL.intern(false, -3, true, this.scheme, this.authority, this.device, this.hasAbsolutePath(), this.segments, query);
        }

        @Override
        public URI trimQuery() {
            if (this.query == null) {
                return this;
            }
            return POOL.intern(false, -1, true, this.scheme, this.authority, this.device, this.hasAbsolutePath(), this.segments, null);
        }

        @Override
        public URI resolve(URI base, boolean preserveRootParents) {
            if (!base.isBase()) {
                throw new IllegalArgumentException("resolve against non-hierarchical or relative base");
            }
            if (!this.isRelative()) {
                return this;
            }
            String newAuthority = this.authority;
            String newDevice = this.device;
            boolean newAbsolutePath = this.hasAbsolutePath();
            String[] newSegments = this.segments;
            String newQuery = this.query;
            if (this.authority == null) {
                newAuthority = base.authority();
                if (this.device == null) {
                    newDevice = base.device();
                    if (this.hasEmptyPath() && this.query == null) {
                        newAbsolutePath = base.hasAbsolutePath();
                        newSegments = base.rawSegments();
                        newQuery = base.query();
                    } else if (this.hasRelativePath()) {
                        newAbsolutePath = base.hasAbsolutePath() || !this.hasEmptyPath();
                        newSegments = newAbsolutePath ? this.mergePath(base, preserveRootParents) : NO_SEGMENTS;
                    }
                }
            }
            return POOL.intern(false, -1, true, base.scheme(), newAuthority, newDevice, newAbsolutePath, newSegments, newQuery);
        }

        protected String[] mergePath(URI base, boolean preserveRootParents) {
            if (base.hasRelativePath()) {
                throw new IllegalArgumentException("merge against relative path");
            }
            if (!this.hasRelativePath()) {
                throw new IllegalStateException("merge non-relative path");
            }
            int baseSegmentCount = base.segmentCount();
            int segmentCount = this.segments.length;
            String[] stack = new String[baseSegmentCount + segmentCount];
            int sp = 0;
            int i = 0;
            while (i < baseSegmentCount - 1) {
                sp = Hierarchical.accumulate(stack, sp, base.segment(i), preserveRootParents);
                ++i;
            }
            i = 0;
            while (i < segmentCount) {
                sp = Hierarchical.accumulate(stack, sp, this.segments[i], preserveRootParents);
                ++i;
            }
            if (sp > 0) {
                if (segmentCount == 0) {
                    stack[sp++] = URI.SEGMENT_EMPTY;
                } else {
                    String segment = this.segments[segmentCount - 1];
                    if (segment == URI.SEGMENT_EMPTY || segment == URI.SEGMENT_PARENT || segment == URI.SEGMENT_SELF) {
                        stack[sp++] = URI.SEGMENT_EMPTY;
                    }
                }
            }
            return SegmentSequence.STRING_ARRAY_POOL.intern(stack, 0, sp);
        }

        protected static int accumulate(String[] stack, int sp, String segment, boolean preserveRootParents) {
            if (URI.SEGMENT_PARENT == segment) {
                if (sp == 0) {
                    if (preserveRootParents) {
                        stack[sp++] = segment;
                    }
                } else if (URI.SEGMENT_PARENT == stack[sp - 1]) {
                    stack[sp++] = segment;
                } else {
                    --sp;
                }
            } else if (URI.SEGMENT_EMPTY != segment && URI.SEGMENT_SELF != segment) {
                stack[sp++] = segment;
            }
            return sp;
        }

        @Override
        public URI deresolve(URI base, boolean preserveRootParents, boolean anyRelPath, boolean shorterRelPath) {
            if (!base.isBase() || this.isRelative()) {
                return this;
            }
            if (this.scheme != base.scheme()) {
                return this;
            }
            String newAuthority = this.authority;
            String newDevice = this.device;
            boolean newAbsolutePath = this.hasAbsolutePath();
            String[] newSegments = this.segments;
            String newQuery = this.query;
            if (this.authority == base.authority() && (this.hasDeviceOrPath() || !base.hasDeviceOrPath())) {
                newAuthority = null;
                if (this.device == base.device()) {
                    boolean hasPath = this.hasPath();
                    boolean baseHasPath = base.hasPath();
                    if (hasPath || !baseHasPath) {
                        newDevice = null;
                        if (anyRelPath || shorterRelPath) {
                            if (hasPath == baseHasPath && this.segmentsEqual(base) && this.query == base.query()) {
                                newAbsolutePath = false;
                                newSegments = NO_SEGMENTS;
                                newQuery = null;
                            } else if (hasPath && !baseHasPath) {
                                newAbsolutePath = false;
                                newSegments = NO_SEGMENTS;
                            } else if (!this.hasCollapsableSegments(preserveRootParents)) {
                                String[] rel = this.findRelativePath(base, preserveRootParents);
                                if (anyRelPath || this.segments.length > rel.length) {
                                    newAbsolutePath = false;
                                    newSegments = rel;
                                }
                            }
                        }
                    }
                }
            }
            return POOL.intern(false, -1, true, null, newAuthority, newDevice, newAbsolutePath, newSegments, newQuery);
        }

        protected boolean hasCollapsableSegments(boolean preserveRootParents) {
            if (this.hasRelativePath()) {
                throw new IllegalStateException("test collapsability of relative path");
            }
            String[] segments = this.segments;
            int i = 0;
            int len = segments.length;
            while (i < len) {
                String segment = segments[i];
                if (i < len - 1 && URI.SEGMENT_EMPTY == segment || URI.SEGMENT_SELF == segment || URI.SEGMENT_PARENT == segment && (!preserveRootParents || i != 0 && URI.SEGMENT_PARENT != segments[i - 1])) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        protected String[] findRelativePath(URI base, boolean preserveRootParents) {
            int length;
            if (base.hasRelativePath()) {
                throw new IllegalArgumentException("find relative path against base with relative path");
            }
            if (!this.hasAbsolutePath()) {
                throw new IllegalArgumentException("find relative path of non-absolute path");
            }
            String[] startPath = base.collapseSegments(preserveRootParents);
            String[] endPath = this.segments;
            int startCount = startPath.length > 0 ? startPath.length - 1 : 0;
            int endCount = endPath.length;
            int diff = 0;
            int count = startCount < endCount ? startCount : endCount - 1;
            while (diff < count && startPath[diff] == endPath[diff]) {
                ++diff;
            }
            int upCount = startCount - diff;
            int downCount = endCount - diff;
            if (downCount == 1 && URI.SEGMENT_EMPTY == endPath[endCount - 1]) {
                downCount = 0;
            }
            if ((length = upCount + downCount) == 0) {
                if (this.query == null) {
                    return ONE_SELF_SEGMENT;
                }
                return NO_SEGMENTS;
            }
            Object[] result = new String[length];
            Arrays.fill(result, 0, upCount, URI.SEGMENT_PARENT);
            System.arraycopy(endPath, diff, result, upCount, downCount);
            return SegmentSequence.STRING_ARRAY_POOL.intern(false, false, (String[])result, length);
        }

        @Override
        protected String[] collapseSegments(boolean preserveRootParents) {
            String segment;
            if (this.hasRelativePath()) {
                throw new IllegalStateException("collapse relative path");
            }
            if (!this.hasCollapsableSegments(preserveRootParents)) {
                return this.rawSegments();
            }
            String[] segments = this.segments;
            int segmentCount = segments.length;
            String[] stack = new String[segmentCount];
            int sp = 0;
            int i = 0;
            while (i < segmentCount) {
                sp = Hierarchical.accumulate(stack, sp, segments[i], preserveRootParents);
                ++i;
            }
            if (sp > 0 && ((segment = segments[segmentCount - 1]) == URI.SEGMENT_EMPTY || segment == URI.SEGMENT_PARENT || segment == URI.SEGMENT_SELF)) {
                stack[sp++] = URI.SEGMENT_EMPTY;
            }
            return SegmentSequence.STRING_ARRAY_POOL.intern(stack, 0, sp);
        }

        @Override
        protected void cacheString(String string) {
            this.toString = POOL.newCachedToString(this, string);
        }

        @Override
        protected void flushCachedString() {
            this.toString = null;
        }

        @Override
        protected String getCachedString() {
            WeakReference<String> toString = this.toString;
            if (toString != null) {
                String result = (String)toString.get();
                if (result == null) {
                    toString.clear();
                } else {
                    return result;
                }
            }
            return null;
        }

        public String toString() {
            String cachedToString = this.getCachedString();
            if (cachedToString != null) {
                return cachedToString;
            }
            CommonUtil.StringPool.StringsAccessUnit result = CommonUtil.STRING_POOL.getStringBuilder();
            if (!this.isRelative()) {
                result.append(this.scheme);
                result.append(':');
            }
            if (this.hasAuthority()) {
                if (!this.isArchive()) {
                    result.append(URI.AUTHORITY_SEPARATOR);
                }
                result.append(this.authority);
            }
            if (this.hasDevice()) {
                result.append('/');
                result.append(this.device);
            }
            if (this.hasAbsolutePath()) {
                result.append('/');
            }
            int i = 0;
            int len = this.segments.length;
            while (i < len) {
                if (i != 0) {
                    result.append('/');
                }
                result.append(this.segments[i]);
                ++i;
            }
            if (this.hasQuery()) {
                result.append('?');
                result.append(this.query);
            }
            String string = CommonUtil.STRING_POOL.intern(result);
            this.toString = POOL.newCachedToString(this, string);
            return string;
        }

        @Override
        protected boolean matches(String string) {
            String cachedString = this.getCachedString();
            if (cachedString != null) {
                return cachedString.equals(string);
            }
            int length = string.length();
            int index = 0;
            if (!this.isRelative()) {
                if (!string.startsWith(this.scheme)) {
                    return false;
                }
                if ((index += this.scheme.length()) >= length || string.charAt(index) != ':') {
                    return false;
                }
                ++index;
            }
            if (this.hasAuthority()) {
                if (!this.isArchive()) {
                    if (!string.startsWith(URI.AUTHORITY_SEPARATOR, index)) {
                        return false;
                    }
                    index += 2;
                }
                if (!string.startsWith(this.authority, index)) {
                    return false;
                }
                index += this.authority.length();
            }
            if (this.hasDevice()) {
                if (index >= length || string.charAt(index) != '/') {
                    return false;
                }
                if (!string.startsWith(this.device, ++index)) {
                    return false;
                }
                index += this.device.length();
            }
            if (this.hasAbsolutePath()) {
                if (index >= length || string.charAt(index) != '/') {
                    return false;
                }
                ++index;
            }
            String[] segments = this.segments;
            int i = 0;
            int len = segments.length;
            while (i < len) {
                String segment;
                if (i != 0) {
                    if (index >= length || string.charAt(index) != '/') {
                        return false;
                    }
                    ++index;
                }
                if (!string.startsWith(segment = segments[i], index)) {
                    return false;
                }
                index += segment.length();
                ++i;
            }
            if (this.hasQuery()) {
                if (index >= length || string.charAt(index) != '?') {
                    return false;
                }
                if (!string.startsWith(this.query, ++index)) {
                    return false;
                }
                index += this.query.length();
            }
            return index == length;
        }

        @Override
        protected boolean matches(int validate, boolean hierarchical, String scheme, String authority, String device, boolean absolutePath, String[] segments, String query) {
            return hierarchical && this.hasAbsolutePath() == absolutePath && (validate >= -1 ? this.segments == segments && this.scheme == scheme && this.authority == authority && this.device == device && this.query == query : Arrays.equals(this.segments, segments) && Hierarchical.equals(this.scheme, scheme) && Hierarchical.equals(this.authority, authority) && Hierarchical.equals(this.device, device) && Hierarchical.equals(this.query, query));
        }

        @Override
        protected boolean matches(String base, String path) {
            if (!this.isPlatform() || this.segments[0] != base) {
                return false;
            }
            String[] segments = this.segments;
            int length = path.length();
            int i = 1;
            int len = segments.length;
            int index = 1;
            while (i < len) {
                String segment;
                if (i != 1) {
                    if (index >= length || path.charAt(index) != '/') {
                        return false;
                    }
                    ++index;
                }
                if (!path.startsWith(segment = segments[i], index)) {
                    return false;
                }
                index += segment.length();
                ++i;
            }
            return true;
        }

        @Override
        public String toFileString() {
            if (!this.isFile()) {
                return null;
            }
            CommonUtil.StringPool.StringsAccessUnit result = CommonUtil.STRING_POOL.getStringBuilder();
            char separator = File.separatorChar;
            boolean hasDevice = this.hasDevice();
            if (this.hasAuthority()) {
                result.append(URI.AUTHORITY_SEPARATOR);
                result.append(this.authority);
                if (hasDevice) {
                    result.append(separator);
                }
            }
            if (hasDevice) {
                result.append(this.device);
            }
            if (this.hasAbsolutePath()) {
                result.append(separator);
            }
            String[] segments = this.segments;
            int i = 0;
            int len = segments.length;
            while (i < len) {
                if (i != 0) {
                    result.append(separator);
                }
                result.append(segments[i]);
                ++i;
            }
            return Hierarchical.decode(CommonUtil.STRING_POOL.intern(result));
        }

        @Override
        public String toPlatformString(boolean decode) {
            if (this.isPlatform()) {
                CommonUtil.StringPool.StringsAccessUnit result = CommonUtil.STRING_POOL.getStringBuilder();
                String[] segments = this.segments;
                int i = 1;
                int len = segments.length;
                while (i < len) {
                    result.append('/');
                    result.append(decode ? URI.decode(segments[i]) : segments[i]);
                    ++i;
                }
                return CommonUtil.STRING_POOL.intern(result);
            }
            return null;
        }

        @Override
        public URI appendSegment(String segment) {
            String[] newSegments;
            boolean isEmptySegment;
            if (segment == null) {
                throw new IllegalArgumentException("invalid segment: null");
            }
            boolean bl = isEmptySegment = segment.length() == 0;
            if (isEmptySegment && this.scheme != null && this.authority == null && this.device == null && this.segments.length == 0) {
                return this;
            }
            boolean newAbsolutePath = !this.hasRelativePath();
            String newDevice = this.device;
            if (isEmptySegment && this.segments.length == 0) {
                newAbsolutePath = true;
                newSegments = NO_SEGMENTS;
            } else if (this.device == null && this.segments.length == 0 && !isEmptySegment && segment.charAt(segment.length() - 1) == ':') {
                newDevice = CommonUtil.intern(segment);
                newSegments = NO_SEGMENTS;
                newAbsolutePath = false;
            } else {
                newSegments = SegmentSequence.STRING_ARRAY_POOL.intern(this.segments, this.segments.length, segment, true);
            }
            return POOL.intern(false, this.segments.length, true, this.scheme, this.authority, newDevice, newAbsolutePath, newSegments, this.query);
        }

        @Override
        public URI appendSegments(String[] segments) {
            if (segments == null) {
                throw new IllegalArgumentException("invalid segments: null");
            }
            if (segments.length == 1) {
                return this.appendSegment(segments[0]);
            }
            if (this.device == null && this.authority == null && this.segments.length == 0) {
                String[] newSegments = SegmentSequence.STRING_ARRAY_POOL.intern(segments, 1, segments.length - 1);
                return this.appendSegment(segments[0]).appendSegments(newSegments);
            }
            String[] stringArray = segments;
            int n = segments.length;
            int n2 = 0;
            while (n2 < n) {
                String segment = stringArray[n2];
                if (segment == null) {
                    throw new IllegalArgumentException("invalid segment: null");
                }
                ++n2;
            }
            boolean newAbsolutePath = !this.hasRelativePath();
            String[] newSegments = SegmentSequence.STRING_ARRAY_POOL.intern(this.segments, segments, true);
            return POOL.intern(false, this.segments.length, true, this.scheme, this.authority, this.device, newAbsolutePath, newSegments, this.query);
        }

        @Override
        public URI trimSegments(int i) {
            if (i < 1) {
                return this;
            }
            int len = this.segments.length - i;
            String[] newSegments = len > 0 ? SegmentSequence.STRING_ARRAY_POOL.intern(this.segments, 0, len) : NO_SEGMENTS;
            return POOL.intern(false, -1, true, this.scheme, this.authority, this.device, this.hasAbsolutePath(), newSegments, this.query);
        }

        @Override
        public boolean hasTrailingPathSeparator() {
            return (this.flags & 0x200) != 0;
        }

        @Override
        public String fileExtension() {
            int len = this.segments.length;
            if (len == 0) {
                return null;
            }
            String lastSegment = this.segments[len - 1];
            int i = lastSegment.lastIndexOf(46);
            return i < 0 ? null : lastSegment.substring(i + 1);
        }

        @Override
        public URI appendFileExtension(String fileExtension) {
            if (fileExtension == null) {
                throw new IllegalArgumentException("invalid segment portion: null");
            }
            int len = this.segments.length;
            if (len == 0) {
                if (!Hierarchical.validSegment(fileExtension)) {
                    throw new IllegalArgumentException("invalid segment portion: " + fileExtension);
                }
                return this;
            }
            String lastSegment = this.segments[len - 1];
            if (URI.SEGMENT_EMPTY == lastSegment) {
                if (!Hierarchical.validSegment(fileExtension)) {
                    throw new IllegalArgumentException("invalid segment portion: " + fileExtension);
                }
                return this;
            }
            CommonUtil.StringPool.StringsAccessUnit newLastSegment = CommonUtil.STRING_POOL.getStringBuilder();
            newLastSegment.append(lastSegment);
            newLastSegment.append('.');
            newLastSegment.append(fileExtension);
            String[] newSegments = SegmentSequence.STRING_ARRAY_POOL.intern(this.segments, this.segments.length - 1, CommonUtil.STRING_POOL.intern(newLastSegment), false);
            return POOL.intern(false, len, true, this.scheme, this.authority, this.device, this.hasAbsolutePath(), newSegments, this.query);
        }

        @Override
        public URI trimFileExtension() {
            int len = this.segments.length;
            if (len == 0) {
                return this;
            }
            String lastSegment = this.segments[len - 1];
            int i = lastSegment.lastIndexOf(46);
            if (i < 0) {
                return this;
            }
            String newLastSegment = lastSegment.substring(0, i);
            String[] newSegments = SegmentSequence.STRING_ARRAY_POOL.intern(this.segments, len - 1, newLastSegment, true);
            return POOL.intern(false, -1, true, this.scheme, this.authority, this.device, this.hasAbsolutePath(), newSegments, this.query);
        }

        @Override
        public boolean isPrefix() {
            return (this.flags & 0x400) != 0;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public URI replacePrefix(URI oldPrefix, URI newPrefix) {
            block6: {
                block5: {
                    if (!oldPrefix.isPrefix() || !newPrefix.isPrefix()) {
                        which = oldPrefix.isPrefix() != false ? "new" : "old";
                        throw new IllegalArgumentException("non-prefix " + which + " value");
                    }
                    if (this.scheme != oldPrefix.scheme() || this.authority != oldPrefix.authority() || this.device != oldPrefix.device() || this.hasAbsolutePath() != oldPrefix.hasAbsolutePath()) {
                        return null;
                    }
                    segments = this.segments;
                    segmentsLength = segments.length;
                    oldPrefixSegments = oldPrefix.rawSegments();
                    oldPrefixSegmentCount = oldPrefixSegments.length;
                    if (oldPrefixSegmentCount != 0) break block5;
                    tailSegmentCount = segmentsLength;
                    break block6;
                }
                i = 0;
                segmentsToCompare = oldPrefixSegmentCount - 1;
                if (segmentsLength > segmentsToCompare) ** GOTO lbl21
                return null;
lbl-1000:
                // 1 sources

                {
                    if (segments[i] != oldPrefixSegments[i]) {
                        return null;
                    }
                    ++i;
lbl21:
                    // 2 sources

                    ** while (i < segmentsToCompare)
                }
lbl22:
                // 1 sources

                if (i == segmentsLength - 1 && segments[i] == "") {
                    return newPrefix;
                }
                tailSegmentCount = segmentsLength - i;
            }
            newPrefixSegments = newPrefix.rawSegments();
            newPrefixSegmentCount = newPrefixSegments.length;
            mergedSegments = newPrefixSegmentCount == 0 ? (tailSegmentCount == segmentsLength ? segments : SegmentSequence.STRING_ARRAY_POOL.intern(segments, segmentsLength - tailSegmentCount, tailSegmentCount)) : SegmentSequence.STRING_ARRAY_POOL.intern(newPrefixSegments, 0, newPrefixSegmentCount - 1, segments, segmentsLength - tailSegmentCount, tailSegmentCount);
            return Hierarchical.POOL.intern(false, -1, true, newPrefix.scheme(), newPrefix.authority(), newPrefix.device(), newPrefix.hasAbsolutePath(), mergedSegments, this.query);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LazyFragmentInitializer
    extends WeakReference<Fragment> {
        protected final String fragment;

        public LazyFragmentInitializer(Fragment uri, ReferenceQueue<? super URI> queue, String fragment) {
            super(uri, queue);
            this.fragment = fragment;
            this.enqueue();
        }

        @Override
        public void clear() {
            Fragment uri = (Fragment)this.get();
            if (uri != null) {
                uri.fragment = URI.splitInternFragment(this.fragment);
                uri.hashCode = (uri.uri.hashCode * 31 + 35) * CommonUtil.powerOf31(this.fragment.length()) + uri.fragment.hashCode();
            }
        }
    }

    protected static final class Opaque
    extends URI {
        protected final String scheme;
        protected final String opaquePart;
        protected WeakReference<String> toString;

        protected Opaque(int hashCode, String scheme, String opaquePart) {
            super(hashCode);
            this.scheme = scheme;
            this.opaquePart = opaquePart;
            assert (scheme == CommonUtil.internToLowerCase(scheme));
            assert (opaquePart == CommonUtil.intern(opaquePart));
            assert (Opaque.validateURI(false, scheme, opaquePart, null, false, NO_SEGMENTS, null, null));
            assert (hashCode == this.toString().hashCode());
        }

        public boolean hasOpaquePart() {
            return true;
        }

        public String scheme() {
            return this.scheme;
        }

        public String opaquePart() {
            return this.opaquePart;
        }

        protected void cacheString(String string) {
            this.toString = POOL.newCachedToString(this, string);
        }

        protected void flushCachedString() {
            this.toString = null;
        }

        protected String getCachedString() {
            WeakReference<String> toString = this.toString;
            if (toString != null) {
                String result = (String)toString.get();
                if (result == null) {
                    toString.clear();
                } else {
                    return result;
                }
            }
            return null;
        }

        public String toString() {
            String cachedString = this.getCachedString();
            if (cachedString != null) {
                return cachedString;
            }
            CommonUtil.StringPool.StringsAccessUnit result = CommonUtil.STRING_POOL.getStringBuilder();
            result.append(this.scheme);
            result.append(':');
            result.append(this.opaquePart);
            String string = CommonUtil.STRING_POOL.intern(result);
            this.toString = POOL.newCachedToString(this, string);
            return string;
        }

        protected boolean matches(String string) {
            String cachedString = this.getCachedString();
            if (cachedString != null) {
                return cachedString.equals(string);
            }
            int index = 0;
            if (!string.startsWith(this.scheme)) {
                return false;
            }
            int length = string.length();
            if ((index += this.scheme.length()) >= length || string.charAt(index) != ':') {
                return false;
            }
            if (!string.startsWith(this.opaquePart, ++index)) {
                return false;
            }
            return (index += this.opaquePart.length()) == length;
        }

        protected boolean matches(int validate, boolean hierarchical, String scheme, String authority, String device, boolean absolutePath, String[] segments, String query) {
            return !hierarchical && !absolutePath && segments == null && query == null && (validate >= -1 ? this.scheme == scheme && this.opaquePart == authority : Opaque.equals(this.scheme, scheme) && Opaque.equals(this.opaquePart, authority));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class URIPool
    extends Pool<URI> {
        protected static final long serialVersionUID = 1L;
        protected final ReferenceQueue<String> cachedToStrings;
        protected final StringAccessUnit.Queue stringAccessUnits = new StringAccessUnit.Queue(this);
        protected final PlatformAccessUnit.Queue platformAccessUnits = new PlatformAccessUnit.Queue();
        protected final FileAccessUnit.Queue fileAccessUnits = new FileAccessUnit.Queue();
        protected final URIComponentsAccessUnit.Queue uriComponentsAccessUnits = new URIComponentsAccessUnit.Queue();

        public URIPool(ReferenceQueue<Object> queue) {
            super(1031, null, queue);
            this.cachedToStrings = this.externalQueue == null ? new ReferenceQueue() : null;
        }

        @Override
        protected URI intern(String string) {
            if (string == null) {
                return null;
            }
            int hashCode = string.hashCode();
            WeakInterningHashSet.Entry entry = this.getEntry(hashCode);
            while (entry != null) {
                URI uri = (URI)entry.get();
                if (uri != null && uri.matches(string)) {
                    return uri;
                }
                entry = entry.getNextEntry();
            }
            this.writeLock.lock();
            try {
                StringAccessUnit accessUnit = this.stringAccessUnits.pop(true);
                accessUnit.setValue(string, hashCode);
                URI result = accessUnit.getInternalizedValue();
                accessUnit.reset(true);
                URI uRI = result;
                return uRI;
            }
            finally {
                this.writeLock.unlock();
            }
        }

        protected URI intern(String base, String pathName, boolean encode) {
            PlatformAccessUnit accessUnit = this.platformAccessUnits.pop(false);
            accessUnit.setValue(base, pathName, encode);
            return this.doIntern(false, accessUnit);
        }

        protected URI internFile(String pathName) {
            FileAccessUnit accessUnit = this.fileAccessUnits.pop(false);
            accessUnit.setValue(pathName);
            return this.doIntern(false, accessUnit);
        }

        protected URI intern(boolean isExclusive, int validate, boolean hierarchical, String scheme, String authority, String device, boolean absolutePath, String[] segments, String query) {
            URI uri;
            if (isExclusive) {
                this.writeLock.lock();
            }
            try {
                URIComponentsAccessUnit accessUnit = this.uriComponentsAccessUnits.pop(isExclusive);
                accessUnit.setValue(validate, hierarchical, scheme, authority, device, absolutePath, segments, query);
                uri = this.doIntern(isExclusive, accessUnit);
            }
            finally {
                if (isExclusive) {
                    this.writeLock.unlock();
                }
            }
            return uri;
        }

        protected URI intern(boolean isExclusive, boolean hierarchical, String scheme, String authority, String device, boolean absolutePath, String[] segments, String query, int hashCode) {
            URI uri;
            if (isExclusive) {
                this.writeLock.lock();
            }
            try {
                URIComponentsAccessUnit accessUnit = this.uriComponentsAccessUnits.pop(isExclusive);
                accessUnit.setValue(hierarchical, scheme, authority, device, absolutePath, segments, query, hashCode);
                uri = this.doIntern(isExclusive, accessUnit);
            }
            finally {
                if (isExclusive) {
                    this.writeLock.unlock();
                }
            }
            return uri;
        }

        @Override
        protected void doCleanup() {
            super.doCleanup();
            Reference<String> cachedToString;
            while ((cachedToString = this.cachedToStrings.poll()) != null) {
                cachedToString.clear();
            }
            return;
        }

        protected WeakReference<String> newCachedToString(URI uri, String string) {
            return this.cachedToStrings == null ? new CachedToString(uri, string, this.externalQueue) : new CachedToString(uri, string, this.cachedToStrings);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static class CachedToString
        extends WeakReference<String> {
            protected final URI uri;

            public CachedToString(URI uri, String string, ReferenceQueue<? super String> queue) {
                super(string, queue);
                this.uri = uri;
            }

            @Override
            public void clear() {
                this.uri.flushCachedString();
                super.clear();
            }
        }

        protected static class FileAccessUnit
        extends URIPoolAccessUnitBase {
            protected static final String FILE_BASE = "file:/";
            protected static final int FILE_BASE_LENGTH = "file:/".length();
            protected static final int FILE_BASE_HASH_CODE = "file:/".hashCode();
            protected String path;
            protected char[] absoluteCharacters = new char[100];
            protected char[] relativeCharacters = new char[100];
            protected String[] segments = new String[20];
            protected int segmentCount;
            protected int usedSegmentCount;
            protected int[] segmentBoundaries = new int[100];
            protected int[] segmentHashCodes = new int[100];
            protected String encodedPath;
            protected boolean isAbsoluteFile;
            protected boolean isAbsolutePath;

            public FileAccessUnit(Queue queue) {
                super(queue);
                FILE_BASE.getChars(0, FILE_BASE_LENGTH, this.absoluteCharacters, 0);
            }

            protected void setValue(String path) {
                this.path = path;
                int length = path.length();
                if (length == 0) {
                    this.encodedPath = URI.SEGMENT_EMPTY;
                    this.hashCode = 0;
                } else {
                    int hashCode;
                    int i;
                    char[] characters;
                    int maxEncodedLength;
                    this.isAbsoluteFile = new File(path).isAbsolute();
                    char character = path.charAt(0);
                    char separatorchar = File.separatorChar;
                    if (this.segmentBoundaries.length < length) {
                        this.segmentBoundaries = new int[length];
                        this.segmentHashCodes = new int[length];
                    }
                    if (this.isAbsoluteFile) {
                        this.isAbsolutePath = true;
                        maxEncodedLength = 3 * length + FILE_BASE_LENGTH;
                        if (this.absoluteCharacters.length <= maxEncodedLength) {
                            this.absoluteCharacters = new char[maxEncodedLength + 1];
                            FILE_BASE.getChars(0, FILE_BASE_LENGTH, this.absoluteCharacters, 0);
                        }
                        characters = this.absoluteCharacters;
                        if (character == '/' || character == separatorchar) {
                            path.getChars(1, length, characters, FILE_BASE_LENGTH);
                            length += FILE_BASE_LENGTH - 1;
                        } else {
                            path.getChars(0, length, characters, FILE_BASE_LENGTH);
                            length += FILE_BASE_LENGTH;
                        }
                        this.segmentBoundaries[0] = i = FILE_BASE_LENGTH;
                        hashCode = FILE_BASE_HASH_CODE;
                    } else {
                        maxEncodedLength = 3 * length;
                        if (this.relativeCharacters.length <= maxEncodedLength) {
                            this.relativeCharacters = new char[maxEncodedLength + 1];
                        }
                        characters = this.relativeCharacters;
                        if (character == '/' || character == separatorchar) {
                            this.isAbsolutePath = true;
                            characters[0] = 47;
                            path.getChars(1, length, characters, 1);
                            i = 1;
                            this.segmentBoundaries[0] = 1;
                            hashCode = 47;
                        } else {
                            this.isAbsolutePath = false;
                            path.getChars(0, length, characters, 0);
                            i = 0;
                            this.segmentBoundaries[0] = 0;
                            hashCode = 0;
                        }
                    }
                    int segmentHashCode = 0;
                    while (i < length) {
                        character = characters[i];
                        if (character < '\u00a0' && (!URI.matches(character, SEGMENT_CHAR_HI, SEGMENT_CHAR_LO) || character == ':' && !this.isAbsolutePath && this.segmentCount == 0)) {
                            if (character == '/') {
                                this.segmentHashCodes[this.segmentCount] = segmentHashCode;
                                this.segmentBoundaries[++this.segmentCount] = i;
                                segmentHashCode = 0;
                                hashCode = 31 * hashCode + 47;
                            } else if (character == separatorchar) {
                                characters[i] = 47;
                                this.segmentHashCodes[this.segmentCount] = segmentHashCode;
                                this.segmentBoundaries[++this.segmentCount] = i;
                                segmentHashCode = 0;
                                hashCode = 31 * hashCode + 47;
                            } else {
                                System.arraycopy(characters, i + 1, characters, i + 3, length - i - 1);
                                characters[i] = 37;
                                hashCode = 31 * hashCode + 37;
                                segmentHashCode = 31 * segmentHashCode + 37;
                                char firstHexCharacter = characters[++i] = HEX_DIGITS[character >> 4 & 0xF];
                                hashCode = 31 * hashCode + firstHexCharacter;
                                segmentHashCode = 31 * segmentHashCode + firstHexCharacter;
                                char secondHexCharacter = characters[++i] = HEX_DIGITS[character & 0xF];
                                hashCode = 31 * hashCode + secondHexCharacter;
                                segmentHashCode = 31 * segmentHashCode + secondHexCharacter;
                                length += 2;
                            }
                        } else {
                            hashCode = 31 * hashCode + character;
                            segmentHashCode = 31 * segmentHashCode + character;
                        }
                        ++i;
                    }
                    this.segmentHashCodes[this.segmentCount] = segmentHashCode;
                    this.segmentBoundaries[++this.segmentCount] = length;
                    this.hashCode = hashCode;
                    this.encodedPath = this.intern(characters, 0, length, hashCode);
                }
            }

            protected boolean matches(URI value) {
                return value.matches(this.encodedPath);
            }

            public URI getInternalizedValue() {
                int segmentCount = this.segmentCount;
                if (this.segments.length <= segmentCount) {
                    this.segments = new String[segmentCount + 1];
                }
                char[] characters = this.isAbsoluteFile ? this.absoluteCharacters : this.relativeCharacters;
                String device = null;
                String authority = null;
                int segmentsHashCode = 1;
                int deviceIndex = 0;
                int ignoredEmptySegmentIndex = -1;
                boolean ignoredEmptySegment = false;
                int i = 0;
                int segmentIndex = 0;
                int offset = this.segmentBoundaries[0];
                while (segmentIndex < segmentCount) {
                    int end = this.segmentBoundaries[i + 1];
                    int count = end - offset;
                    if (i == ignoredEmptySegmentIndex && count == 0) {
                        --segmentCount;
                        ignoredEmptySegment = true;
                    } else {
                        int segmentHashCode = this.segmentHashCodes[i];
                        String segment = this.intern(characters, offset, count, segmentHashCode);
                        if (i == deviceIndex && this.isAbsoluteFile && (count == 0 && segmentCount > 1 || characters[end - 1] == ':')) {
                            if (count == 0) {
                                offset = end + 1;
                                segmentHashCode = this.segmentHashCodes[++i];
                                end = this.segmentBoundaries[i + 1];
                                count = end - offset;
                                authority = this.intern(characters, offset, count, segmentHashCode);
                                segmentCount -= 2;
                                deviceIndex = 2;
                                ignoredEmptySegmentIndex = 2;
                            } else {
                                device = segment;
                                --segmentCount;
                                ignoredEmptySegmentIndex = deviceIndex + 1;
                            }
                        } else {
                            this.segments[segmentIndex++] = segment;
                            segmentsHashCode = 31 * segmentsHashCode + segmentHashCode;
                        }
                    }
                    offset = end + 1;
                    ++i;
                }
                this.usedSegmentCount = segmentCount;
                String[] internedSegments = this.internArray(this.segments, 0, segmentCount, segmentsHashCode);
                if (this.isAbsoluteFile) {
                    return new Hierarchical(this.hashCode, true, URI.SCHEME_FILE, authority, device, segmentCount > 0 || ignoredEmptySegment, internedSegments, null);
                }
                return new Hierarchical(this.hashCode, true, null, null, null, this.isAbsolutePath, internedSegments, null);
            }

            public void reset(boolean isExclusive) {
                int i = 0;
                while (i < this.usedSegmentCount) {
                    this.segments[i] = null;
                    ++i;
                }
                this.usedSegmentCount = 0;
                this.segmentCount = 0;
                this.encodedPath = null;
                this.path = null;
                super.reset(isExclusive);
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            protected static class Queue
            extends Pool.AccessUnit.Queue<URI> {
                private static final long serialVersionUID = 1L;

                protected Queue() {
                }

                public FileAccessUnit pop(boolean isExclusive) {
                    return (FileAccessUnit)super.pop(isExclusive);
                }

                @Override
                protected Pool.AccessUnit<URI> newAccessUnit() {
                    return new FileAccessUnit(this);
                }
            }
        }

        protected static class PlatformAccessUnit
        extends URIPoolAccessUnitBase {
            protected static final int PLATFORM_RESOURCE_BASE_FULL_HASH_CODE = "platform:/resource/".hashCode();
            protected static final int PLATFORM_PLUGIN_BASE_FULL_HASH_CODE = "platform:/plugin/".hashCode();
            protected static final int PLATFORM_RESOURCE_BASE_INITIAL_HASH_CODE = "platform:/resource".hashCode();
            protected static final int PLATFORM_PLUGIN_BASE_INITIAL_HASH_CODE = "platform:/plugin".hashCode();
            protected String base;
            protected String path;
            protected boolean encode;
            protected char[] characters = new char[100];
            protected String[] segments = new String[20];
            protected int segmentCount;
            protected int usedSegmentCount;
            protected int[] segmentBoundaries = new int[100];
            protected int[] segmentHashCodes = new int[100];
            protected String encodedPath;

            protected PlatformAccessUnit(Queue queue) {
                super(queue);
            }

            protected void setValue(String base, String path, boolean encode) {
                this.base = base;
                this.path = path;
                this.encode = encode;
                int length = path.length();
                if (length == 0) {
                    this.encodedPath = "/";
                    this.segmentBoundaries[this.segmentCount] = 0;
                    this.segmentBoundaries[this.segmentCount++] = 1;
                    this.hashCode = base == URI.SEGMENT_RESOURCE ? PLATFORM_RESOURCE_BASE_FULL_HASH_CODE : PLATFORM_PLUGIN_BASE_FULL_HASH_CODE;
                } else {
                    int maxEncodedLength = 3 * length;
                    if (this.characters.length <= maxEncodedLength) {
                        this.characters = new char[maxEncodedLength + 1];
                    }
                    if (this.segmentBoundaries.length < length) {
                        this.segmentBoundaries = new int[length];
                        this.segmentHashCodes = new int[length];
                    }
                    boolean isModified = false;
                    char separatorchar = File.separatorChar;
                    char character = path.charAt(0);
                    if (character == '/') {
                        path.getChars(0, length, this.characters, 0);
                    } else if (character == separatorchar) {
                        this.characters[0] = 47;
                        if (length != 1) {
                            path.getChars(1, length, this.characters, 1);
                        }
                        isModified = true;
                    } else {
                        this.characters[0] = 47;
                        path.getChars(0, length, this.characters, 1);
                        ++length;
                        isModified = true;
                    }
                    int hashCode = 47;
                    int segmentHashCode = 0;
                    int i = 1;
                    while (i < length) {
                        character = this.characters[i];
                        if (encode ? character < '\u00a0' && !URI.matches(character, SEGMENT_CHAR_HI, SEGMENT_CHAR_LO) : URI.matches(character, PLATFORM_SEGMENT_RESERVED_HI, PLATFORM_SEGMENT_RESERVED_LO)) {
                            if (character == '/') {
                                this.segmentHashCodes[this.segmentCount] = segmentHashCode;
                                this.segmentBoundaries[this.segmentCount++] = i;
                                segmentHashCode = 0;
                                hashCode = 31 * hashCode + 47;
                            } else if (character == separatorchar) {
                                this.characters[i] = 47;
                                this.segmentHashCodes[this.segmentCount] = segmentHashCode;
                                this.segmentBoundaries[this.segmentCount++] = i;
                                segmentHashCode = 0;
                                hashCode = 31 * hashCode + 47;
                                isModified = true;
                            } else {
                                isModified = true;
                                System.arraycopy(this.characters, i + 1, this.characters, i + 3, length - i - 1);
                                this.characters[i] = 37;
                                hashCode = 31 * hashCode + 37;
                                segmentHashCode = 31 * segmentHashCode + 37;
                                char firstHexCharacter = this.characters[++i] = HEX_DIGITS[character >> 4 & 0xF];
                                hashCode = 31 * hashCode + firstHexCharacter;
                                segmentHashCode = 31 * segmentHashCode + firstHexCharacter;
                                char secondHexCharacter = this.characters[++i] = HEX_DIGITS[character & 0xF];
                                hashCode = 31 * hashCode + secondHexCharacter;
                                segmentHashCode = 31 * segmentHashCode + secondHexCharacter;
                                length += 2;
                            }
                        } else {
                            hashCode = 31 * hashCode + character;
                            segmentHashCode = 31 * segmentHashCode + character;
                        }
                        ++i;
                    }
                    this.segmentHashCodes[this.segmentCount] = segmentHashCode;
                    this.segmentBoundaries[this.segmentCount++] = length;
                    this.hashCode = (base == URI.SEGMENT_RESOURCE ? PLATFORM_RESOURCE_BASE_INITIAL_HASH_CODE : PLATFORM_PLUGIN_BASE_INITIAL_HASH_CODE) * CommonUtil.powerOf31(length) + hashCode;
                    this.encodedPath = isModified ? this.intern(this.characters, 0, length, hashCode) : path;
                }
            }

            protected boolean matches(URI value) {
                return value.matches(this.base, this.encodedPath);
            }

            public URI getInternalizedValue() {
                if (this.segments.length <= this.segmentCount) {
                    this.segments = new String[this.segmentCount + 1];
                }
                this.segments[0] = this.base;
                int hashCode = 31 + this.base.hashCode();
                int i = 0;
                int offset = 1;
                int segmentCount = this.segmentCount;
                while (i < segmentCount) {
                    int segmentHashCode = this.segmentHashCodes[i];
                    int end = this.segmentBoundaries[i++];
                    int count = end - offset;
                    this.segments[i] = this.intern(this.characters, offset, count, segmentHashCode);
                    hashCode = 31 * hashCode + segmentHashCode;
                    offset = end + 1;
                }
                this.usedSegmentCount = this.segmentCount + 1;
                return new Hierarchical(this.hashCode, true, URI.SCHEME_PLATFORM, null, null, true, this.internArray(this.segments, 0, this.usedSegmentCount, hashCode), null);
            }

            public void reset(boolean isExclusive) {
                int i = 0;
                while (i < this.usedSegmentCount) {
                    this.segments[i] = null;
                    ++i;
                }
                this.segmentCount = 0;
                this.usedSegmentCount = 0;
                this.encodedPath = null;
                this.base = null;
                this.path = null;
                super.reset(isExclusive);
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            protected static class Queue
            extends Pool.AccessUnit.Queue<URI> {
                private static final long serialVersionUID = 1L;

                protected Queue() {
                }

                public PlatformAccessUnit pop(boolean isExclusive) {
                    return (PlatformAccessUnit)super.pop(isExclusive);
                }

                @Override
                protected Pool.AccessUnit<URI> newAccessUnit() {
                    return new PlatformAccessUnit(this);
                }
            }
        }

        protected static class StringAccessUnit
        extends URIPoolAccessUnitBase {
            protected final URIPool pool;
            protected String value;
            protected int findHashCode;
            protected char findTerminatingCharacter;
            protected SegmentSequence.StringArrayPool.SubstringAccessUnit stringArraySubstringAccessUnit = new SegmentSequence.StringArrayPool.SubstringAccessUnit(null);
            protected SegmentSequence.StringArrayPool.SegmentsAndSubsegmentAccessUnit stringArraySegmentsAndSubsegmentAccessUnit = new SegmentSequence.StringArrayPool.SegmentsAndSubsegmentAccessUnit(null);

            protected String[] internArray(String segment, int offset, int count, int hashCode) {
                this.stringArraySubstringAccessUnit.setValue(segment, offset, count, hashCode);
                return SegmentSequence.STRING_ARRAY_POOL.doIntern(false, this.stringArraySubstringAccessUnit);
            }

            protected String[] internArray(int hashCode, String[] segments, int segmentCount, String segment, int offset, int count, int segmentHashCode) {
                if (segmentCount == 0) {
                    return this.internArray(segment, offset, count, segmentHashCode);
                }
                this.stringArraySegmentsAndSubsegmentAccessUnit.setValue(hashCode, segments, segmentCount, segment, offset, count, segmentHashCode);
                return SegmentSequence.STRING_ARRAY_POOL.doIntern(false, this.stringArraySegmentsAndSubsegmentAccessUnit);
            }

            protected StringAccessUnit(Queue queue, URIPool pool) {
                super(queue);
                this.pool = pool;
            }

            protected void setValue(String value) {
                this.value = value;
                this.hashCode = value.hashCode();
            }

            protected void setValue(String value, int hashCode) {
                this.value = value;
                this.hashCode = hashCode;
            }

            protected boolean matches(URI value) {
                return value.matches(this.value);
            }

            public URI match() {
                URI result = (URI)super.match();
                return result == null ? this.getInternalizedValue() : result;
            }

            public URI getInternalizedValue() {
                return this.parseIntoURI(this.value);
            }

            protected URI parseIntoURI(String uri) {
                URI resultURI;
                boolean hasExpectedHashCode = true;
                boolean isSchemeNormal = true;
                String scheme = null;
                String authority = null;
                String device = null;
                boolean absolutePath = false;
                String[] segments = NO_SEGMENTS;
                int segmentsHashCode = 1;
                String query = null;
                boolean isArchiveScheme = false;
                boolean isPlatformScheme = false;
                int length = uri.length();
                int i = 0;
                int j = this.findMajorSeparator(length, uri, i);
                if (this.findTerminatingCharacter == ':') {
                    int findHashCode = this.findHashCode;
                    if (findHashCode == SCHEME_PLATFORM_HASH_CODE) {
                        scheme = URI.SCHEME_PLATFORM;
                        isPlatformScheme = true;
                    } else if (findHashCode == SCHEME_FILE_HASH_CODE) {
                        scheme = URI.SCHEME_FILE;
                    } else if (findHashCode == SCHEME_HTTP_HASH_CODE) {
                        scheme = URI.SCHEME_HTTP;
                    } else if (findHashCode == SCHEME_JAR_HASH_CODE) {
                        scheme = URI.SCHEME_JAR;
                        isArchiveScheme = true;
                    } else if (findHashCode == SCHEME_ARCHIVE_HASH_CODE) {
                        scheme = URI.SCHEME_ARCHIVE;
                        isArchiveScheme = true;
                    } else if (findHashCode == SCHEME_ZIP_HASH_CODE) {
                        scheme = URI.SCHEME_ZIP;
                        isArchiveScheme = true;
                    }
                    if (scheme == null || !scheme.regionMatches(0, uri, 0, j)) {
                        String unnormalizedScheme = this.intern(uri, 0, j, findHashCode);
                        this.stringAccessUnit.setValue(true, unnormalizedScheme);
                        this.stringAccessUnit.add(unnormalizedScheme, this.stringPoolEntry);
                        scheme = this.stringAccessUnit.match();
                        this.stringAccessUnit.reset(false);
                        isSchemeNormal = unnormalizedScheme == scheme;
                        hasExpectedHashCode = scheme.hashCode() == findHashCode;
                        String[] stringArray = ARCHIVE_SCHEMES;
                        int n = ARCHIVE_SCHEMES.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String archiveScheme = stringArray[n2];
                            if (scheme == archiveScheme) {
                                isArchiveScheme = true;
                                break;
                            }
                            ++n2;
                        }
                        isPlatformScheme = scheme == URI.SCHEME_PLATFORM;
                    }
                    i = j + 1;
                    j = this.findSegmentEnd(length, uri, i);
                }
                if (isArchiveScheme) {
                    j = uri.lastIndexOf(URI.ARCHIVE_SEPARATOR);
                    if (j == -1) {
                        throw new IllegalArgumentException("no archive separator");
                    }
                    absolutePath = true;
                    authority = this.intern(uri, i, ++j - i);
                    i = j + 1;
                    j = this.findSegmentEnd(length, uri, i);
                } else if (i == j && this.findTerminatingCharacter == '/') {
                    if ((j = this.findSegmentEnd(length, uri, ++i)) == i && this.findTerminatingCharacter == '/') {
                        j = this.findSegmentEnd(length, uri, ++i);
                        authority = this.intern(uri, i, j - i, this.findHashCode);
                        i = j;
                        if (this.findTerminatingCharacter == '/') {
                            absolutePath = true;
                            j = this.findSegmentEnd(length, uri, ++i);
                        }
                    } else {
                        absolutePath = true;
                    }
                } else if (scheme != null) {
                    authority = this.intern(uri, i, length - i);
                    URI resultURI2 = this.pool.intern(false, -1, false, scheme, authority, null, false, null, null);
                    this.hashCode = resultURI2.hashCode();
                    return resultURI2;
                }
                boolean segmentsRemain = false;
                int start = i;
                int len = j - i;
                i = j;
                if (len == 0) {
                    if (this.findTerminatingCharacter != '?') {
                        segments = ONE_EMPTY_SEGMENT;
                        segmentsHashCode = 31;
                        j = this.findSegmentEnd(length, uri, ++i);
                        segmentsRemain = true;
                    }
                } else if (!isArchiveScheme && !isPlatformScheme && uri.charAt(j - 1) == ':') {
                    device = this.intern(uri, start, len, this.findHashCode);
                    if (this.findTerminatingCharacter == '?') {
                        absolutePath = false;
                    } else {
                        segmentsRemain = ++i != (j = this.findSegmentEnd(length, uri, i)) || this.findTerminatingCharacter == '/';
                    }
                } else {
                    segments = this.internArray(uri, start, j - start, this.findHashCode);
                    segmentsHashCode = 31 * segmentsHashCode + this.findHashCode;
                    if (this.findTerminatingCharacter != '?') {
                        j = this.findSegmentEnd(length, uri, ++i);
                        segmentsRemain = true;
                    }
                }
                if (segmentsRemain) {
                    while (true) {
                        segments = this.internArray(segmentsHashCode, segments, segments.length, uri, i, j - i, this.findHashCode);
                        segmentsHashCode = 31 * segmentsHashCode + this.findHashCode;
                        i = j;
                        if (this.findTerminatingCharacter != '/') break;
                        j = this.findSegmentEnd(length, uri, ++i);
                    }
                }
                if (i++ < length) {
                    query = this.intern(uri, i, length - i);
                }
                if (hasExpectedHashCode) {
                    resultURI = this.pool.intern(true, true, scheme, authority, device, absolutePath, segments, query, this.hashCode);
                } else {
                    resultURI = this.pool.intern(true, -1, true, scheme, authority, device, absolutePath, segments, query);
                    this.hashCode = resultURI.hashCode();
                }
                if (isSchemeNormal) {
                    resultURI.cacheString(uri);
                }
                return resultURI;
            }

            protected int findMajorSeparator(int length, String s, int i) {
                this.findTerminatingCharacter = (char)63;
                int hashCode = 0;
                while (i < length) {
                    char c = s.charAt(i);
                    if (c == '/' || c == ':' || c == '?') {
                        this.findTerminatingCharacter = c;
                        break;
                    }
                    hashCode = 31 * hashCode + c;
                    ++i;
                }
                this.findHashCode = hashCode;
                return i;
            }

            protected int findSegmentEnd(int length, String s, int i) {
                this.findTerminatingCharacter = (char)63;
                int hashCode = 0;
                while (i < length) {
                    char c = s.charAt(i);
                    if (c == '/' || c == '?') {
                        this.findTerminatingCharacter = c;
                        break;
                    }
                    hashCode = 31 * hashCode + c;
                    ++i;
                }
                this.findHashCode = hashCode;
                return i;
            }

            public void reset(boolean isExclusive) {
                this.value = null;
                super.reset(isExclusive);
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            protected static class Queue
            extends Pool.AccessUnit.Queue<URI> {
                private static final long serialVersionUID = 1L;
                protected final URIPool pool;

                public Queue(URIPool pool) {
                    this.pool = pool;
                }

                public StringAccessUnit pop(boolean isExclusive) {
                    return (StringAccessUnit)super.pop(isExclusive);
                }

                @Override
                protected Pool.AccessUnit<URI> newAccessUnit() {
                    return new StringAccessUnit(this, this.pool);
                }
            }
        }

        protected static class URIComponentsAccessUnit
        extends URIPoolAccessUnitBase {
            protected static final int VALIDATE_NONE = -1;
            protected static final int VALIDATE_ALL = -2;
            protected static final int VALIDATE_QUERY = -3;
            int validate;
            boolean hierarchical;
            String scheme;
            String authority;
            String device;
            boolean absolutePath;
            String[] segments;
            String query;
            SegmentSequence.StringArrayPool.SegmentsAccessUnit stringArraySegmentsAccessUnit = new SegmentSequence.StringArrayPool.SegmentsAccessUnit(null);

            protected URIComponentsAccessUnit(Queue queue) {
                super(queue);
            }

            protected String[] internArray(String[] segments, int count) {
                if (segments == null) {
                    return SegmentSequence.EMPTY_ARRAY;
                }
                this.stringArraySegmentsAccessUnit.setValue(true, true, segments, count);
                return SegmentSequence.STRING_ARRAY_POOL.doIntern(false, this.stringArraySegmentsAccessUnit);
            }

            protected void setValue(boolean hierarchical, String scheme, String authority, String device, boolean absolutePath, String[] segments, String query, int hashCode) {
                this.validate = -1;
                this.hierarchical = hierarchical;
                this.scheme = scheme;
                this.authority = authority;
                this.device = device;
                this.absolutePath = absolutePath;
                this.segments = segments;
                this.query = query;
                this.hashCode = hashCode;
            }

            protected void setValue(int validate, boolean hierarchical, String scheme, String authority, String device, boolean absolutePath, String[] segments, String query) {
                int hashCode = 0;
                if (scheme != null) {
                    if (validate == -2) {
                        scheme = this.intern(true, scheme);
                    }
                    hashCode = scheme.hashCode() * 31 + 58;
                }
                this.validate = validate;
                this.hierarchical = hierarchical;
                this.scheme = scheme;
                this.authority = authority;
                this.device = device;
                this.absolutePath = absolutePath;
                this.segments = segments;
                this.query = query;
                if (hierarchical) {
                    if (segments == null) {
                        segments = NO_SEGMENTS;
                    }
                    this.segments = segments;
                    if (authority != null) {
                        if (!URI.isArchiveScheme(scheme)) {
                            hashCode = hashCode * 961 + AUTHORITY_SEPARATOR_HASH_CODE;
                        }
                        hashCode = hashCode * CommonUtil.powerOf31(authority.length()) + authority.hashCode();
                    }
                    if (device != null) {
                        hashCode = hashCode * 31 + 47;
                        hashCode = hashCode * CommonUtil.powerOf31(device.length()) + device.hashCode();
                    }
                    if (absolutePath) {
                        hashCode = hashCode * 31 + 47;
                    }
                    int i = 0;
                    int len = segments.length;
                    while (i < len) {
                        String segment;
                        if (i != 0) {
                            hashCode = hashCode * 31 + 47;
                        }
                        if ((segment = segments[i]) == null) {
                            throw new IllegalArgumentException("invalid segment: null");
                        }
                        hashCode = hashCode * CommonUtil.powerOf31(segment.length()) + segment.hashCode();
                        ++i;
                    }
                    if (query != null) {
                        hashCode = hashCode * 31 + 63;
                        hashCode = hashCode * CommonUtil.powerOf31(query.length()) + query.hashCode();
                    }
                } else {
                    hashCode = hashCode * CommonUtil.powerOf31(authority.length()) + authority.hashCode();
                }
                this.hashCode = hashCode;
            }

            protected boolean matches(URI value) {
                return value.matches(this.validate, this.hierarchical, this.scheme, this.authority, this.device, this.absolutePath, this.segments, this.query);
            }

            public URI getInternalizedValue() {
                if (this.validate == -2) {
                    URI.validateURI(this.hierarchical, this.scheme, this.authority, this.device, this.absolutePath, this.segments, this.query, null);
                    if (this.authority != null) {
                        this.authority = this.intern(this.authority);
                    }
                    if (this.device != null) {
                        this.device = this.intern(this.device);
                    }
                    String[] stringArray = this.segments = this.segments == null ? null : this.internArray(this.segments, this.segments.length);
                    if (this.query != null) {
                        this.query = this.intern(this.query);
                    }
                } else if (this.validate == -3) {
                    if (!URI.validQuery(this.query)) {
                        throw new IllegalArgumentException("invalid query portion: " + this.query);
                    }
                    if (this.query != null) {
                        this.query = this.intern(this.query);
                    }
                } else if (this.validate != -1) {
                    int i = this.validate;
                    int length = this.segments.length;
                    while (i < length) {
                        String segment = this.segments[i];
                        if (!URI.validSegment(segment)) {
                            throw new IllegalArgumentException("invalid segment: " + segment);
                        }
                        ++i;
                    }
                }
                if (this.hierarchical) {
                    return new Hierarchical(this.hashCode, this.hierarchical, this.scheme, this.authority, this.device, this.absolutePath, this.segments, this.query);
                }
                return new Opaque(this.hashCode, this.scheme, this.authority);
            }

            public void reset(boolean isExclusive) {
                this.scheme = null;
                this.authority = null;
                this.device = null;
                this.segments = null;
                this.query = null;
                super.reset(isExclusive);
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            protected static class Queue
            extends Pool.AccessUnit.Queue<URI> {
                private static final long serialVersionUID = 1L;

                protected Queue() {
                }

                public URIComponentsAccessUnit pop(boolean isExclusive) {
                    return (URIComponentsAccessUnit)super.pop(isExclusive);
                }

                @Override
                protected Pool.AccessUnit<URI> newAccessUnit() {
                    return new URIComponentsAccessUnit(this);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static class URIPoolAccessUnitBase
        extends Pool.AccessUnit<URI> {
            protected CommonUtil.StringPool.CharactersAccessUnit charactersAccessUnit = new CommonUtil.StringPool.CharactersAccessUnit(null);
            protected CommonUtil.StringPool.StringAccessUnit stringAccessUnit = new CommonUtil.StringPool.StringAccessUnit(CommonUtil.STRING_POOL, null);
            protected CommonUtil.StringPool.StringPoolEntry stringPoolEntry;
            protected CommonUtil.StringPool.SubstringAccessUnit substringAccessUnit = new CommonUtil.StringPool.SubstringAccessUnit(null){

                public void reset(boolean isExclusive) {
                    URIPoolAccessUnitBase.this.stringPoolEntry = (CommonUtil.StringPool.StringPoolEntry)this.getEntry();
                    super.reset(isExclusive);
                }
            };
            protected SegmentSequence.StringArrayPool.SegmentsAndSegmentCountAccessUnit stringArraySegmentsAndSegmentCountAccessUnit = new SegmentSequence.StringArrayPool.SegmentsAndSegmentCountAccessUnit(null);

            protected URIPoolAccessUnitBase(Pool.AccessUnit.Queue<URI> queue) {
                super(queue);
            }

            @Override
            protected URI getValue() {
                throw new UnsupportedOperationException();
            }

            @Override
            protected void setValue(URI value) {
                throw new UnsupportedOperationException();
            }

            @Override
            protected boolean setArbitraryValue(Object value) {
                throw new UnsupportedOperationException();
            }

            protected String intern(String string) {
                this.stringAccessUnit.setValue(string);
                return CommonUtil.STRING_POOL.doIntern(false, this.stringAccessUnit);
            }

            protected String intern(boolean toLowerCase, String string) {
                this.stringAccessUnit.setValue(toLowerCase, string);
                return CommonUtil.STRING_POOL.doIntern(false, this.stringAccessUnit);
            }

            protected String intern(String string, int offset, int count, int hashCode) {
                this.substringAccessUnit.setValue(string, offset, count, hashCode);
                return CommonUtil.STRING_POOL.doIntern(false, this.substringAccessUnit);
            }

            protected String intern(String string, int offset, int count) {
                this.substringAccessUnit.setValue(string, offset, count);
                return CommonUtil.STRING_POOL.doIntern(false, this.substringAccessUnit);
            }

            protected String intern(char[] characters, int offset, int count) {
                this.charactersAccessUnit.setValue(characters, offset, count);
                return CommonUtil.STRING_POOL.doIntern(false, this.charactersAccessUnit);
            }

            protected String intern(char[] characters, int offset, int count, int hashCode) {
                this.charactersAccessUnit.setValue(characters, offset, count, hashCode);
                return CommonUtil.STRING_POOL.doIntern(false, this.charactersAccessUnit);
            }

            protected String[] internArray(String[] segments, int offset, int segmentCount, int hashCode) {
                this.stringArraySegmentsAndSegmentCountAccessUnit.setValue(segments, offset, segmentCount, hashCode);
                return SegmentSequence.STRING_ARRAY_POOL.doIntern(false, this.stringArraySegmentsAndSegmentCountAccessUnit);
            }

            @Override
            public void reset(boolean isExclusive) {
                this.stringPoolEntry = null;
                super.reset(isExclusive);
            }
        }
    }
}

