/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.graph.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.modelengineers.MoRe_elk.core.util.Maybe;
import com.modelengineers.MoRe_elk.graph.ElkNode;
import com.modelengineers.MoRe_elk.graph.json.JsonExporter;
import com.modelengineers.MoRe_elk.graph.json.JsonImportException;
import com.modelengineers.MoRe_elk.graph.json.JsonImporter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public final class ElkGraphJson {
    private ElkGraphJson() {
    }

    public static ImportBuilder forGraph(String graph) {
        ImportBuilder ib = new ImportBuilder();
        ib.graph = graph;
        return ib;
    }

    public static ImportBuilder forGraph(JsonObject graph) {
        ImportBuilder ib = new ImportBuilder();
        ib.jsonGraph = graph;
        return ib;
    }

    public static ExportBuilder forGraph(ElkNode graph) {
        ExportBuilder eb = new ExportBuilder();
        eb.graph = graph;
        return eb;
    }

    public static final class ExportBuilder {
        private ElkNode graph;
        private boolean prettyPrint = false;
        private boolean omitZeroPosition = true;
        private boolean omitZeroDimension = true;
        private boolean omitLayoutInformation = false;
        private boolean shortLayoutOptionKeys = true;
        private boolean omitUnknownLayoutOptions = true;

        public ExportBuilder prettyPrint(boolean pretty) {
            this.prettyPrint = pretty;
            return this;
        }

        public ExportBuilder shortLayoutOptionKeys(boolean shortKeys) {
            this.shortLayoutOptionKeys = shortKeys;
            return this;
        }

        public ExportBuilder omitZeroPositions(boolean omitZeroPos) {
            this.omitZeroPosition = omitZeroPos;
            return this;
        }

        public ExportBuilder omitZeroDimension(boolean omitZeroDim) {
            this.omitZeroDimension = omitZeroDim;
            return this;
        }

        public ExportBuilder omitLayout(boolean omitLayout) {
            this.omitLayoutInformation = omitLayout;
            return this;
        }

        public ExportBuilder omitUnknownLayoutOptions(boolean omitUnknownOptions) {
            this.omitUnknownLayoutOptions = omitUnknownOptions;
            return this;
        }

        public String toJson() {
            JsonExporter exporter = new JsonExporter();
            exporter.setOptions(this.omitZeroPosition, this.omitZeroDimension, this.omitLayoutInformation, this.shortLayoutOptionKeys, this.omitUnknownLayoutOptions);
            JsonObject jsonGraph = exporter.export(this.graph);
            GsonBuilder builder = new GsonBuilder();
            builder.disableHtmlEscaping();
            if (this.prettyPrint) {
                builder.setPrettyPrinting();
            }
            Gson gson = builder.create();
            String json = gson.toJson((JsonElement)jsonGraph);
            return json;
        }
    }

    public static final class ImportBuilder {
        private JsonObject jsonGraph;
        private String graph;
        private Maybe<JsonImporter> importerMaybe;
        private boolean lenient = true;
        private static final TypeAdapter<JsonElement> GSON_ELEMENT_ADAPTER = new Gson().getAdapter(JsonElement.class);

        public ImportBuilder rememberImporter(Maybe<JsonImporter> maybe) {
            this.importerMaybe = maybe;
            return this;
        }

        public ImportBuilder lenient(boolean beLenient) {
            this.lenient = beLenient;
            return this;
        }

        public ElkNode toElk() {
            if (this.jsonGraph == null) {
                JsonReader reader = new JsonReader((Reader)new StringReader(this.graph));
                reader.setLenient(this.lenient);
                try {
                    JsonElement json = (JsonElement)GSON_ELEMENT_ADAPTER.read(reader);
                    if (!(json instanceof JsonObject)) {
                        throw new JsonImportException("Top-level element of the graph must be a json object.");
                    }
                    this.jsonGraph = json.getAsJsonObject();
                }
                catch (IOException e) {
                    throw new JsonIOException((Throwable)e);
                }
            }
            JsonImporter importer = new JsonImporter();
            ElkNode elkGraph = importer.transform(this.jsonGraph);
            if (this.importerMaybe != null) {
                this.importerMaybe.set(importer);
            }
            return elkGraph;
        }
    }
}

