/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.core.util;

import com.modelengineers.MoRe_elk.core.util.persistence.ElkGraphResource;
import com.modelengineers.MoRe_elk.graph.ElkNode;
import com.modelengineers.MoRe_emf.common.util.URI;
import com.modelengineers.MoRe_emf.ecore.resource.Resource;
import com.modelengineers.MoRe_emf.ecore.resource.impl.ResourceSetImpl;
import java.io.StringWriter;
import java.util.Collections;

public final class LoggedGraph {
    private final Object graph;
    private final Type graphType;
    private final String tag;

    public LoggedGraph(Object graph, String tag, Type graphType) {
        graphType.checkTypeCompatibility(graph);
        this.graph = graph;
        this.tag = tag;
        this.graphType = graphType;
    }

    public Object getGraph() {
        return this.graph;
    }

    public Type getGraphType() {
        return this.graphType;
    }

    public String getTag() {
        return this.tag;
    }

    public String serialize() {
        switch (this.graphType) {
            case ELK: {
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                Resource resource = resourceSet.createResource(URI.createFileURI("dummy.elkg"));
                if (resource instanceof ElkGraphResource) {
                    resource.getContents().add((ElkNode)this.graph);
                    try {
                        StringWriter stringWriter = new StringWriter();
                        ((ElkGraphResource)((Object)resource)).save(stringWriter, Collections.emptyMap());
                        return stringWriter.toString();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return "Unexpected problem serializing ELK Graph.";
            }
        }
        return this.graph.toString();
    }

    public static enum Type {
        ELK(ElkNode.class, "elkg"),
        JSON(String.class, "json"),
        DOT(String.class, "dot"),
        SVG(String.class, "svg");

        private final Class<?> expectedType;
        private final String fileExtension;

        private Type(Class<?> expectedType, String fileExtension) {
            this.expectedType = expectedType;
            this.fileExtension = fileExtension;
        }

        public boolean isTypeCompatible(Object o) {
            return this.expectedType.isAssignableFrom(o.getClass());
        }

        public void checkTypeCompatibility(Object o) {
            if (!this.isTypeCompatible(o)) {
                throw new ClassCastException("Type " + o.getClass().getName() + " incompatible for " + this.name());
            }
        }

        public String getFileExtension() {
            return this.fileExtension;
        }
    }
}

