/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.core.ui.views;

import com.google.inject.ConfigurationException;
import com.google.inject.Injector;
import com.modelengineers.MoRe_elk.core.service.LayoutConnectorsService;
import com.modelengineers.MoRe_elk.core.ui.ElkUiPlugin;
import com.modelengineers.MoRe_elk.core.ui.views.LayoutPropertySourceProvider;
import com.modelengineers.MoRe_elk.core.ui.views.ValidatingPropertySheetEntry;
import com.modelengineers.MoRe_elk.core.util.Maybe;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class LayoutViewPart
extends ViewPart {
    public static final String VIEW_ID = "com.modelengineers.MoRe_elk.core.views.layout";
    public static final String PREF_CATEGORIES = "view.categories";
    public static final String PREF_ADVANCED = "view.advanced";
    private FormToolkit toolkit;
    private PropertySheetPage page;
    private LayoutPropertySourceProvider currentPropSourceProvider;
    private final ISelectionListener selectionListener = (part, selection) -> {
        Injector injector = LayoutConnectorsService.getInstance().getInjector(part, null);
        if (injector != null) {
            try {
                this.currentPropSourceProvider = (LayoutPropertySourceProvider)injector.getInstance(LayoutPropertySourceProvider.class);
                this.currentPropSourceProvider.setWorkbenchPart(part);
                this.page.setPropertySourceProvider((IPropertySourceProvider)this.currentPropSourceProvider);
                this.page.selectionChanged(part, selection);
            }
            catch (ConfigurationException exception) {
                Status status = new Status(4, "com.modelengineers.MoRe_elk.core.ui", "The Guice configuration for " + part.getTitle() + " is inconsistent.", (Throwable)exception);
                StatusManager.getManager().handle((IStatus)status, 1);
            }
        } else if (part instanceof IEditorPart) {
            this.currentPropSourceProvider = null;
            this.page.setPropertySourceProvider(null);
        }
    };
    private final IPartListener partListener = new IPartListener(){

        public void partClosed(IWorkbenchPart part) {
            if (LayoutViewPart.this.currentPropSourceProvider != null && part == LayoutViewPart.this.currentPropSourceProvider.getWorkbenchPart()) {
                LayoutViewPart.this.currentPropSourceProvider = null;
                LayoutViewPart.this.page.setPropertySourceProvider(null);
            }
        }

        public void partOpened(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partActivated(IWorkbenchPart part) {
        }
    };
    private static final int MARGIN_WIDTH = 4;
    private static final int FORM_LEFT = 0;
    private static final int FORM_RIGHT = 100;
    private static final int FORM_TOP = 0;
    private static final int FORM_BOTTOM = 100;

    public static LayoutViewPart findView() {
        if (Display.getCurrent() == null) {
            final Maybe part = new Maybe();
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    part.set(LayoutViewPart.findViewUI());
                }
            });
            return (LayoutViewPart)((Object)part.get());
        }
        return LayoutViewPart.findViewUI();
    }

    private static LayoutViewPart findViewUI() {
        IWorkbenchPage activePage;
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWindow != null && (activePage = activeWindow.getActivePage()) != null) {
            return (LayoutViewPart)activePage.findView(VIEW_ID);
        }
        return null;
    }

    public LayoutPropertySourceProvider getPropertySourceProvider() {
        return this.currentPropSourceProvider;
    }

    public void createPartControl(Composite parent) {
        IWorkbenchWindow workbenchWindow;
        IWorkbenchPage activePage;
        ActionContributionItem advancedItem;
        this.toolkit = new FormToolkit(parent.getDisplay());
        Form form = this.toolkit.createForm(parent);
        Composite content = form.getBody();
        FormLayout contentLayout = new FormLayout();
        contentLayout.marginWidth = 4;
        content.setLayout((Layout)contentLayout);
        this.page = new PropertySheetPage();
        this.page.setRootEntry((IPropertySheetEntry)new ValidatingPropertySheetEntry());
        this.page.createControl(content);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(0, 5);
        formData.bottom = new FormAttachment(100, 0);
        this.page.getControl().setLayoutData((Object)formData);
        IPreferenceStore preferenceStore = ElkUiPlugin.getInstance().getPreferenceStore();
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.page.setActionBars(actionBars);
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        ActionContributionItem categoriesItem = (ActionContributionItem)toolBarManager.find("categories");
        if (categoriesItem != null) {
            categoriesItem.getAction().setChecked(preferenceStore.getBoolean(PREF_CATEGORIES));
            categoriesItem.getAction().run();
        }
        if ((advancedItem = (ActionContributionItem)toolBarManager.find("filter")) != null) {
            advancedItem.getAction().setChecked(preferenceStore.getBoolean(PREF_ADVANCED));
            advancedItem.getAction().run();
        }
        if ((activePage = (workbenchWindow = this.getSite().getWorkbenchWindow()).getActivePage()) != null) {
            final IWorkbenchPart activePart = activePage.getActivePart();
            final ISelection selection = workbenchWindow.getSelectionService().getSelection();
            if (activePart != null && selection != null) {
                workbenchWindow.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        LayoutViewPart.this.selectionListener.selectionChanged(activePart, selection);
                    }
                });
            }
        }
        workbenchWindow.getSelectionService().addSelectionListener(this.selectionListener);
        workbenchWindow.getPartService().addPartListener(this.partListener);
    }

    public void setFocus() {
        this.page.setFocus();
    }

    public Control getControl() {
        return this.page.getControl();
    }

    public void dispose() {
        ActionContributionItem advancedItem;
        ActionContributionItem categoriesItem = (ActionContributionItem)this.getViewSite().getActionBars().getToolBarManager().find("categories");
        if (categoriesItem != null) {
            ElkUiPlugin.getInstance().getPreferenceStore().setValue(PREF_CATEGORIES, categoriesItem.getAction().isChecked());
        }
        if ((advancedItem = (ActionContributionItem)this.getViewSite().getActionBars().getToolBarManager().find("filter")) != null) {
            ElkUiPlugin.getInstance().getPreferenceStore().setValue(PREF_ADVANCED, advancedItem.getAction().isChecked());
        }
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener(this.selectionListener);
        this.getSite().getWorkbenchWindow().getPartService().removePartListener(this.partListener);
        this.currentPropSourceProvider = null;
        this.toolkit.dispose();
        super.dispose();
    }

    public void refresh() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                LayoutViewPart.this.page.refresh();
            }
        });
    }

    public List<IPropertySheetEntry> getSelection() {
        TreeItem[] treeItems;
        LinkedList<IPropertySheetEntry> entries = new LinkedList<IPropertySheetEntry>();
        TreeItem[] treeItemArray = treeItems = ((Tree)this.page.getControl()).getSelection();
        int n = treeItems.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            Object data = item.getData();
            if (data instanceof IPropertySheetEntry) {
                entries.add((IPropertySheetEntry)data);
            } else {
                TreeItem[] treeItemArray2 = item.getItems();
                int n3 = treeItemArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    TreeItem childItem = treeItemArray2[n4];
                    data = childItem.getData();
                    if (data instanceof IPropertySheetEntry) {
                        entries.add((IPropertySheetEntry)data);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return entries;
    }
}

