/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.core.ui.util;

import com.modelengineers.MoRe_elk.core.data.LayoutAlgorithmData;
import com.modelengineers.MoRe_elk.core.data.LayoutMetaDataService;
import com.modelengineers.MoRe_elk.core.data.LayoutOptionData;
import com.modelengineers.MoRe_elk.core.options.CoreOptions;
import com.modelengineers.MoRe_emf.common.command.AbstractCommand;
import com.modelengineers.MoRe_emf.common.command.Command;
import com.modelengineers.MoRe_emf.edit.domain.EditingDomain;
import com.modelengineers.MoRe_emf.transaction.RecordingCommand;
import com.modelengineers.MoRe_emf.transaction.TransactionalEditingDomain;

public final class ElkUiUtil {
    private ElkUiUtil() {
    }

    public static void runModelChange(final Runnable runnable, EditingDomain editingDomain, String label) {
        if (editingDomain instanceof TransactionalEditingDomain) {
            editingDomain.getCommandStack().execute((Command)new RecordingCommand((TransactionalEditingDomain)editingDomain, label){

                protected void doExecute() {
                    runnable.run();
                }
            });
        } else if (editingDomain != null) {
            editingDomain.getCommandStack().execute(new AbstractCommand(label){

                @Override
                public void execute() {
                    runnable.run();
                }

                @Override
                public boolean canUndo() {
                    return false;
                }

                @Override
                public void redo() {
                    this.execute();
                }
            });
        } else {
            runnable.run();
        }
    }

    public static LayoutOptionData getOptionData(LayoutAlgorithmData providerData, String optionName) {
        for (LayoutOptionData data : LayoutMetaDataService.getInstance().getOptionData()) {
            if (!data.getName().equals(optionName) || !providerData.knowsOption(data)) continue;
            return data;
        }
        return null;
    }

    public static LayoutOptionData getOptionData(LayoutAlgorithmData[] providerDataArray, String displayName) {
        LayoutAlgorithmData[] layoutAlgorithmDataArray = providerDataArray;
        int n = providerDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            LayoutAlgorithmData providerData = layoutAlgorithmDataArray[n2];
            LayoutOptionData optionData = ElkUiUtil.getOptionData(providerData, displayName);
            if (optionData != null) {
                return optionData;
            }
            ++n2;
        }
        return LayoutMetaDataService.getInstance().getOptionData(CoreOptions.ALGORITHM.getId());
    }
}

