/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.core.service.util;

import com.modelengineers.MoRe_elk.core.util.BasicProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitor;

public class ProgressMonitorAdapter
extends BasicProgressMonitor {
    private IProgressMonitor progressMonitor;
    private int submittedWork = 0;

    public ProgressMonitorAdapter(IProgressMonitor theprogressMonitor) {
        this.progressMonitor = theprogressMonitor;
    }

    public ProgressMonitorAdapter(IProgressMonitor theprogressMonitor, int maxLevels) {
        super(maxLevels);
        this.progressMonitor = theprogressMonitor;
    }

    @Override
    protected void doBegin(String name, float totalWork, boolean topInstance, int maxHierarchyLevels) {
        if (topInstance) {
            this.progressMonitor.beginTask(name, (int)(totalWork <= 0.0f ? -1.0f : totalWork));
        } else if (maxHierarchyLevels != 0) {
            this.progressMonitor.subTask(name);
        }
    }

    @Override
    protected void doDone(boolean topInstance, int maxHierarchyLevels) {
        if (topInstance) {
            this.progressMonitor.done();
        }
    }

    @Override
    public boolean isCanceled() {
        return this.progressMonitor.isCanceled();
    }

    @Override
    protected BasicProgressMonitor doSubTask(float work, int maxHierarchyLevels) {
        int newMaxHierarchyLevels = maxHierarchyLevels > 0 ? maxHierarchyLevels - 1 : maxHierarchyLevels;
        return new ProgressMonitorAdapter(this.progressMonitor).withMaxHierarchyLevels(newMaxHierarchyLevels).withLogging(this.isLoggingEnabled()).withLogPersistence(this.isLogPersistenceEnabled()).withExecutionTimeMeasurement(this.isExecutionTimeMeasured());
    }

    @Override
    protected void doWorked(float completedWork, float totalWork, boolean topInstance) {
        int newWork;
        if (topInstance && (newWork = (int)completedWork) > this.submittedWork) {
            this.progressMonitor.worked(newWork - this.submittedWork);
            this.submittedWork = newWork;
        }
    }
}

