/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.core.service;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.modelengineers.MoRe_elk.core.data.ILayoutMetaDataProvider;
import com.modelengineers.MoRe_elk.core.data.LayoutMetaDataService;
import com.modelengineers.MoRe_elk.core.service.LayoutConnectorsService;
import com.modelengineers.MoRe_elk.core.service.util.MonitoredOperation;
import com.modelengineers.MoRe_elk.core.util.Pair;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public final class ElkServicePlugin
extends Plugin {
    public static final String PLUGIN_ID = "com.modelengineers.MoRe_elk.core.service";
    private static ElkServicePlugin plugin;
    private IPreferenceStore preferenceStore;
    private ExecutorService executorService;
    private final Multimap<Pair<IWorkbenchPart, Object>, MonitoredOperation> runningOperations = HashMultimap.create();

    public static ElkServicePlugin getInstance() {
        return plugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.loadLayoutProvidersThroughJavaServices();
    }

    public void stop(BundleContext context) throws Exception {
        LayoutMetaDataService.unload();
        LayoutConnectorsService.unload();
        if (this.executorService != null) {
            this.executorService.shutdown();
            this.executorService = null;
        }
        this.preferenceStore = null;
        plugin = null;
        super.stop(context);
    }

    public IPreferenceStore getPreferenceStore() {
        if (this.preferenceStore == null) {
            this.preferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, this.getBundle().getSymbolicName());
        }
        return this.preferenceStore;
    }

    public synchronized ExecutorService getExecutorService() {
        if (this.executorService == null && plugin != null) {
            this.executorService = Executors.newCachedThreadPool();
        }
        return this.executorService;
    }

    public Multimap<Pair<IWorkbenchPart, Object>, MonitoredOperation> getRunningOperations() {
        return this.runningOperations;
    }

    private void loadLayoutProvidersThroughJavaServices() {
        HashSet<Class> providerClasses = new HashSet<Class>();
        Bundle[] bundleArray = this.getBundle().getBundleContext().getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            try {
                URL providerFile = bundle.getResource("/META-INF/services/" + ILayoutMetaDataProvider.class.getCanonicalName());
                if (providerFile != null) {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(providerFile.openStream()));
                    String line = reader.readLine();
                    while (line != null) {
                        providerClasses.add(bundle.loadClass(line));
                        line = reader.readLine();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        LayoutMetaDataService service = LayoutMetaDataService.getInstance();
        for (Class providerClass : providerClasses) {
            try {
                ILayoutMetaDataProvider provider = (ILayoutMetaDataProvider)providerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                service.registerLayoutMetaDataProviders(provider);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

