/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.core.service;

import com.google.common.collect.Multimap;
import com.google.inject.ConfigurationException;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.modelengineers.MoRe_elk.core.IGraphLayoutEngine;
import com.modelengineers.MoRe_elk.core.LayoutConfigurator;
import com.modelengineers.MoRe_elk.core.data.LayoutAlgorithmResolver;
import com.modelengineers.MoRe_elk.core.options.CoreOptions;
import com.modelengineers.MoRe_elk.core.options.PortConstraints;
import com.modelengineers.MoRe_elk.core.options.SizeConstraint;
import com.modelengineers.MoRe_elk.core.service.ElkServicePlugin;
import com.modelengineers.MoRe_elk.core.service.IDiagramLayoutConnector;
import com.modelengineers.MoRe_elk.core.service.LayoutConfigurationManager;
import com.modelengineers.MoRe_elk.core.service.LayoutConnectorsService;
import com.modelengineers.MoRe_elk.core.service.LayoutMapping;
import com.modelengineers.MoRe_elk.core.service.util.MonitoredOperation;
import com.modelengineers.MoRe_elk.core.util.BasicProgressMonitor;
import com.modelengineers.MoRe_elk.core.util.ElkUtil;
import com.modelengineers.MoRe_elk.core.util.IElkCancelIndicator;
import com.modelengineers.MoRe_elk.core.util.IElkProgressMonitor;
import com.modelengineers.MoRe_elk.core.util.IGraphElementVisitor;
import com.modelengineers.MoRe_elk.core.util.Maybe;
import com.modelengineers.MoRe_elk.core.util.Pair;
import com.modelengineers.MoRe_elk.core.validation.GraphValidator;
import com.modelengineers.MoRe_elk.core.validation.LayoutOptionValidator;
import com.modelengineers.MoRe_elk.graph.ElkGraphElement;
import com.modelengineers.MoRe_elk.graph.ElkNode;
import com.modelengineers.MoRe_elk.graph.properties.IProperty;
import com.modelengineers.MoRe_elk.graph.properties.IPropertyHolder;
import com.modelengineers.MoRe_elk.graph.properties.MapPropertyHolder;
import com.modelengineers.MoRe_elk.graph.properties.Property;
import com.modelengineers.MoRe_emf.common.util.URI;
import com.modelengineers.MoRe_emf.ecore.resource.Resource;
import com.modelengineers.MoRe_emf.ecore.resource.impl.ResourceSetImpl;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.ExecutorService;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.statushandlers.StatusManager;

@Singleton
public class DiagramLayoutEngine {
    public static final String PREF_DEBUG_LOGGING = "elk.debug.logs";
    public static final String PREF_DEBUG_STORE = "elk.debug.store";
    public static final String PREF_DEBUG_EXEC_TIME = "elk.debug.exectime";
    public static final IProperty<IDiagramLayoutConnector> MAPPING_CONNECTOR = new Property<IDiagramLayoutConnector>("layoutEngine.diagramLayoutConnector");
    public static final IProperty<IStatus> MAPPING_STATUS = new Property<IStatus>("layoutEngine.status");
    @Inject
    private IDiagramLayoutConnector connector;
    @Inject
    private LayoutConfigurationManager configManager;
    @Inject
    private IGraphLayoutEngine graphLayoutEngine;
    @Inject
    private LayoutAlgorithmResolver algorithmResolver;
    @Inject
    private Provider<GraphValidator> graphValidatorProvider;
    @Inject
    private Provider<LayoutOptionValidator> layoutOptionValidatorProvider;

    public static LayoutMapping invokeLayout(IWorkbenchPart workbenchPart, Object diagramPart, boolean animate, boolean progressBar, boolean layoutAncestors, boolean zoomToFit) {
        Parameters params = new Parameters();
        params.getGlobalSettings().setProperty(CoreOptions.ANIMATE, animate).setProperty(CoreOptions.PROGRESS_BAR, progressBar).setProperty(CoreOptions.LAYOUT_ANCESTORS, layoutAncestors).setProperty(CoreOptions.ZOOM_TO_FIT, zoomToFit);
        return DiagramLayoutEngine.invokeLayout(workbenchPart, diagramPart, params);
    }

    public static LayoutMapping invokeLayout(IWorkbenchPart workbenchPart, Object diagramPart, Parameters params) {
        return DiagramLayoutEngine.invokeLayout(workbenchPart, diagramPart, null, params);
    }

    public static LayoutMapping invokeLayout(IWorkbenchPart workbenchPart, Object diagramPart, IElkCancelIndicator cancelIndicator, Parameters params) {
        Injector injector = LayoutConnectorsService.getInstance().getInjector(workbenchPart, diagramPart);
        if (injector != null) {
            try {
                DiagramLayoutEngine engine = (DiagramLayoutEngine)injector.getInstance(DiagramLayoutEngine.class);
                if (cancelIndicator instanceof IElkProgressMonitor) {
                    return engine.layout(workbenchPart, diagramPart, (IElkProgressMonitor)cancelIndicator, params);
                }
                return engine.layout(workbenchPart, diagramPart, cancelIndicator, params);
            }
            catch (ConfigurationException exception) {
                Status status = new Status(4, "com.modelengineers.MoRe_elk.core.service", workbenchPart == null ? "The Guice configuration for the given selection is inconsistent." : "The Guice configuration for " + workbenchPart.getTitle() + " is inconsistent.", (Throwable)exception);
                StatusManager.getManager().handle((IStatus)status, 2);
            }
        } else {
            Status status = new Status(4, "com.modelengineers.MoRe_elk.core.service", workbenchPart == null ? "No layout connector is available for the given selection." : "No layout connector is available for " + workbenchPart.getTitle() + ".");
            StatusManager.getManager().handle((IStatus)status, 2);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LayoutMapping layout(final IWorkbenchPart workbenchPart, final Object diagramPart, IElkCancelIndicator cancelIndicator, Parameters params) {
        Multimap<Pair<IWorkbenchPart, Object>, MonitoredOperation> runningOperations;
        if (workbenchPart == null && diagramPart == null) {
            throw new NullPointerException();
        }
        final Parameters finalParams = params != null ? params : new Parameters();
        final Maybe layoutMapping = Maybe.create();
        final Pair<IWorkbenchPart, Object> target = Pair.of(workbenchPart, diagramPart);
        ExecutorService executorService = ElkServicePlugin.getInstance().getExecutorService();
        MonitoredOperation monitoredOperation = new MonitoredOperation(executorService, cancelIndicator){

            @Override
            protected void preUIexec() {
                LayoutMapping mapping;
                boolean layoutAncestors = finalParams.getGlobalSettings().getProperty(CoreOptions.LAYOUT_ANCESTORS);
                if (layoutAncestors && workbenchPart != null) {
                    mapping = DiagramLayoutEngine.this.connector.buildLayoutGraph(workbenchPart, null);
                    mapping.setParentElement(diagramPart);
                } else {
                    mapping = DiagramLayoutEngine.this.connector.buildLayoutGraph(workbenchPart, diagramPart);
                }
                if (mapping != null && mapping.getLayoutGraph() != null) {
                    DiagramLayoutEngine.this.addDiagramConfig(finalParams, mapping);
                }
                layoutMapping.set(mapping);
            }

            @Override
            protected IStatus execute(IElkProgressMonitor monitor) {
                Status status;
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                LayoutMapping mapping = (LayoutMapping)layoutMapping.get();
                if (mapping != null && mapping.getLayoutGraph() != null) {
                    status = DiagramLayoutEngine.this.layout(mapping, monitor, finalParams);
                    if (!monitor.isCanceled()) {
                        DiagramLayoutEngine.this.stopEarlierOperations(target, this.getTimestamp());
                    }
                    if (monitor.isRunning()) {
                        monitor.done();
                    }
                } else {
                    status = new Status(2, "com.modelengineers.MoRe_elk.core.service", "Unable to build the layout graph from the given selection.");
                }
                return status;
            }

            @Override
            protected void postUIexec() {
                if (layoutMapping.get() != null) {
                    DiagramLayoutEngine.this.connector.applyLayout((LayoutMapping)layoutMapping.get(), finalParams.getGlobalSettings());
                }
            }
        };
        Multimap<Pair<IWorkbenchPart, Object>, MonitoredOperation> multimap = runningOperations = ElkServicePlugin.getInstance().getRunningOperations();
        synchronized (multimap) {
            runningOperations.put(target, (Object)monitoredOperation);
        }
        try {
            boolean progressBar = finalParams.getGlobalSettings().getProperty(CoreOptions.PROGRESS_BAR);
            if (progressBar) {
                monitoredOperation.runMonitored();
            } else {
                monitoredOperation.runUnmonitored();
            }
        }
        catch (Throwable throwable) {
            Multimap<Pair<IWorkbenchPart, Object>, MonitoredOperation> multimap2 = runningOperations;
            synchronized (multimap2) {
                runningOperations.remove(target, (Object)monitoredOperation);
            }
            throw throwable;
        }
        Multimap<Pair<IWorkbenchPart, Object>, MonitoredOperation> multimap3 = runningOperations;
        synchronized (multimap3) {
            runningOperations.remove(target, (Object)monitoredOperation);
        }
        return (LayoutMapping)layoutMapping.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopEarlierOperations(Pair<IWorkbenchPart, Object> target, long time) {
        Multimap<Pair<IWorkbenchPart, Object>, MonitoredOperation> runningOperations;
        Multimap<Pair<IWorkbenchPart, Object>, MonitoredOperation> multimap = runningOperations = ElkServicePlugin.getInstance().getRunningOperations();
        synchronized (multimap) {
            for (MonitoredOperation operation : runningOperations.get(target)) {
                if (operation.getTimestamp() >= time) continue;
                operation.cancel();
            }
        }
    }

    public LayoutMapping layout(IWorkbenchPart workbenchPart, Object diagramPart, IElkProgressMonitor progressMonitor, Parameters params) {
        IElkProgressMonitor finalMonitor;
        if (workbenchPart == null && diagramPart == null) {
            throw new NullPointerException();
        }
        if (progressMonitor == null) {
            IPreferenceStore prefStore = ElkServicePlugin.getInstance().getPreferenceStore();
            finalMonitor = new BasicProgressMonitor(0).withLogging(prefStore.getBoolean(PREF_DEBUG_LOGGING)).withLogPersistence(prefStore.getBoolean(PREF_DEBUG_STORE)).withExecutionTimeMeasurement(prefStore.getBoolean(PREF_DEBUG_EXEC_TIME));
        } else {
            finalMonitor = progressMonitor;
        }
        finalMonitor.begin("Layout Diagram", 3.0f);
        IElkProgressMonitor submon1 = finalMonitor.subTask(1.0f);
        submon1.begin("Build layout graph", 1.0f);
        LayoutMapping mapping = this.connector.buildLayoutGraph(workbenchPart, diagramPart);
        if (mapping != null && mapping.getLayoutGraph() != null) {
            this.addDiagramConfig(params, mapping);
            submon1.done();
            this.layout(mapping, finalMonitor.subTask(1.0f), params);
            IElkProgressMonitor submon3 = finalMonitor.subTask(1.0f);
            submon3.begin("Apply layout to the diagram", 1.0f);
            this.connector.applyLayout(mapping, params.getGlobalSettings());
            submon3.done();
        } else {
            if (mapping == null) {
                mapping = new LayoutMapping(workbenchPart);
            }
            Status status = new Status(2, "com.modelengineers.MoRe_elk.core.service", "Unable to build the layout graph from the given selection.");
            mapping.setProperty(MAPPING_STATUS, status);
        }
        finalMonitor.done();
        return mapping;
    }

    protected void addDiagramConfig(Parameters params, LayoutMapping layoutMapping) {
        LayoutConfigurator diagramConfig = this.configManager.createConfigurator(layoutMapping);
        if (params.configurators.isEmpty()) {
            params.addLayoutRun(diagramConfig);
        } else {
            ListIterator<LayoutConfigurator> configIter = params.configurators.listIterator();
            while (configIter.hasNext()) {
                boolean isFirstConfig = !configIter.hasPrevious();
                IGraphElementVisitor setupConfig = (IGraphElementVisitor)configIter.next();
                if (!(setupConfig instanceof LayoutConfigurator)) continue;
                LayoutConfigurator layoutConfigurator = (LayoutConfigurator)setupConfig;
                if (params.overrideDiagramConfig) {
                    if (!isFirstConfig && !layoutConfigurator.isClearLayout()) continue;
                    LayoutConfigurator newConfig = configIter.hasNext() ? new LayoutConfigurator().overrideWith(diagramConfig) : diagramConfig;
                    configIter.set(newConfig.overrideWith(layoutConfigurator));
                    continue;
                }
                layoutConfigurator.overrideWith(diagramConfig);
            }
        }
    }

    protected void handleAncestors(LayoutMapping mapping, Parameters params) {
        ElkGraphElement graphElem;
        boolean layoutAncestors = params.getGlobalSettings().getProperty(CoreOptions.LAYOUT_ANCESTORS);
        if (layoutAncestors && (graphElem = (ElkGraphElement)mapping.getGraphMap().inverse().get(mapping.getParentElement())) instanceof ElkNode && ((ElkNode)graphElem).getParent() != null) {
            ElkNode parent;
            if (params.configurators.isEmpty()) {
                params.configurators.add(new LayoutConfigurator());
            }
            ElkNode node = (ElkNode)graphElem;
            do {
                parent = node.getParent();
                for (ElkNode child : parent.getChildren()) {
                    if (child == node) continue;
                    for (IGraphElementVisitor c : params.configurators) {
                        if (!(c instanceof LayoutConfigurator)) continue;
                        IPropertyHolder childConfig = ((LayoutConfigurator)c).configure(child);
                        childConfig.setProperty(CoreOptions.NO_LAYOUT, true);
                        childConfig.setProperty(CoreOptions.NODE_SIZE_CONSTRAINTS, SizeConstraint.fixed());
                        childConfig.setProperty(CoreOptions.PORT_CONSTRAINTS, PortConstraints.FIXED_POS);
                    }
                }
            } while ((node = parent).getParent() != null);
        }
    }

    public IStatus layout(LayoutMapping mapping, IElkProgressMonitor progressMonitor, Parameters params) {
        mapping.setProperty(MAPPING_CONNECTOR, this.connector);
        this.handleAncestors(mapping, params);
        LinkedList<IGraphElementVisitor> visitors = new LinkedList<IGraphElementVisitor>();
        visitors.add(this.algorithmResolver);
        if (params.getGlobalSettings().getProperty(CoreOptions.VALIDATE_OPTIONS).booleanValue()) {
            visitors.add((IGraphElementVisitor)this.layoutOptionValidatorProvider.get());
        }
        if (params.getGlobalSettings().getProperty(CoreOptions.VALIDATE_GRAPH).booleanValue()) {
            visitors.add((IGraphElementVisitor)this.graphValidatorProvider.get());
        }
        LayoutConnectorsService.getInstance().fireLayoutAboutToStart(mapping, progressMonitor);
        IStatus status = null;
        if (params.configurators.isEmpty()) {
            IGraphElementVisitor[] visitorsArray = visitors.toArray(new IGraphElementVisitor[visitors.size()]);
            status = this.layout(mapping, progressMonitor, visitorsArray);
        } else if (params.configurators.size() == 1) {
            visitors.addFirst((IGraphElementVisitor)params.configurators.get(0));
            IGraphElementVisitor[] visitorsArray = visitors.toArray(new IGraphElementVisitor[visitors.size()]);
            status = this.layout(mapping, progressMonitor, visitorsArray);
        } else {
            progressMonitor.begin("Diagram layout engine", params.configurators.size());
            ListIterator configIter = params.configurators.listIterator();
            while (configIter.hasNext()) {
                visitors.addFirst((IGraphElementVisitor)configIter.next());
                IGraphElementVisitor[] visitorsArray = visitors.toArray(new IGraphElementVisitor[visitors.size()]);
                status = this.layout(mapping, progressMonitor, visitorsArray);
                if (!status.isOK()) break;
                visitors.removeFirst();
                LayoutConfigurator addConfig = mapping.getLayoutGraph().getProperty(LayoutConfigurator.ADD_LAYOUT_CONFIG);
                if (addConfig == null) continue;
                ListIterator configIter2 = params.configurators.listIterator(configIter.nextIndex());
                while (configIter2.hasNext()) {
                    IGraphElementVisitor c = (IGraphElementVisitor)configIter2.next();
                    if (!(c instanceof LayoutConfigurator)) continue;
                    ((LayoutConfigurator)c).overrideWith(addConfig);
                }
            }
            progressMonitor.done();
            progressMonitor.logGraph(mapping.getLayoutGraph(), "Result");
        }
        mapping.setProperty(MAPPING_STATUS, status);
        LayoutConnectorsService.getInstance().fireLayoutDone(mapping, progressMonitor);
        return status;
    }

    public IStatus layout(LayoutMapping mapping, IElkProgressMonitor progressMonitor, IGraphElementVisitor ... visitors) {
        if (progressMonitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        boolean newTask = progressMonitor.begin("Diagram layout engine", 1.0f);
        try {
            if (visitors.length > 0) {
                ElkUtil.applyVisitorsWithValidation(mapping.getLayoutGraph(), visitors);
            }
            progressMonitor.logGraph(mapping.getLayoutGraph(), "input");
            this.graphLayoutEngine.layout(mapping.getLayoutGraph(), progressMonitor.subTask(1.0f));
            if (newTask) {
                progressMonitor.done();
                progressMonitor.logGraph(mapping.getLayoutGraph(), "result");
            }
            if (progressMonitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }
        catch (Throwable exception) {
            return new Status(4, "com.modelengineers.MoRe_elk.core.service", "Failed to perform diagram layout.", exception);
        }
    }

    protected void exportLayoutGraph(ElkNode graph) {
        URI exportUri = this.getExportURI(graph);
        if (exportUri != null) {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            Resource resource = resourceSet.createResource(exportUri);
            resource.getContents().add(graph);
            try {
                resource.save(Collections.emptyMap());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected URI getExportURI(ElkNode graph) {
        String path = String.valueOf(ElkUtil.debugFolderPath("diagram_layout_engine")) + Integer.toHexString(graph.hashCode()) + ".elkg";
        return URI.createFileURI(path);
    }

    public static final class Parameters {
        private List<IGraphElementVisitor> configurators = new LinkedList<IGraphElementVisitor>();
        private MapPropertyHolder globalSettings = new MapPropertyHolder();
        private boolean overrideDiagramConfig = true;

        public Parameters setOverrideDiagramConfig(boolean override) {
            this.overrideDiagramConfig = override;
            return this;
        }

        public IPropertyHolder getGlobalSettings() {
            return this.globalSettings;
        }

        public IGraphElementVisitor addLayoutRun(IGraphElementVisitor configurator) {
            this.configurators.add(configurator);
            if (configurator instanceof LayoutConfigurator) {
                ((LayoutConfigurator)configurator).addFilter(LayoutConfigurator.OPTION_TARGET_FILTER);
            }
            return configurator;
        }

        public LayoutConfigurator addLayoutRun() {
            return (LayoutConfigurator)this.addLayoutRun(new LayoutConfigurator());
        }
    }
}

