/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.core.options;

import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.Set;

public enum PortLabelPlacement {
    OUTSIDE,
    INSIDE,
    NEXT_TO_PORT_IF_POSSIBLE,
    ALWAYS_SAME_SIDE,
    ALWAYS_OTHER_SAME_SIDE,
    SPACE_EFFICIENT;


    public static EnumSet<PortLabelPlacement> fixed() {
        return EnumSet.noneOf(PortLabelPlacement.class);
    }

    public static EnumSet<PortLabelPlacement> inside() {
        return EnumSet.of(INSIDE);
    }

    public static EnumSet<PortLabelPlacement> outside() {
        return EnumSet.of(OUTSIDE);
    }

    public static boolean isFixed(Set<PortLabelPlacement> placement) {
        return !placement.contains((Object)INSIDE) && !placement.contains((Object)OUTSIDE);
    }

    public static boolean isValid(Set<PortLabelPlacement> placement) {
        EnumSet<PortLabelPlacement> validInsideOutside = EnumSet.of(INSIDE, OUTSIDE);
        if (Sets.intersection(validInsideOutside, placement).size() > 1) {
            return false;
        }
        EnumSet<PortLabelPlacement> validPosition = EnumSet.of(ALWAYS_SAME_SIDE, ALWAYS_OTHER_SAME_SIDE, SPACE_EFFICIENT);
        return Sets.intersection(validPosition, placement).size() <= 1;
    }
}

