/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.core.options;

import com.modelengineers.MoRe_elk.core.AbstractLayoutProvider;
import com.modelengineers.MoRe_elk.core.data.ILayoutMetaDataProvider;
import com.modelengineers.MoRe_elk.core.data.LayoutAlgorithmData;
import com.modelengineers.MoRe_elk.core.math.ElkPadding;
import com.modelengineers.MoRe_elk.core.math.KVector;
import com.modelengineers.MoRe_elk.core.math.KVectorChain;
import com.modelengineers.MoRe_elk.core.options.CoreOptions;
import com.modelengineers.MoRe_elk.core.options.SizeConstraint;
import com.modelengineers.MoRe_elk.core.util.FixedLayoutProvider;
import com.modelengineers.MoRe_elk.core.util.IFactory;
import com.modelengineers.MoRe_elk.graph.properties.IProperty;
import com.modelengineers.MoRe_elk.graph.properties.Property;
import java.util.EnumSet;

public class FixedLayouterOptions
implements ILayoutMetaDataProvider {
    public static final String ALGORITHM_ID = "com.modelengineers.MoRe_elk.fixed";
    private static final ElkPadding PADDING_DEFAULT = new ElkPadding(15.0);
    public static final IProperty<ElkPadding> PADDING = new Property<ElkPadding>(CoreOptions.PADDING, PADDING_DEFAULT);
    public static final IProperty<KVector> POSITION = CoreOptions.POSITION;
    public static final IProperty<KVectorChain> BEND_POINTS = CoreOptions.BEND_POINTS;
    public static final IProperty<EnumSet<SizeConstraint>> NODE_SIZE_CONSTRAINTS = CoreOptions.NODE_SIZE_CONSTRAINTS;
    public static final IProperty<KVector> NODE_SIZE_MINIMUM = CoreOptions.NODE_SIZE_MINIMUM;
    public static final IProperty<Boolean> NODE_SIZE_FIXED_GRAPH_SIZE = CoreOptions.NODE_SIZE_FIXED_GRAPH_SIZE;

    @Override
    public void apply(ILayoutMetaDataProvider.Registry registry) {
        registry.register(new LayoutAlgorithmData.Builder().id(ALGORITHM_ID).name("ELK Fixed").description("Keeps the current layout as it is, without any automatic modification. Optional coordinates can be given for nodes and edge bend points.").providerFactory(new FixedFactory()).melkBundleName("ELK").definingBundleId("com.modelengineers.MoRe_elk.core").create());
        registry.addOptionSupport(ALGORITHM_ID, "com.modelengineers.MoRe_elk.padding", PADDING_DEFAULT);
        registry.addOptionSupport(ALGORITHM_ID, "com.modelengineers.MoRe_elk.position", POSITION.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "com.modelengineers.MoRe_elk.bendPoints", BEND_POINTS.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "com.modelengineers.MoRe_elk.nodeSize.constraints", NODE_SIZE_CONSTRAINTS.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "com.modelengineers.MoRe_elk.nodeSize.minimum", NODE_SIZE_MINIMUM.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "com.modelengineers.MoRe_elk.nodeSize.fixedGraphSize", NODE_SIZE_FIXED_GRAPH_SIZE.getDefault());
    }

    public static class FixedFactory
    implements IFactory<AbstractLayoutProvider> {
        @Override
        public AbstractLayoutProvider create() {
            FixedLayoutProvider provider = new FixedLayoutProvider();
            provider.initialize("");
            return provider;
        }

        @Override
        public void destroy(AbstractLayoutProvider obj) {
            obj.dispose();
        }
    }
}

