/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.core.options;

import com.modelengineers.MoRe_elk.core.AbstractLayoutProvider;
import com.modelengineers.MoRe_elk.core.data.ILayoutMetaDataProvider;
import com.modelengineers.MoRe_elk.core.data.LayoutAlgorithmData;
import com.modelengineers.MoRe_elk.core.math.ElkPadding;
import com.modelengineers.MoRe_elk.core.math.KVector;
import com.modelengineers.MoRe_elk.core.options.ContentAlignment;
import com.modelengineers.MoRe_elk.core.options.CoreOptions;
import com.modelengineers.MoRe_elk.core.options.SizeConstraint;
import com.modelengineers.MoRe_elk.core.options.SizeOptions;
import com.modelengineers.MoRe_elk.core.util.BoxLayoutProvider;
import com.modelengineers.MoRe_elk.core.util.IFactory;
import com.modelengineers.MoRe_elk.graph.properties.IProperty;
import com.modelengineers.MoRe_elk.graph.properties.Property;
import java.util.EnumSet;

public class BoxLayouterOptions
implements ILayoutMetaDataProvider {
    public static final String ALGORITHM_ID = "com.modelengineers.MoRe_elk.box";
    private static final ElkPadding PADDING_DEFAULT = new ElkPadding(15.0);
    public static final IProperty<ElkPadding> PADDING = new Property<ElkPadding>(CoreOptions.PADDING, PADDING_DEFAULT);
    private static final double SPACING_NODE_NODE_DEFAULT = 15.0;
    public static final IProperty<Double> SPACING_NODE_NODE = new Property<Double>(CoreOptions.SPACING_NODE_NODE, Double.valueOf(15.0));
    private static final int PRIORITY_DEFAULT = 0;
    public static final IProperty<Integer> PRIORITY = new Property<Integer>(CoreOptions.PRIORITY, Integer.valueOf(0));
    public static final IProperty<Boolean> EXPAND_NODES = CoreOptions.EXPAND_NODES;
    public static final IProperty<EnumSet<SizeConstraint>> NODE_SIZE_CONSTRAINTS = CoreOptions.NODE_SIZE_CONSTRAINTS;
    public static final IProperty<EnumSet<SizeOptions>> NODE_SIZE_OPTIONS = CoreOptions.NODE_SIZE_OPTIONS;
    private static final double ASPECT_RATIO_DEFAULT = (double)1.3f;
    public static final IProperty<Double> ASPECT_RATIO = new Property<Double>(CoreOptions.ASPECT_RATIO, Double.valueOf(1.3f));
    public static final IProperty<Boolean> INTERACTIVE = CoreOptions.INTERACTIVE;
    public static final IProperty<KVector> NODE_SIZE_MINIMUM = CoreOptions.NODE_SIZE_MINIMUM;
    public static final IProperty<BoxLayoutProvider.PackingMode> BOX_PACKING_MODE = CoreOptions.BOX_PACKING_MODE;
    public static final IProperty<EnumSet<ContentAlignment>> CONTENT_ALIGNMENT = CoreOptions.CONTENT_ALIGNMENT;

    @Override
    public void apply(ILayoutMetaDataProvider.Registry registry) {
        registry.register(new LayoutAlgorithmData.Builder().id(ALGORITHM_ID).name("ELK Box").description("Algorithm for packing of unconnected boxes, i.e. graphs without edges.").providerFactory(new BoxFactory()).melkBundleName("ELK").definingBundleId("com.modelengineers.MoRe_elk.core").imagePath("images/box_layout.png").create());
        registry.addOptionSupport(ALGORITHM_ID, "com.modelengineers.MoRe_elk.padding", PADDING_DEFAULT);
        registry.addOptionSupport(ALGORITHM_ID, "com.modelengineers.MoRe_elk.spacing.nodeNode", 15.0);
        registry.addOptionSupport(ALGORITHM_ID, "com.modelengineers.MoRe_elk.priority", 0);
        registry.addOptionSupport(ALGORITHM_ID, "com.modelengineers.MoRe_elk.expandNodes", EXPAND_NODES.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "com.modelengineers.MoRe_elk.nodeSize.constraints", NODE_SIZE_CONSTRAINTS.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "com.modelengineers.MoRe_elk.nodeSize.options", NODE_SIZE_OPTIONS.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "com.modelengineers.MoRe_elk.aspectRatio", 1.3f);
        registry.addOptionSupport(ALGORITHM_ID, "com.modelengineers.MoRe_elk.interactive", INTERACTIVE.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "com.modelengineers.MoRe_elk.nodeSize.minimum", NODE_SIZE_MINIMUM.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "com.modelengineers.MoRe_elk.box.packingMode", (Object)BOX_PACKING_MODE.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "com.modelengineers.MoRe_elk.contentAlignment", CONTENT_ALIGNMENT.getDefault());
    }

    public static class BoxFactory
    implements IFactory<AbstractLayoutProvider> {
        @Override
        public AbstractLayoutProvider create() {
            BoxLayoutProvider provider = new BoxLayoutProvider();
            provider.initialize("");
            return provider;
        }

        @Override
        public void destroy(AbstractLayoutProvider obj) {
            obj.dispose();
        }
    }
}

