/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.core.meta.validation;

import com.modelengineers.MoRe_elk.core.meta.metaData.MdAlgorithm;
import com.modelengineers.MoRe_elk.core.meta.metaData.MdBundle;
import com.modelengineers.MoRe_elk.core.meta.metaData.MdBundleMember;
import com.modelengineers.MoRe_elk.core.meta.metaData.MdCategory;
import com.modelengineers.MoRe_elk.core.meta.metaData.MdGroup;
import com.modelengineers.MoRe_elk.core.meta.metaData.MdOption;
import com.modelengineers.MoRe_elk.core.meta.metaData.MetaDataPackage;
import com.modelengineers.MoRe_elk.core.meta.validation.AbstractMetaDataValidator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;

public class MetaDataValidator
extends AbstractMetaDataValidator {
    @Check
    public void checkDuplicateMemberId(MdBundle bundle) {
        this.checkDuplicateIds(bundle.getMembers());
    }

    private void checkDuplicateIds(Iterable<? extends MdBundleMember> elements) {
        HashMap algorithmIds = CollectionLiterals.newHashMap();
        HashMap categoryIds = CollectionLiterals.newHashMap();
        HashMap propertyIds = CollectionLiterals.newHashMap();
        HashMap groupIds = CollectionLiterals.newHashMap();
        for (MdBundleMember mdBundleMember : elements) {
            boolean _matched = false;
            if (mdBundleMember instanceof MdAlgorithm) {
                _matched = true;
                this.checkExistsAndRemember(algorithmIds, (MdAlgorithm)mdBundleMember);
            }
            if (!_matched && mdBundleMember instanceof MdCategory) {
                _matched = true;
                this.checkExistsAndRemember(categoryIds, (MdCategory)mdBundleMember);
            }
            if (!_matched && mdBundleMember instanceof MdGroup) {
                _matched = true;
                this.checkExistsAndRemember(groupIds, (MdGroup)mdBundleMember);
                this.checkDuplicateIds(((MdGroup)mdBundleMember).getChildren());
            }
            if (_matched || !(mdBundleMember instanceof MdOption)) continue;
            _matched = true;
            this.checkExistsAndRemember(propertyIds, (MdOption)mdBundleMember);
        }
    }

    private <T extends MdBundleMember> void checkExistsAndRemember(Map<String, T> map, T element) {
        boolean _containsKey = map.containsKey(element.getName());
        if (_containsKey) {
            MdBundleMember otherMember = (MdBundleMember)map.get(element.getName());
            if (otherMember != null) {
                this.duplicateId(otherMember);
                map.put(element.getName(), null);
            }
            this.duplicateId(element);
        } else {
            map.put(element.getName(), element);
        }
    }

    private void duplicateId(MdBundleMember member) {
        String _name = member.getName();
        String _plus = "The id '" + _name;
        String _plus_1 = String.valueOf(_plus) + "' is already used.";
        this.error(_plus_1, member, MetaDataPackage.Literals.MD_BUNDLE_MEMBER__NAME);
    }
}

