/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.core.math;

import com.modelengineers.MoRe_elk.core.math.KVector;
import java.util.Objects;

public class ElkRectangle {
    public double x;
    public double y;
    public double width;
    public double height;

    public ElkRectangle() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public ElkRectangle(double x, double y, double w, double h) {
        this.setRect(x, y, w, h);
    }

    public ElkRectangle(ElkRectangle rect) {
        this.x = rect.x;
        this.y = rect.y;
        this.width = rect.width;
        this.height = rect.height;
    }

    public void setRect(double nx, double ny, double nw, double nh) {
        assert (nw >= 0.0);
        assert (nh >= 0.0);
        this.x = nx;
        this.y = ny;
        this.width = nw;
        this.height = nh;
    }

    public KVector getPosition() {
        return new KVector(this.x, this.y);
    }

    public KVector getTopLeft() {
        return this.getPosition();
    }

    public KVector getTopRight() {
        return new KVector(this.x + this.width, this.y);
    }

    public KVector getBottomLeft() {
        return new KVector(this.x, this.y + this.height);
    }

    public KVector getBottomRight() {
        return new KVector(this.x + this.width, this.y + this.height);
    }

    public KVector getCenter() {
        return new KVector(this.x + this.width / 2.0, this.y + this.height / 2.0);
    }

    public void union(ElkRectangle other) {
        this.xUnion(other);
        this.yUnion(other);
    }

    public void xUnion(ElkRectangle other) {
        double[] union = ElkRectangle.union(this.x, other.x, this.width, other.width);
        this.x = union[0];
        this.width = union[1];
    }

    public void yUnion(ElkRectangle other) {
        double[] union = ElkRectangle.union(this.y, other.y, this.height, other.height);
        this.y = union[0];
        this.height = union[1];
    }

    private static double[] union(double a, double b, double la, double lb) {
        double[] ret = new double[2];
        double min = Math.min(a, b);
        double max = Math.max(a + la, b + lb);
        ret[0] = min;
        ret[1] = max - min;
        return ret;
    }

    public void move(KVector offset) {
        this.x += offset.x;
        this.y += offset.y;
    }

    public String toString() {
        return "Rect[x=" + this.x + ",y=" + this.y + ",w=" + this.width + ",h=" + this.height + "]";
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ElkRectangle)) {
            return false;
        }
        ElkRectangle other = (ElkRectangle)obj;
        return Objects.equals(this.x, other.x) && Objects.equals(this.y, other.y) && Objects.equals(this.width, other.width) && Objects.equals(this.height, other.height);
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.width, this.height);
    }

    public double getMaxX() {
        return this.x + this.width;
    }

    public double getMaxY() {
        return this.y + this.height;
    }

    public boolean intersects(ElkRectangle rect) {
        double r1x1 = this.x;
        double r1y1 = this.y;
        double r1x2 = this.x + this.width;
        double r1y2 = this.y + this.height;
        double r2x1 = rect.x;
        double r2y1 = rect.y;
        double r2x2 = rect.x + rect.width;
        double r2y2 = rect.y + rect.height;
        return r1x1 < r2x2 && r1x2 > r2x1 && r1y2 > r2y1 && r1y1 < r2y2;
    }
}

