/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.core.debug.views.log;

import com.modelengineers.MoRe_elk.core.debug.ElkDebugPlugin;
import com.modelengineers.MoRe_elk.core.debug.model.ExecutionInfo;
import java.time.format.DateTimeFormatter;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public class LogLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private static final String LOG_IMAGE_PATH = "/icons/log.png";
    private static final String NO_LOG_IMAGE_PATH = "/icons/no_log.png";
    private Image logImage = ElkDebugPlugin.imageDescriptorFromPlugin((String)"com.modelengineers.MoRe_elk.core.debug", (String)"/icons/log.png").createImage();
    private Image noLogImage = ElkDebugPlugin.imageDescriptorFromPlugin((String)"com.modelengineers.MoRe_elk.core.debug", (String)"/icons/no_log.png").createImage();

    public void dispose() {
        super.dispose();
        if (this.noLogImage != null) {
            this.noLogImage.dispose();
            this.noLogImage = null;
        }
        if (this.logImage != null) {
            this.logImage.dispose();
            this.logImage = null;
        }
    }

    public StyledString getStyledText(Object element) {
        if (element instanceof ExecutionInfo) {
            ExecutionInfo execution = (ExecutionInfo)element;
            StyledString text = new StyledString(execution.getName());
            if (execution.getParent() == null) {
                text.append(" (" + DateTimeFormatter.ISO_INSTANT.format(execution.getCreationTime()) + ")", StyledString.COUNTER_STYLER);
            }
            return text;
        }
        return null;
    }

    public Image getImage(Object element) {
        if (element instanceof ExecutionInfo) {
            return ((ExecutionInfo)element).hasLogMessages() ? this.logImage : this.noLogImage;
        }
        return null;
    }
}

