/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.core.debug.grandom.generators;

import com.modelengineers.MoRe_elk.core.options.PortConstraints;
import com.modelengineers.MoRe_elk.graph.properties.IProperty;
import com.modelengineers.MoRe_elk.graph.properties.MapPropertyHolder;
import com.modelengineers.MoRe_elk.graph.properties.Property;
import java.util.Random;

public class GeneratorOptions
extends MapPropertyHolder {
    private static final long serialVersionUID = -917483559995737504L;
    public static final IProperty<Integer> NUMBER_OF_GRAPHS = new Property<Integer>("randomWizard.numberOfGraphs", Integer.valueOf(1));
    public static final IProperty<String> FILE_NAME = new Property<String>("randomWizard.filename", "random.kgt");
    public static final IProperty<FileFormat> FILE_FORMAT = new Property<FileFormat>("randomWizard.fileFormat", FileFormat.XTEXT);
    public static final IProperty<GraphType> GRAPH_TYPE = new Property<GraphType>("basic.graphType", GraphType.CUSTOM);
    public static final IProperty<RandVal> NUMBER_OF_NODES = new Property<RandVal>("basic.numNodes", RandVal.exact(10.0));
    public static final IProperty<EdgeDetermination> EDGE_DETERMINATION = new Property<EdgeDetermination>("basic.edgeDetermination", EdgeDetermination.ABSOLUTE);
    public static final IProperty<RandVal> EDGES_ABSOLUTE = new Property<RandVal>("basic.numberOfEdges", RandVal.exact(20.0));
    public static final IProperty<RandVal> RELATIVE_EDGES = new Property<RandVal>("basic.relEdges", RandVal.allNil());
    public static final IProperty<RandVal> DENSITY = new Property<RandVal>("basic.density", RandVal.allNil());
    public static final IProperty<Boolean> ENABLE_HIERARCHY = new Property<Boolean>("basic.enableHierarchy", Boolean.valueOf(false));
    public static final IProperty<Float> HIERARCHY_CHANCE = new Property<Float>("basic.hierarchyChance", Float.valueOf(0.05f), Float.valueOf(0.0f), Float.valueOf(1.0f));
    public static final IProperty<RandVal> MAX_HIERARCHY_LEVEL = new Property<RandVal>("basic.maxHierarchyLevel", RandVal.exact(3.0));
    public static final IProperty<Float> HIERARCHY_NODES_FACTOR = new Property<Float>("basic.hierarchyNodesFactor", Float.valueOf(0.5f), Float.valueOf(0.0f));
    public static final IProperty<Boolean> ENABLE_PORTS = new Property<Boolean>("basic.ports", Boolean.valueOf(false));
    public static final IProperty<RandVal> USE_EXISTING_PORTS_CHANCE = new Property<RandVal>("basic.useExistingPortsChance", RandVal.exact(0.3));
    public static final IProperty<Boolean> CROSS_HIERARCHY_EDGES = new Property<Boolean>("basic.crossHierarchyEdges", Boolean.valueOf(false));
    public static final IProperty<Boolean> TIME_BASED_RANDOMIZATION = new Property<Boolean>("basic.timeBasedRandomization", Boolean.valueOf(true));
    public static final IProperty<Integer> RANDOMIZATION_SEED = new Property<Integer>("basic.randomizationSeed", Integer.valueOf(0));
    public static final IProperty<Boolean> SET_NODE_SIZE = new Property<Boolean>("basic.setNodeSize", Boolean.valueOf(true));
    public static final IProperty<RandVal> NODE_WIDTH = new Property<RandVal>("basic.minNodeWidth", RandVal.exact(30.0));
    public static final IProperty<RandVal> NODE_HEIGHT = new Property<RandVal>("basic.minNodeHeight", RandVal.exact(30.0));
    public static final IProperty<Boolean> CREATE_NODE_LABELS = new Property<Boolean>("basic.createNodeLabels", Boolean.valueOf(false));
    public static final IProperty<Boolean> SET_PORT_SIZE = new Property<Boolean>("basic.setPortSize", Boolean.valueOf(true));
    public static final IProperty<RandVal> PORT_WIDTH = new Property<RandVal>("basic.portWidth", RandVal.exact(4.0));
    public static final IProperty<RandVal> PORT_HEIGHT = new Property<RandVal>("basic.portHeight", RandVal.exact(4.0));
    public static final IProperty<Boolean> CREATE_PORT_LABELS = new Property<Boolean>("basic.createPortLabels", Boolean.valueOf(false));
    public static final IProperty<PortConstraints> PORT_CONSTRAINTS = new Property<PortConstraints>("layout.portConstraints", PortConstraints.UNDEFINED);
    public static final IProperty<Integer> INCOMING_NORTH_SIDE = new Property<Integer>("layout.incomingNorthSide", Integer.valueOf(10));
    public static final IProperty<Integer> INCOMING_EAST_SIDE = new Property<Integer>("layout.incomingEastSide", Integer.valueOf(5));
    public static final IProperty<Integer> INCOMING_SOUTH_SIDE = new Property<Integer>("layout.incomingSouthSide", Integer.valueOf(10));
    public static final IProperty<Integer> INCOMING_WEST_SIDE = new Property<Integer>("layout.incomingWestSide", Integer.valueOf(75));
    public static final IProperty<Integer> OUTGOING_NORTH_SIDE = new Property<Integer>("layout.outgoingNorthSide", Integer.valueOf(10));
    public static final IProperty<Integer> OUTGOING_EAST_SIDE = new Property<Integer>("layout.outgoingEastSide", Integer.valueOf(75));
    public static final IProperty<Integer> OUTGOING_SOUTH_SIDE = new Property<Integer>("layout.outgoingSouthSide", Integer.valueOf(10));
    public static final IProperty<Integer> OUTGOING_WEST_SIDE = new Property<Integer>("layout.outgoingWestSide", Integer.valueOf(5));
    public static final IProperty<RandVal> OUTGOING_EDGES = new Property<RandVal>("basic.minOutgoingEdges", RandVal.allNil());
    public static final IProperty<Boolean> SELF_LOOPS = new Property<Boolean>("basic.selfLoops", Boolean.valueOf(false));
    public static final IProperty<Boolean> MULTI_EDGES = new Property<Boolean>("basic.multiEdges", Boolean.valueOf(true));
    public static final IProperty<Boolean> CYCLES = new Property<Boolean>("basic.cycles", Boolean.valueOf(true));
    public static final IProperty<Boolean> ISOLATED_NODES = new Property<Boolean>("basic.isolatedNodes", Boolean.valueOf(true));
    public static final Property<Boolean> EDGE_LABELS = new Property<Boolean>("basic.edgeLabels", Boolean.valueOf(false));
    public static final IProperty<Integer> MAX_WIDTH = new Property<Integer>("basic.maxWidth", Integer.valueOf(0));
    public static final IProperty<Integer> MAX_DEGREE = new Property<Integer>("basic.maxDegree", Integer.valueOf(0));
    public static final IProperty<Boolean> PLANAR = new Property<Boolean>("basic.planar", Boolean.valueOf(false));
    public static final IProperty<RandVal> PARTITION_FRAC = new Property<RandVal>("basic.minPartitionFraction", RandVal.exact(0.4f));
    public static final IProperty<Boolean> SMALL_HIERARCHY = new Property<Boolean>("basic.SMALL_HIERARCHY", Boolean.valueOf(false));
    public static final IProperty<RandVal> NUMBER_HIERARCHICAL_NODES = new Property<RandVal>("basic.HIERARCH_NODE", RandVal.allNil());
    public static final IProperty<RandVal> CROSS_HIER = new Property<RandVal>("basic.CROSS_HIER", RandVal.allNil());
    public static final IProperty<RandVal> EXACT_RELATIVE_HIER = new Property<Object>("basic.EXACT_RELATIVE_HIER", null);

    public static enum EdgeDetermination {
        ABSOLUTE,
        OUTGOING,
        RELATIVE,
        DENSITY;

    }

    public static enum FileFormat {
        XMI,
        XTEXT;

    }

    public static enum GraphType {
        CUSTOM,
        TREE,
        BICONNECTED,
        TRICONNECTED,
        ACYCLIC_NO_TRANSITIVE_EDGES,
        BIPARTITE;

    }

    public static class RandVal {
        private double min;
        private double max;
        private double mean;
        private double stddv;
        private double exact;
        private boolean useMinMax;
        private boolean useExact;

        private RandVal(double min, double max, double mean, double stddv, double exact, boolean useMinMax, boolean useExact) {
            this.min = min;
            this.max = max;
            this.mean = mean;
            this.stddv = stddv;
            this.exact = exact;
            this.useMinMax = useMinMax;
            this.useExact = useExact;
        }

        public static RandVal allNil() {
            return new RandVal(0.0, 0.0, 0.0, 0.0, 0.0, false, false);
        }

        public static RandVal minMax(double min, double max) {
            return new RandVal(min, max, 0.0, 0.0, 0.0, true, false);
        }

        public static RandVal exact(double exact) {
            return new RandVal(0.0, 0.0, 0.0, 0.0, exact, false, true);
        }

        public static RandVal gaussian(double mean, double stddv) {
            return new RandVal(0.0, 0.0, mean, stddv, 0.0, false, false);
        }

        public double val(Random r) {
            double result = 0.0;
            if (this.useExact) {
                result = this.exact;
            } else if (this.useMinMax) {
                assert (this.max >= this.min);
                result = r.nextDouble() * (this.max - this.min) + this.min;
            } else {
                result = r.nextGaussian() * this.stddv + this.mean;
            }
            return result < 0.0 ? 0.0 : result;
        }

        public int intVal(Random r) {
            return (int)Math.round(this.val(r));
        }

        public int defaultInt() {
            return (int)Math.round(this.exact);
        }

        public float floatVal(Random r) {
            return (float)this.val(r);
        }

        public void setMean(double d) {
            this.mean = d;
        }

        public void setStddv(double d) {
            this.stddv = d;
        }

        public void setMin(int m) {
            this.min = m;
        }

        public void setMax(int m) {
            this.max = m;
        }

        public double min() {
            return this.min;
        }

        public double max() {
            return this.max;
        }

        public double defaultVal() {
            return this.exact;
        }
    }
}

