/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.core.debug.grandom.gRandom;

import com.modelengineers.MoRe_emf.common.util.Enumerator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum Form implements Enumerator
{
    TREES(0, "trees", "trees"),
    CUSTOM(1, "custom", "graphs"),
    BIPARTITE(2, "bipartite", "bipartite graphs"),
    BICONNECTED(3, "biconnected", "biconnected graphs"),
    TRICONNECTED(4, "triconnected", "triconnected graphs"),
    ACYCLIC(5, "acyclic", "acyclic graphs");

    public static final int TREES_VALUE = 0;
    public static final int CUSTOM_VALUE = 1;
    public static final int BIPARTITE_VALUE = 2;
    public static final int BICONNECTED_VALUE = 3;
    public static final int TRICONNECTED_VALUE = 4;
    public static final int ACYCLIC_VALUE = 5;
    private static final Form[] VALUES_ARRAY;
    public static final List<Form> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Form[]{TREES, CUSTOM, BIPARTITE, BICONNECTED, TRICONNECTED, ACYCLIC};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Form get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Form result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Form getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Form result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Form get(int value) {
        switch (value) {
            case 0: {
                return TREES;
            }
            case 1: {
                return CUSTOM;
            }
            case 2: {
                return BIPARTITE;
            }
            case 3: {
                return BICONNECTED;
            }
            case 4: {
                return TRICONNECTED;
            }
            case 5: {
                return ACYCLIC;
            }
        }
        return null;
    }

    private Form(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

