/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.core.comments;

import com.google.common.collect.Maps;
import com.modelengineers.MoRe_elk.core.comments.IDataProvider;
import java.awt.geom.Rectangle2D;
import java.util.Map;

public interface IBoundsProvider<C, T> {
    public Rectangle2D.Double boundsForComment(C var1);

    public Rectangle2D.Double boundsForTarget(T var1);

    default public void preprocess(IDataProvider<C, T> dataProvider, boolean includeHierarchy) {
    }

    default public void cleanup() {
    }

    default public IBoundsProvider<C, T> cached() {
        return new IBoundsProvider<C, T>(){
            private final Map<C, Rectangle2D.Double> commentBoundsCache = Maps.newHashMap();
            private final Map<T, Rectangle2D.Double> targetBoundsCache = Maps.newHashMap();

            @Override
            public Rectangle2D.Double boundsForComment(C comment) {
                if (this.commentBoundsCache.containsKey(comment)) {
                    return this.commentBoundsCache.get(comment);
                }
                Rectangle2D.Double bounds = IBoundsProvider.this.boundsForComment(comment);
                this.commentBoundsCache.put(comment, bounds);
                return bounds;
            }

            @Override
            public Rectangle2D.Double boundsForTarget(T target) {
                if (this.targetBoundsCache.containsKey(target)) {
                    return this.targetBoundsCache.get(target);
                }
                Rectangle2D.Double bounds = IBoundsProvider.this.boundsForTarget(target);
                this.targetBoundsCache.put(target, bounds);
                return bounds;
            }

            @Override
            public void preprocess(IDataProvider<C, T> dataProvider, boolean includeHierarchy) {
                IBoundsProvider.this.preprocess(dataProvider, includeHierarchy);
            }

            @Override
            public void cleanup() {
                this.commentBoundsCache.clear();
                this.targetBoundsCache.clear();
                IBoundsProvider.this.cleanup();
            }
        };
    }
}

