/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.core.alg;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.modelengineers.MoRe_elk.core.alg.EnumBasedFactoryComparator;
import com.modelengineers.MoRe_elk.core.alg.ILayoutPhase;
import com.modelengineers.MoRe_elk.core.alg.ILayoutPhaseFactory;
import com.modelengineers.MoRe_elk.core.alg.ILayoutProcessor;
import com.modelengineers.MoRe_elk.core.alg.ILayoutProcessorFactory;
import com.modelengineers.MoRe_elk.core.alg.LayoutProcessorConfiguration;
import com.modelengineers.MoRe_elk.core.util.AbstractRandomListAccessor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class AlgorithmAssembler<P extends Enum<P>, G>
extends AbstractRandomListAccessor<ILayoutPhaseFactory<P, G>> {
    private boolean enableCaching = true;
    private boolean failOnMissingPhase = true;
    private Comparator<ILayoutProcessorFactory<G>> processorComparator = new EnumBasedFactoryComparator();
    private final Class<P> phasesEnumClass;
    private final int numberOfPhases;
    private final Set<P> configuredPhases;
    private final LayoutProcessorConfiguration<P, G> additionalProcessors;
    private final Map<ILayoutProcessorFactory<G>, ILayoutProcessor<G>> cache;

    public static <P extends Enum<P>, G> AlgorithmAssembler<P, G> create(Class<P> phaseEnum) {
        return new AlgorithmAssembler<P, G>(phaseEnum);
    }

    private AlgorithmAssembler(Class<P> phaseEnum) {
        this.phasesEnumClass = phaseEnum;
        this.numberOfPhases = ((Enum[])phaseEnum.getEnumConstants()).length;
        if (this.numberOfPhases == 0) {
            throw new IllegalArgumentException("There must be at least one phase in the phase enumeration.");
        }
        this.configuredPhases = EnumSet.noneOf(this.phasesEnumClass);
        this.additionalProcessors = LayoutProcessorConfiguration.create();
        this.cache = Maps.newHashMap();
    }

    public AlgorithmAssembler<P, G> withCaching(boolean enabled) {
        this.enableCaching = enabled;
        return this;
    }

    public AlgorithmAssembler<P, G> withFailOnMissingPhase(boolean fail) {
        this.failOnMissingPhase = fail;
        return this;
    }

    public AlgorithmAssembler<P, G> withProcessorComparator(Comparator<ILayoutProcessorFactory<G>> comparator) {
        this.processorComparator = comparator;
        return this;
    }

    public AlgorithmAssembler<P, G> clearCache() {
        this.cache.clear();
        return this;
    }

    public AlgorithmAssembler<P, G> reset() {
        this.clearList();
        this.configuredPhases.clear();
        this.additionalProcessors.clear();
        return this;
    }

    public AlgorithmAssembler<P, G> setPhase(P phase, ILayoutPhaseFactory<P, G> phaseFactory) {
        this.setListItem(((Enum)phase).ordinal(), phaseFactory);
        this.configuredPhases.add(phase);
        return this;
    }

    public AlgorithmAssembler<P, G> addProcessorConfiguration(LayoutProcessorConfiguration<P, G> config) {
        this.additionalProcessors.addAll(config);
        return this;
    }

    public List<ILayoutProcessor<G>> build(G graph) {
        if (this.failOnMissingPhase && this.configuredPhases.size() < this.numberOfPhases) {
            throw new IllegalStateException("Expected " + this.numberOfPhases + " phases to be configured; " + "only found " + this.configuredPhases.size());
        }
        Enum[] phaseEnumConstants = (Enum[])this.phasesEnumClass.getEnumConstants();
        ArrayList phaseImplementations = Lists.newArrayListWithCapacity((int)this.numberOfPhases);
        Enum[] enumArray = phaseEnumConstants;
        int n = phaseEnumConstants.length;
        int n2 = 0;
        while (n2 < n) {
            Enum phase2 = enumArray[n2];
            ILayoutPhaseFactory phaseFactory = (ILayoutPhaseFactory)this.getListItem(phase2.ordinal());
            if (phaseFactory != null) {
                phaseImplementations.add(this.retrievePhase(phaseFactory));
            } else {
                phaseImplementations.add(null);
            }
            ++n2;
        }
        LayoutProcessorConfiguration processorConfiguration = LayoutProcessorConfiguration.create();
        phaseImplementations.stream().filter(phase -> phase != null).map(phase -> phase.getLayoutProcessorConfiguration(graph)).filter(config -> config != null).forEach(config -> {
            LayoutProcessorConfiguration layoutProcessorConfiguration2 = processorConfiguration.addAll((LayoutProcessorConfiguration)config);
        });
        processorConfiguration.addAll(this.additionalProcessors);
        ArrayList algorithm = Lists.newArrayList();
        Enum[] enumArray2 = phaseEnumConstants;
        int n3 = phaseEnumConstants.length;
        int n4 = 0;
        while (n4 < n3) {
            Enum phase3 = enumArray2[n4];
            algorithm.addAll(this.retrieveProcessors(processorConfiguration.processorsBefore(phase3)));
            ILayoutPhase phaseImplementation = (ILayoutPhase)phaseImplementations.get(phase3.ordinal());
            if (phaseImplementation != null) {
                algorithm.add(phaseImplementation);
            }
            ++n4;
        }
        algorithm.addAll(this.retrieveProcessors(processorConfiguration.processorsAfter(phaseEnumConstants[phaseEnumConstants.length - 1])));
        return algorithm;
    }

    @Override
    protected ILayoutPhaseFactory<P, G> provideDefault() {
        return null;
    }

    private List<ILayoutProcessor<G>> retrieveProcessors(Set<ILayoutProcessorFactory<G>> factories) {
        ArrayList processors = Lists.newArrayListWithCapacity((int)factories.size());
        factories.stream().sorted(this.processorComparator).forEach(factory -> {
            boolean bl = processors.add(this.retrieveProcessor((ILayoutProcessorFactory<G>)factory));
        });
        return processors;
    }

    private ILayoutPhase<P, G> retrievePhase(ILayoutPhaseFactory<P, G> factory) {
        return (ILayoutPhase)this.retrieveProcessor(factory);
    }

    private ILayoutProcessor<G> retrieveProcessor(ILayoutProcessorFactory<G> factory) {
        if (this.enableCaching) {
            if (this.cache.containsKey(factory)) {
                return this.cache.get(factory);
            }
            ILayoutProcessor<G> processor = factory.create();
            this.cache.put(factory, processor);
            return processor;
        }
        return factory.create();
    }
}

