/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.core;

import com.google.common.collect.Lists;
import com.modelengineers.MoRe_elk.core.AbstractLayoutProvider;
import com.modelengineers.MoRe_elk.core.IGraphLayoutEngine;
import com.modelengineers.MoRe_elk.core.UnsupportedConfigurationException;
import com.modelengineers.MoRe_elk.core.data.DeprecatedLayoutOptionReplacer;
import com.modelengineers.MoRe_elk.core.data.LayoutAlgorithmData;
import com.modelengineers.MoRe_elk.core.data.LayoutAlgorithmResolver;
import com.modelengineers.MoRe_elk.core.options.CoreOptions;
import com.modelengineers.MoRe_elk.core.options.HierarchyHandling;
import com.modelengineers.MoRe_elk.core.testing.TestController;
import com.modelengineers.MoRe_elk.core.util.ElkUtil;
import com.modelengineers.MoRe_elk.core.util.IElkProgressMonitor;
import com.modelengineers.MoRe_elk.graph.ElkBendPoint;
import com.modelengineers.MoRe_elk.graph.ElkConnectableShape;
import com.modelengineers.MoRe_elk.graph.ElkEdge;
import com.modelengineers.MoRe_elk.graph.ElkEdgeSection;
import com.modelengineers.MoRe_elk.graph.ElkNode;
import com.modelengineers.MoRe_elk.graph.properties.GraphFeature;
import com.modelengineers.MoRe_elk.graph.util.ElkGraphUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class RecursiveGraphLayoutEngine
implements IGraphLayoutEngine {
    @Override
    public void layout(ElkNode layoutGraph, IElkProgressMonitor progressMonitor) {
        this.layout(layoutGraph, null, progressMonitor);
    }

    public void layout(ElkNode layoutGraph, TestController testController, IElkProgressMonitor progressMonitor) {
        int nodeCount = this.countNodesRecursively(layoutGraph, true);
        progressMonitor.begin("Recursive Graph Layout", nodeCount);
        ElkUtil.applyVisitors(layoutGraph, new DeprecatedLayoutOptionReplacer());
        if (!layoutGraph.hasProperty(CoreOptions.RESOLVED_ALGORITHM)) {
            ElkUtil.applyVisitors(layoutGraph, new LayoutAlgorithmResolver());
        }
        this.layoutRecursively(layoutGraph, testController, progressMonitor);
        progressMonitor.done();
    }

    protected List<ElkEdge> layoutRecursively(ElkNode layoutNode, TestController testController, IElkProgressMonitor progressMonitor) {
        boolean hasInsideSelfLoops;
        if (progressMonitor.isCanceled()) {
            return Collections.emptyList();
        }
        if (layoutNode.getProperty(CoreOptions.NO_LAYOUT).booleanValue()) {
            return Collections.emptyList();
        }
        boolean hasChildren = !layoutNode.getChildren().isEmpty();
        List<ElkEdge> insideSelfLoops = this.gatherInsideSelfLoops(layoutNode);
        boolean bl = hasInsideSelfLoops = !insideSelfLoops.isEmpty();
        if (hasChildren || hasInsideSelfLoops) {
            int nodeCount;
            LayoutAlgorithmData algorithmData = layoutNode.getProperty(CoreOptions.RESOLVED_ALGORITHM);
            if (algorithmData == null) {
                throw new UnsupportedConfigurationException("Resolved algorithm is not set; apply a LayoutAlgorithmResolver before computing layout.");
            }
            boolean supportsInsideSelfLoops = algorithmData.supportsFeature(GraphFeature.INSIDE_SELF_LOOPS);
            this.evaluateHierarchyHandlingInheritance(layoutNode);
            if (!hasChildren && hasInsideSelfLoops && !supportsInsideSelfLoops) {
                return Collections.emptyList();
            }
            ArrayList childrenInsideSelfLoops = Lists.newArrayList();
            if (layoutNode.getProperty(CoreOptions.HIERARCHY_HANDLING) == HierarchyHandling.INCLUDE_CHILDREN && (algorithmData.supportsFeature(GraphFeature.COMPOUND) || algorithmData.supportsFeature(GraphFeature.CLUSTERS))) {
                nodeCount = this.countNodesWithHierarchy(layoutNode);
                LinkedList nodeQueue = Lists.newLinkedList();
                nodeQueue.addAll(layoutNode.getChildren());
                while (!nodeQueue.isEmpty()) {
                    boolean stopHierarchy;
                    ElkNode node = (ElkNode)nodeQueue.poll();
                    this.evaluateHierarchyHandlingInheritance(node);
                    boolean bl2 = stopHierarchy = node.getProperty(CoreOptions.HIERARCHY_HANDLING) == HierarchyHandling.SEPARATE_CHILDREN;
                    if (stopHierarchy || node.hasProperty(CoreOptions.ALGORITHM) && !algorithmData.equals(node.getProperty(CoreOptions.RESOLVED_ALGORITHM))) {
                        List<ElkEdge> childLayoutSelfLoops = this.layoutRecursively(node, testController, progressMonitor);
                        childrenInsideSelfLoops.addAll(childLayoutSelfLoops);
                        node.setProperty(CoreOptions.HIERARCHY_HANDLING, HierarchyHandling.SEPARATE_CHILDREN);
                        ElkUtil.applyConfiguredNodeScaling(node);
                        continue;
                    }
                    nodeQueue.addAll(node.getChildren());
                }
            } else {
                nodeCount = layoutNode.getChildren().size();
                for (ElkNode child : layoutNode.getChildren()) {
                    List<ElkEdge> childLayoutSelfLoops = this.layoutRecursively(child, testController, progressMonitor);
                    childrenInsideSelfLoops.addAll(childLayoutSelfLoops);
                    ElkUtil.applyConfiguredNodeScaling(child);
                }
            }
            if (progressMonitor.isCanceled()) {
                return Collections.emptyList();
            }
            for (ElkEdge selfLoop : childrenInsideSelfLoops) {
                selfLoop.setProperty(CoreOptions.NO_LAYOUT, true);
            }
            this.executeAlgorithm(layoutNode, algorithmData, testController, progressMonitor.subTask(nodeCount));
            this.postProcessInsideSelfLoops(childrenInsideSelfLoops);
            if (hasInsideSelfLoops && supportsInsideSelfLoops) {
                return insideSelfLoops;
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    protected void executeAlgorithm(ElkNode layoutNode, LayoutAlgorithmData algorithmData, TestController testController, IElkProgressMonitor progressMonitor) {
        AbstractLayoutProvider layoutProvider = algorithmData.getInstancePool().fetch();
        if (testController != null && testController.targets(algorithmData)) {
            testController.install(layoutProvider);
        }
        try {
            try {
                layoutProvider.layout(layoutNode, progressMonitor);
                algorithmData.getInstancePool().release(layoutProvider);
            }
            catch (Exception exception) {
                layoutProvider.dispose();
                throw exception;
            }
        }
        finally {
            if (testController != null) {
                testController.uninstall();
            }
        }
    }

    protected int countNodesRecursively(ElkNode layoutNode, boolean countAncestors) {
        int count = layoutNode.getChildren().size();
        for (ElkNode childNode : layoutNode.getChildren()) {
            if (childNode.getChildren().isEmpty()) continue;
            count += this.countNodesRecursively(childNode, false);
        }
        if (countAncestors) {
            ElkNode parent = layoutNode.getParent();
            while (parent != null) {
                count += parent.getChildren().size();
                parent = parent.getParent();
            }
        }
        return count;
    }

    private void evaluateHierarchyHandlingInheritance(ElkNode layoutNode) {
        if (layoutNode.getProperty(CoreOptions.HIERARCHY_HANDLING) == HierarchyHandling.INHERIT) {
            if (layoutNode.getParent() == null) {
                layoutNode.setProperty(CoreOptions.HIERARCHY_HANDLING, HierarchyHandling.SEPARATE_CHILDREN);
            } else {
                HierarchyHandling parentHandling = layoutNode.getParent().getProperty(CoreOptions.HIERARCHY_HANDLING);
                layoutNode.setProperty(CoreOptions.HIERARCHY_HANDLING, parentHandling);
            }
        }
    }

    private int countNodesWithHierarchy(ElkNode parentNode) {
        int count = parentNode.getChildren().size();
        for (ElkNode childNode : parentNode.getChildren()) {
            LayoutAlgorithmData childData;
            LayoutAlgorithmData parentData;
            if (childNode.getProperty(CoreOptions.HIERARCHY_HANDLING) == HierarchyHandling.SEPARATE_CHILDREN || (parentData = parentNode.getProperty(CoreOptions.RESOLVED_ALGORITHM)) != (childData = childNode.getProperty(CoreOptions.RESOLVED_ALGORITHM)) && (parentData == null || !parentData.equals(childData)) || childNode.getChildren().isEmpty()) continue;
            count += this.countNodesWithHierarchy(childNode);
        }
        return count;
    }

    protected List<ElkEdge> gatherInsideSelfLoops(ElkNode node) {
        if (node.getProperty(CoreOptions.INSIDE_SELF_LOOPS_ACTIVATE).booleanValue()) {
            ArrayList insideSelfLoops = Lists.newArrayList();
            for (ElkEdge edge : ElkGraphUtil.allOutgoingEdges(node)) {
                if (!edge.isSelfloop() || !edge.getProperty(CoreOptions.INSIDE_SELF_LOOPS_YO).booleanValue()) continue;
                insideSelfLoops.add(edge);
            }
            return insideSelfLoops;
        }
        return Collections.emptyList();
    }

    protected void postProcessInsideSelfLoops(List<ElkEdge> insideSelfLoops) {
        for (ElkEdge selfLoop : insideSelfLoops) {
            ElkNode node = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)selfLoop.getSources().get(0));
            double xOffset = node.getX();
            double yOffset = node.getY();
            ElkEdgeSection section = (ElkEdgeSection)selfLoop.getSections().get(0);
            section.setStartLocation(section.getStartX() + xOffset, section.getStartY() + yOffset);
            section.setEndLocation(section.getEndX() + xOffset, section.getEndY() + yOffset);
            for (ElkBendPoint bend : section.getBendPoints()) {
                bend.set(bend.getX() + xOffset, bend.getY() + yOffset);
            }
            selfLoop.getProperty(CoreOptions.JUNCTION_POINTS).offset(xOffset, yOffset);
        }
    }
}

