/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.p4nodes.bk;

import com.google.common.collect.Lists;
import com.modelengineers.MoRe_elk.alg.layered.graph.LEdge;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.options.InternalProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DataFlowDistance {
    private boolean inTargetDirection;
    private List<LNode> nodes;
    private boolean[] visited;
    private List<Set<Integer>> adjacencies;
    private List<Integer> currentIndicesA;
    private List<Integer> currentIndicesB;
    private boolean[] nodesReachedByA;
    private boolean[] nodesReachedByB;
    private int counter;

    public DataFlowDistance(LGraph graph, boolean inTargetDirection) {
        this.inTargetDirection = inTargetDirection;
        this.getNodes(graph);
        this.fillAdjacencies();
    }

    public int getDistance(LNode nodeA, LNode nodeB) {
        this.initSearch(nodeA, nodeB);
        while (!this.commonNodeFound()) {
            this.goToNextNodes();
            if (!this.noNextNodes()) continue;
            return -1;
        }
        return this.counter;
    }

    public static boolean isInvalid(int count) {
        return count < 0;
    }

    private void getNodes(LGraph graph) {
        this.nodes = graph.getTrueNodesFromAllLayers();
        this.visited = new boolean[this.nodes.size()];
    }

    private void fillAdjacencies() {
        this.initAdjacancies();
        this.fillAdjacencyOfEachNode();
    }

    private void initAdjacancies() {
        this.adjacencies = Lists.newArrayList();
        this.nodes.stream().forEach(n -> {
            boolean bl = this.adjacencies.add(null);
        });
    }

    private void fillAdjacencyOfEachNode() {
        this.nodes.stream().forEach(node -> {
            Set<Integer> set = this.getAdjacency((LNode)node);
        });
    }

    private Set<Integer> getAdjacency(LNode node) {
        int ixNode = this.nodes.indexOf(node);
        if (this.adjacencies.get(ixNode) != null) {
            return this.adjacencies.get(ixNode);
        }
        Set<Integer> adjacency = this.getIndicesOfAdjacentNodes(node);
        this.adjacencies.set(ixNode, adjacency);
        return adjacency;
    }

    private Set<Integer> getIndicesOfAdjacentNodes(LNode node) {
        HashSet<Integer> ixAdjacentNodes = new HashSet<Integer>();
        for (LPort port : node.getTruePorts()) {
            for (LNode adjacentNode : this.getAdjacentNodes(port)) {
                if (ixAdjacentNodes.contains(this.getIndex(adjacentNode))) continue;
                if (this.isNodeToSkip(adjacentNode) && this.notVisited(node)) {
                    ixAdjacentNodes.addAll(this.getAdjacency(adjacentNode));
                    continue;
                }
                Integer ixAdjacentNode = this.getIndex(adjacentNode);
                ixAdjacentNodes.add(ixAdjacentNode);
            }
        }
        if (ixAdjacentNodes.isEmpty() && node.isNorthSouthDummy()) {
            LNode originOfNorthSouthDummy = ((LNode)node.getProperty(InternalProperties.ORIGIN)).getTrueNode();
            ixAdjacentNodes.add(this.getIndex(originOfNorthSouthDummy));
        }
        return ixAdjacentNodes;
    }

    private List<LNode> getAdjacentNodes(LPort port) {
        if (this.isPortForNorthSouthDummy(port)) {
            return Arrays.asList(port.getProperty(InternalProperties.PORT_DUMMY));
        }
        return DataFlowDistance.getConnectedNodes(port, this.inTargetDirection);
    }

    private boolean isPortForNorthSouthDummy(LPort port) {
        LNode portDummy = port.getProperty(InternalProperties.PORT_DUMMY);
        return portDummy != null && DataFlowDistance.getEdges(portDummy, this.inTargetDirection).size() > 0;
    }

    private static List<LEdge> getEdges(LNode node, boolean inTargetDirection) {
        return inTargetDirection ? node.getOutgoingEdgesAsList() : node.getIncomingEdgesAsList();
    }

    private static List<LNode> getConnectedNodes(LPort port, boolean inTargetDirection) {
        return inTargetDirection ? port.getTrueTargetNodes() : port.getTrueSourceNodes();
    }

    private boolean isNodeToSkip(LNode node) {
        return node.isLongEdge() || node.isNorthSouthDummy() || !this.isBranchingOrEnd(node);
    }

    private boolean isBranchingOrEnd(LNode node) {
        return !this.exactlyOneSourceNode(node) || !this.exactlyOneTargetNode(node);
    }

    private boolean exactlyOneSourceNode(LNode node) {
        return node.getTrueSourceNodesSkippingLongEdgeDummies().size() == 1;
    }

    private boolean exactlyOneTargetNode(LNode node) {
        return node.getTrueTargetNodesSkippingLongEdgeDummies().size() == 1;
    }

    private boolean notVisited(LNode node) {
        int ixNode = this.getIndex(node);
        boolean wasVistedBefore = this.visited[ixNode];
        this.visited[ixNode] = true;
        return !wasVistedBefore;
    }

    private void initSearch(LNode nodeA, LNode nodeB) {
        int ixA = this.getIndex(nodeA);
        int ixB = this.getIndex(nodeB);
        this.currentIndicesA = Lists.newArrayList((Object[])new Integer[]{ixA});
        this.currentIndicesB = Lists.newArrayList((Object[])new Integer[]{ixB});
        this.nodesReachedByA = this.initReachedNodes(ixA);
        this.nodesReachedByB = this.initReachedNodes(ixB);
        this.counter = 0;
    }

    private boolean[] initReachedNodes(int ixNode) {
        boolean[] reachedNodes = new boolean[this.nodes.size()];
        reachedNodes[ixNode] = true;
        return reachedNodes;
    }

    private boolean commonNodeFound() {
        return this.reachedNodesContainCurrentIndex(this.nodesReachedByB, this.currentIndicesA) || this.reachedNodesContainCurrentIndex(this.nodesReachedByA, this.currentIndicesB);
    }

    private boolean reachedNodesContainCurrentIndex(boolean[] nodesReached, List<Integer> currentIndices) {
        return currentIndices.stream().anyMatch(ixNode -> nodesReached[ixNode]);
    }

    private void goToNextNodes() {
        this.currentIndicesA = this.getNextIndices(this.currentIndicesA, this.nodesReachedByA);
        this.currentIndicesB = this.getNextIndices(this.currentIndicesB, this.nodesReachedByB);
        ++this.counter;
    }

    private List<Integer> getNextIndices(List<Integer> currentIndices, boolean[] nodesReached) {
        ArrayList nextIndices = Lists.newArrayList();
        for (int ixCurrent : currentIndices) {
            for (int ixNext : this.adjacencies.get(ixCurrent)) {
                if (nodesReached[ixNext]) continue;
                nextIndices.add(ixNext);
                nodesReached[ixNext] = true;
            }
        }
        return nextIndices;
    }

    private boolean noNextNodes() {
        return this.currentIndicesA.isEmpty() && this.currentIndicesB.isEmpty();
    }

    private int getIndex(LNode node) {
        return this.nodes.indexOf(node.getTrueNode());
    }
}

