/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.p4nodes.bk;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.Layer;
import com.modelengineers.MoRe_elk.alg.layered.options.EdgeStraighteningStrategy;
import com.modelengineers.MoRe_elk.alg.layered.options.InternalProperties;
import com.modelengineers.MoRe_elk.alg.layered.options.LayeredOptions;
import com.modelengineers.MoRe_elk.alg.layered.options.Spacings;
import com.modelengineers.MoRe_elk.alg.layered.p4nodes.bk.BKAlignedLayout;
import com.modelengineers.MoRe_elk.alg.layered.p4nodes.bk.ICompactor;
import com.modelengineers.MoRe_elk.alg.layered.p4nodes.bk.NeighborhoodInformation;
import com.modelengineers.MoRe_elk.alg.layered.p4nodes.bk.ThresholdStrategy;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class BKCompactor
implements ICompactor {
    private LGraph layeredGraph;
    private ThresholdStrategy threshStrategy;
    private NeighborhoodInformation ni;
    private Spacings spacings;
    private Map<LNode, ClassNode> sinkNodes = Maps.newHashMap();

    public BKCompactor(LGraph layeredGraph, NeighborhoodInformation ni) {
        this.layeredGraph = layeredGraph;
        this.ni = ni;
        this.spacings = layeredGraph.getProperty(InternalProperties.SPACINGS);
        this.threshStrategy = layeredGraph.getProperty(LayeredOptions.NODE_PLACEMENT_BK_EDGE_STRAIGHTENING) == EdgeStraighteningStrategy.IMPROVE_STRAIGHTNESS ? new ThresholdStrategy.SimpleThresholdStrategy() : new ThresholdStrategy.NullThresholdStrategy();
    }

    @Override
    public void horizontalCompaction(BKAlignedLayout bal) {
        for (Layer layer : this.layeredGraph.getLayers()) {
            Iterator<LNode> iterator = layer.getNodes().iterator();
            while (iterator.hasNext()) {
                LNode node;
                bal.sink[node.id] = node = iterator.next();
                bal.shift[node.id] = bal.vdir == BKAlignedLayout.VDirection.UP ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
        }
        this.sinkNodes.clear();
        List layers = this.layeredGraph.getLayers();
        if (bal.hdir == BKAlignedLayout.HDirection.LEFT) {
            layers = Lists.reverse(layers);
        }
        this.threshStrategy.init(bal, this.ni);
        Arrays.fill((Object[])bal.y, null);
        for (Layer layer : layers) {
            List nodes = layer.getNodes();
            if (bal.vdir == BKAlignedLayout.VDirection.UP) {
                nodes = Lists.reverse(nodes);
            }
            for (LNode v : nodes) {
                if (!bal.root[v.id].equals(v)) continue;
                this.placeBlock(v, bal);
            }
        }
        this.placeClasses(bal);
        for (Layer layer : layers) {
            for (LNode v : layer.getNodes()) {
                bal.y[v.id] = bal.y[bal.root[v.id].id];
                if (!v.equals(bal.root[v.id])) continue;
                double sinkShift = bal.shift[bal.sink[v.id].id];
                if (!(bal.vdir == BKAlignedLayout.VDirection.UP && sinkShift > Double.NEGATIVE_INFINITY) && (bal.vdir != BKAlignedLayout.VDirection.DOWN || !(sinkShift < Double.POSITIVE_INFINITY))) continue;
                bal.y[v.id] = bal.y[v.id] + sinkShift;
            }
        }
        this.threshStrategy.postProcess();
    }

    private void placeBlock(LNode root, BKAlignedLayout bal) {
        if (bal.y[root.id] != null) {
            return;
        }
        boolean isInitialAssignment = true;
        bal.y[root.id] = 0.0;
        LNode currentNode = root;
        double newPositionForStraightEdge = bal.vdir == BKAlignedLayout.VDirection.DOWN ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        do {
            int currentIndexInLayer = this.ni.nodeIndex[currentNode.id];
            int currentLayerSize = currentNode.getLayer().getNodes().size();
            if (bal.vdir == BKAlignedLayout.VDirection.DOWN && currentIndexInLayer > 0 || bal.vdir == BKAlignedLayout.VDirection.UP && currentIndexInLayer < currentLayerSize - 1) {
                double requiredSpace;
                double spacing;
                LNode neighbor = null;
                LNode neighborRoot = null;
                neighbor = bal.vdir == BKAlignedLayout.VDirection.UP ? currentNode.getLayer().getNodes().get(currentIndexInLayer + 1) : currentNode.getLayer().getNodes().get(currentIndexInLayer - 1);
                neighborRoot = bal.root[neighbor.id];
                this.placeBlock(neighborRoot, bal);
                newPositionForStraightEdge = this.threshStrategy.calculateThreshold(newPositionForStraightEdge, root, currentNode);
                if (bal.sink[root.id].equals(root)) {
                    bal.sink[root.id] = bal.sink[neighborRoot.id];
                }
                if (bal.sink[root.id].equals(bal.sink[neighborRoot.id])) {
                    double newBlockPosition;
                    double newPositionNextToNeighbor;
                    double currentBlockPosition;
                    spacing = this.spacings.getVerticalSpacing(currentNode, neighbor);
                    double minSpacing = this.spacings.getMinimalVerticalSpacing(currentNode, neighbor);
                    double spacingTolerance = spacing - minSpacing;
                    if (bal.vdir == BKAlignedLayout.VDirection.UP) {
                        currentBlockPosition = bal.y[root.id];
                        newPositionNextToNeighbor = bal.y[neighborRoot.id] + bal.innerShift[neighbor.id] - neighbor.getMargin().top - spacing - currentNode.getMargin().bottom - currentNode.getSize().y - bal.innerShift[currentNode.id];
                        newBlockPosition = this.getNewPositionUpwards(newPositionNextToNeighbor, newPositionForStraightEdge, spacingTolerance);
                        if (isInitialAssignment) {
                            isInitialAssignment = false;
                            bal.y[root.id] = newBlockPosition;
                            continue;
                        }
                        bal.y[root.id] = Math.min(currentBlockPosition, newBlockPosition);
                        continue;
                    }
                    currentBlockPosition = bal.y[root.id];
                    newPositionNextToNeighbor = bal.y[neighborRoot.id] + bal.innerShift[neighbor.id] + neighbor.getSize().y + neighbor.getMargin().bottom + spacing + currentNode.getMargin().top - bal.innerShift[currentNode.id];
                    newBlockPosition = this.getNewPositionDownwards(newPositionNextToNeighbor, newPositionForStraightEdge, spacingTolerance);
                    if (isInitialAssignment) {
                        isInitialAssignment = false;
                        bal.y[root.id] = newBlockPosition;
                        continue;
                    }
                    bal.y[root.id] = Math.max(currentBlockPosition, newBlockPosition);
                    continue;
                }
                spacing = this.spacings.getVerticalSpacing(currentNode, neighbor);
                ClassNode sinkNode = this.getOrCreateClassNode(bal.sink[root.id], bal);
                ClassNode neighborSink = this.getOrCreateClassNode(bal.sink[neighborRoot.id], bal);
                if (bal.vdir == BKAlignedLayout.VDirection.UP) {
                    requiredSpace = bal.y[root.id] + bal.innerShift[currentNode.id] + currentNode.getSize().y + currentNode.getMargin().bottom + spacing - (bal.y[neighborRoot.id] + bal.innerShift[neighbor.id] - neighbor.getMargin().top);
                    sinkNode.addEdge(neighborSink, requiredSpace);
                    continue;
                }
                requiredSpace = bal.y[root.id] + bal.innerShift[currentNode.id] - currentNode.getMargin().top - bal.y[neighborRoot.id] - bal.innerShift[neighbor.id] - neighbor.getSize().y - neighbor.getMargin().bottom - spacing;
                sinkNode.addEdge(neighborSink, requiredSpace);
                continue;
            }
            newPositionForStraightEdge = this.threshStrategy.calculateThreshold(newPositionForStraightEdge, root, currentNode);
        } while ((currentNode = bal.align[currentNode.id]) != root);
        this.threshStrategy.finishBlock(root);
    }

    private double getNewPositionDownwards(double newPositionNextToNeighbor, double newPositionForStraightEdge, double spacingTolerance) {
        return newPositionNextToNeighbor - newPositionForStraightEdge < spacingTolerance ? newPositionForStraightEdge : newPositionNextToNeighbor;
    }

    private double getNewPositionUpwards(double newPositionNextToNeighbor, double newPositionForStraightEdge, double spacingTolerance) {
        return newPositionForStraightEdge - newPositionNextToNeighbor < spacingTolerance ? newPositionForStraightEdge : newPositionNextToNeighbor;
    }

    private void placeClasses(BKAlignedLayout bal) {
        LinkedList sinks = Lists.newLinkedList();
        for (ClassNode n : this.sinkNodes.values()) {
            if (n.indegree != 0) continue;
            sinks.add(n);
        }
        while (!sinks.isEmpty()) {
            ClassNode n;
            n = (ClassNode)sinks.poll();
            if (n.classShift == null) {
                n.classShift = 0.0;
            }
            for (ClassEdge e : n.outgoing) {
                e.target.classShift = e.target.classShift == null ? Double.valueOf(n.classShift + e.separation) : (bal.vdir == BKAlignedLayout.VDirection.DOWN ? Double.valueOf(Math.min(e.target.classShift, n.classShift + e.separation)) : Double.valueOf(Math.max(e.target.classShift, n.classShift + e.separation)));
                --e.target.indegree;
                if (e.target.indegree != 0) continue;
                sinks.add(e.target);
            }
        }
        for (ClassNode n : this.sinkNodes.values()) {
            bal.shift[n.node.id] = n.classShift;
        }
    }

    private ClassNode getOrCreateClassNode(LNode sinkNode, BKAlignedLayout bal) {
        ClassNode node = this.sinkNodes.get(sinkNode);
        if (node == null) {
            node = new ClassNode();
            node.node = sinkNode;
            this.sinkNodes.put(node.node, node);
        }
        return node;
    }

    private static class ClassEdge {
        double separation = 0.0;
        ClassNode target;

        private ClassEdge() {
        }
    }

    private static class ClassNode {
        Double classShift = null;
        LNode node;
        List<ClassEdge> outgoing = Lists.newArrayList();
        int indegree = 0;

        private ClassNode() {
        }

        private void addEdge(ClassNode target, double separation) {
            ClassEdge se = new ClassEdge();
            se.target = target;
            se.separation = separation;
            ++target.indegree;
            this.outgoing.add(se);
        }
    }
}

