/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.p4nodes.bk;

import com.google.common.collect.Lists;
import com.modelengineers.MoRe_elk.alg.layered.graph.LEdge;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.graph.Layer;
import com.modelengineers.MoRe_elk.alg.layered.options.LayeredOptions;
import com.modelengineers.MoRe_elk.alg.layered.p4nodes.bk.BKAlignedLayout;
import com.modelengineers.MoRe_elk.alg.layered.p4nodes.bk.BKNodePlacer;
import com.modelengineers.MoRe_elk.alg.layered.p4nodes.bk.NeighborhoodInformation;
import com.modelengineers.MoRe_elk.core.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BKAligner {
    private LGraph layeredGraph;
    private NeighborhoodInformation ni;

    public BKAligner(LGraph layeredGraph, NeighborhoodInformation ni) {
        this.layeredGraph = layeredGraph;
        this.ni = ni;
    }

    public void verticalAlignment(BKAlignedLayout bal, Set<LEdge> markedEdges) {
        for (Layer layer : this.layeredGraph.getLayers()) {
            Iterator<LNode> iterator = layer.getNodes().iterator();
            while (iterator.hasNext()) {
                LNode v;
                bal.root[v.id] = v = iterator.next();
                bal.align[v.id] = v;
                bal.innerShift[v.id] = 0.0;
            }
        }
        List layers = this.layeredGraph.getLayers();
        if (bal.hdir == BKAlignedLayout.HDirection.LEFT) {
            layers = Lists.reverse(layers);
        }
        boolean useMESMoReVerticalAlignment = bal.layeredGraph.getProperty(LayeredOptions.NODE_VERTICAL_ALIGNMENT_MES_MORE);
        for (Layer layer : layers) {
            int r = -1;
            List nodes = layer.getNodes();
            if (bal.vdir == BKAlignedLayout.VDirection.UP) {
                r = Integer.MAX_VALUE;
                nodes = Lists.reverse(nodes);
            }
            for (LNode vik : nodes) {
                int m;
                List<Pair<LNode, LEdge>> neighbors = null;
                neighbors = bal.hdir == BKAlignedLayout.HDirection.LEFT ? (!bal.alignToMostConnectedNodes ? this.ni.rightNeighbors.get(vik.id) : this.ni.mostConctdRightNeighbors.get(vik.id)) : (!bal.alignToMostConnectedNodes ? this.ni.leftNeighbors.get(vik.id) : this.ni.mostConctdLeftNeighbors.get(vik.id));
                if (neighbors.size() <= 0) continue;
                if (useMESMoReVerticalAlignment) {
                    r = this.verticalAlignmentMESMoRe(vik, bal, r, neighbors, markedEdges);
                    continue;
                }
                int d = neighbors.size();
                int low = (int)Math.floor(((double)d + 1.0) / 2.0) - 1;
                int high = (int)Math.ceil(((double)d + 1.0) / 2.0) - 1;
                if (bal.vdir == BKAlignedLayout.VDirection.UP) {
                    m = high;
                    while (m >= low) {
                        if (bal.align[vik.id].equals(vik)) {
                            Pair<LNode, LEdge> u_m_pair = neighbors.get(m);
                            LNode u_m = u_m_pair.getFirst();
                            if (!markedEdges.contains(u_m_pair.getSecond()) && r > this.ni.nodeIndex[u_m.id]) {
                                bal.align[u_m.id] = vik;
                                bal.root[vik.id] = bal.root[u_m.id];
                                bal.align[vik.id] = bal.root[vik.id];
                                int n = bal.root[vik.id].id;
                                bal.od[n] = bal.od[n] & vik.getType() == LNode.NodeType.LONG_EDGE;
                                r = this.ni.nodeIndex[u_m.id];
                            }
                        }
                        --m;
                    }
                    continue;
                }
                m = low;
                while (m <= high) {
                    if (bal.align[vik.id].equals(vik)) {
                        Pair<LNode, LEdge> um_pair = neighbors.get(m);
                        LNode um = um_pair.getFirst();
                        if (!markedEdges.contains(um_pair.getSecond()) && r < this.ni.nodeIndex[um.id]) {
                            bal.align[um.id] = vik;
                            bal.root[vik.id] = bal.root[um.id];
                            bal.align[vik.id] = bal.root[vik.id];
                            int n = bal.root[vik.id].id;
                            bal.od[n] = bal.od[n] & vik.getType() == LNode.NodeType.LONG_EDGE;
                            r = this.ni.nodeIndex[um.id];
                        }
                    }
                    ++m;
                }
            }
        }
    }

    private int verticalAlignmentMESMoRe(LNode vik, BKAlignedLayout bal, int r, List<Pair<LNode, LEdge>> neighbors, Set<LEdge> markedEdges) {
        List neighborsToIterate = bal.vdir == BKAlignedLayout.VDirection.UP && !bal.alignToMostConnectedNodes ? Lists.reverse(neighbors) : neighbors;
        int newR = r;
        for (Pair umPair : neighborsToIterate) {
            newR = this.setVerticalAlignmentIfSuitable(umPair, vik, bal, newR, markedEdges);
        }
        return newR;
    }

    private int setVerticalAlignmentIfSuitable(Pair<LNode, LEdge> umPair, LNode vik, BKAlignedLayout bal, Integer r, Set<LEdge> markedEdges) {
        List<Integer> idxOfTargetNodes;
        LEdge umEdge;
        LNode um;
        int newR = r;
        if (bal.align[vik.id].equals(vik) && this.shouldBeAligned(um = umPair.getFirst(), vik, umEdge = umPair.getSecond(), bal, r, markedEdges, idxOfTargetNodes = this.getIdxOfTargetNodesConnectedTo(umEdge.getSource())).booleanValue()) {
            newR = this.setVerticalAlignment(um, vik, bal);
        }
        return newR;
    }

    private List<Integer> getIdxOfTargetNodesConnectedTo(LPort srcPort) {
        Iterable<LEdge> edgesOfSrcPort = srcPort.getConnectedEdges();
        ArrayList<Integer> idxOfNodesConnectedToSrcPort = new ArrayList<Integer>();
        edgesOfSrcPort.forEach(edge -> {
            boolean bl = idxOfNodesConnectedToSrcPort.add(this.ni.nodeIndex[edge.getTarget().getNode().id]);
        });
        return idxOfNodesConnectedToSrcPort;
    }

    private Boolean shouldBeAligned(LNode um, LNode vik, LEdge umEdge, BKAlignedLayout bal, Integer r, Set<LEdge> markedEdges, List<Integer> idxOfTargetNodes) {
        if (!markedEdges.contains(umEdge) && this.doesNotContradictAlreadyAlignedNodes(um, bal, r).booleanValue() && this.targetNodeIsHighestTargetNode(um, vik, bal, idxOfTargetNodes).booleanValue()) {
            return true;
        }
        return false;
    }

    private Boolean doesNotContradictAlreadyAlignedNodes(LNode um, BKAlignedLayout bal, int r) {
        int vDirSign = bal.vdir == BKAlignedLayout.VDirection.DOWN ? 1 : -1;
        if (r * vDirSign < this.ni.nodeIndex[um.id] * vDirSign) {
            return true;
        }
        return false;
    }

    private Boolean targetNodeIsHighestTargetNode(LNode um, LNode vik, BKAlignedLayout bal, List<Integer> idxOfTargetNodes) {
        int idxOfTargetNode = bal.hdir == BKAlignedLayout.HDirection.LEFT ? this.ni.nodeIndex[um.id] : this.ni.nodeIndex[vik.id];
        if (Collections.min(idxOfTargetNodes) == idxOfTargetNode) {
            return true;
        }
        return false;
    }

    private int setVerticalAlignment(LNode um, LNode vik, BKAlignedLayout bal) {
        bal.align[um.id] = vik;
        bal.root[vik.id] = bal.root[um.id];
        bal.align[vik.id] = bal.root[vik.id];
        int n = bal.root[vik.id].id;
        bal.od[n] = bal.od[n] & vik.getType() == LNode.NodeType.LONG_EDGE;
        return this.ni.nodeIndex[um.id];
    }

    public void insideBlockShift(BKAlignedLayout bal) {
        Map<LNode, List<LNode>> blocks = BKNodePlacer.getBlocks(bal);
        for (LNode root : blocks.keySet()) {
            LNode next;
            double spaceAbove = 0.0;
            double spaceBelow = 0.0;
            spaceAbove = root.getMargin().top;
            spaceBelow = root.getSize().y + root.getMargin().bottom;
            bal.innerShift[root.id] = 0.0;
            LNode current = root;
            while ((next = bal.align[current.id]) != root) {
                LEdge edge = BKNodePlacer.getEdge(current, next);
                double portPosDiff = 0.0;
                portPosDiff = bal.hdir == BKAlignedLayout.HDirection.LEFT ? edge.getTarget().getPosition().y + edge.getTarget().getAnchor().y - edge.getSource().getPosition().y - edge.getSource().getAnchor().y : edge.getSource().getPosition().y + edge.getSource().getAnchor().y - edge.getTarget().getPosition().y - edge.getTarget().getAnchor().y;
                double nextInnerShift = bal.innerShift[current.id] + portPosDiff;
                bal.innerShift[next.id] = nextInnerShift;
                spaceAbove = Math.max(spaceAbove, next.getMargin().top - nextInnerShift);
                spaceBelow = Math.max(spaceBelow, nextInnerShift + next.getSize().y + next.getMargin().bottom);
                current = next;
            }
            current = root;
            do {
                bal.innerShift[current.id] = bal.innerShift[current.id] + spaceAbove;
            } while ((current = bal.align[current.id]) != root);
            bal.blockSize[root.id] = spaceAbove + spaceBelow;
        }
    }
}

