/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.p4nodes.bk;

import com.google.common.collect.Lists;
import com.modelengineers.MoRe_elk.alg.layered.graph.LEdge;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.graph.Layer;
import com.modelengineers.MoRe_elk.alg.layered.options.InternalProperties;
import com.modelengineers.MoRe_elk.alg.layered.options.Spacings;
import com.modelengineers.MoRe_elk.alg.layered.p4nodes.bk.NeighborhoodInformation;
import com.modelengineers.MoRe_elk.core.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;

public final class BKAlignedLayout {
    LNode[] root;
    Double[] blockSize;
    LNode[] align;
    Double[] innerShift;
    LNode[] sink;
    Double[] shift;
    Double[] y;
    VDirection vdir;
    HDirection hdir;
    Boolean[] su;
    Boolean[] od;
    LGraph layeredGraph;
    Spacings spacings;
    boolean alignToMostConnectedNodes;

    public BKAlignedLayout(LGraph layeredGraph, int nodeCount, VDirection vdir, HDirection hdir, boolean alignToMostConnectedNodes) {
        this.layeredGraph = layeredGraph;
        this.spacings = layeredGraph.getProperty(InternalProperties.SPACINGS);
        this.root = new LNode[nodeCount];
        this.blockSize = new Double[nodeCount];
        this.align = new LNode[nodeCount];
        this.innerShift = new Double[nodeCount];
        this.sink = new LNode[nodeCount];
        this.shift = new Double[nodeCount];
        this.y = new Double[nodeCount];
        this.su = new Boolean[nodeCount];
        Arrays.fill((Object[])this.su, (Object)false);
        this.od = new Boolean[nodeCount];
        Arrays.fill((Object[])this.od, (Object)true);
        this.vdir = vdir;
        this.hdir = hdir;
        this.alignToMostConnectedNodes = alignToMostConnectedNodes;
    }

    public void cleanup() {
        this.root = null;
        this.blockSize = null;
        this.align = null;
        this.innerShift = null;
        this.sink = null;
        this.shift = null;
        this.y = null;
    }

    public double layoutSize() {
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (Layer layer : this.layeredGraph.getLayers()) {
            for (LNode n : layer.getNodes()) {
                double yMin = this.y[n.id];
                double yMax = yMin + this.blockSize[this.root[n.id].id];
                min = Math.min(min, yMin);
                max = Math.max(max, yMax);
            }
        }
        return max - min;
    }

    public int numOfTargetPortsNotAlignedWithSourcePort() {
        int numberOfNotAlignedPorts = 0;
        ArrayList srcAndDstPortsList = Lists.newArrayList();
        for (Layer layer : this.layeredGraph.getLayers()) {
            for (LNode node : layer.getNodes()) {
                for (LEdge edge : node.getIncomingEdges()) {
                    Pair<LPort, LPort> curSrcAndDstPorts = Pair.of(edge.getSource(), edge.getTarget());
                    if (node.getType().equals((Object)LNode.NodeType.LONG_EDGE) && srcAndDstPortsList.contains(curSrcAndDstPorts)) continue;
                    srcAndDstPortsList.add(curSrcAndDstPorts);
                    if (this.calculateDelta(edge.getSource(), edge.getTarget()) == 0.0) continue;
                    ++numberOfNotAlignedPorts;
                }
            }
        }
        return numberOfNotAlignedPorts;
    }

    public double calculateDelta(LPort src, LPort tgt) {
        double srcPos = this.y[src.getNode().id] + this.innerShift[src.getNode().id] + src.getPosition().y + src.getAnchor().y;
        double tgtPos = this.y[tgt.getNode().id] + this.innerShift[tgt.getNode().id] + tgt.getPosition().y + tgt.getAnchor().y;
        return tgtPos - srcPos;
    }

    public void shiftBlock(LNode rootNode, double delta) {
        LNode current = rootNode;
        do {
            double newPos = this.y[current.id] + delta;
            this.y[current.id] = newPos;
        } while ((current = this.align[current.id]) != rootNode);
    }

    public double checkSpaceAbove(LNode blockRoot, double delta, NeighborhoodInformation ni) {
        LNode rootNode;
        double availableSpace = delta;
        LNode current = rootNode = blockRoot;
        do {
            current = this.align[current.id];
            double minYCurrent = this.getMinY(current);
            LNode neighbor = this.getUpperNeighbor(current, ni);
            if (neighbor == null) continue;
            double maxYNeighbor = this.getMaxY(neighbor);
            availableSpace = Math.min(availableSpace, minYCurrent - (maxYNeighbor + this.spacings.getVerticalSpacing(current, neighbor)));
        } while (rootNode != current);
        return availableSpace;
    }

    public double checkSpaceBelow(LNode blockRoot, double delta, NeighborhoodInformation ni) {
        LNode rootNode;
        double availableSpace = delta;
        LNode current = rootNode = blockRoot;
        do {
            current = this.align[current.id];
            double maxYCurrent = this.getMaxY(current);
            LNode neighbor = this.getLowerNeighbor(current, ni);
            if (neighbor == null) continue;
            double minYNeighbor = this.getMinY(neighbor);
            availableSpace = Math.min(availableSpace, minYNeighbor - (maxYCurrent + this.spacings.getVerticalSpacing(current, neighbor)));
        } while (rootNode != current);
        return availableSpace;
    }

    public double getMinY(LNode n) {
        LNode rootNode = this.root[n.id];
        return this.y[rootNode.id] + this.innerShift[n.id] - n.getMargin().top;
    }

    public double getMaxY(LNode n) {
        LNode rootNode = this.root[n.id];
        return this.y[rootNode.id] + this.innerShift[n.id] + n.getSize().y + n.getMargin().bottom;
    }

    public LNode getNodeVerticallyAlignedWith(LNode n) {
        return this.align[n.id];
    }

    private LNode getLowerNeighbor(LNode n, NeighborhoodInformation ni) {
        int layerIndex = ni.nodeIndex[n.id];
        Layer l = n.getLayer();
        if (layerIndex < l.getNodes().size() - 1) {
            return l.getNodes().get(layerIndex + 1);
        }
        return null;
    }

    private LNode getUpperNeighbor(LNode n, NeighborhoodInformation ni) {
        Layer l = n.getLayer();
        int layerIndex = ni.nodeIndex[n.id];
        if (layerIndex > 0) {
            return l.getNodes().get(layerIndex - 1);
        }
        return null;
    }

    public String toString() {
        String result = "";
        if (this.hdir == HDirection.RIGHT) {
            result = String.valueOf(result) + "RIGHT";
        } else if (this.hdir == HDirection.LEFT) {
            result = String.valueOf(result) + "LEFT";
        }
        if (this.vdir == VDirection.DOWN) {
            result = String.valueOf(result) + "DOWN";
        } else if (this.vdir == VDirection.UP) {
            result = String.valueOf(result) + "UP";
        }
        result = this.alignToMostConnectedNodes ? String.valueOf(result) + "MCON" : (!this.alignToMostConnectedNodes ? String.valueOf(result) + "MCOFF" : String.valueOf(result) + "BALANCED");
        return result;
    }

    public static enum HDirection {
        RIGHT,
        LEFT;

    }

    public static enum VDirection {
        DOWN,
        UP;

    }
}

