/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.p4nodes;

import com.modelengineers.MoRe_elk.alg.layered.LayeredPhases;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.Layer;
import com.modelengineers.MoRe_elk.alg.layered.options.InternalProperties;
import com.modelengineers.MoRe_elk.alg.layered.options.Spacings;
import com.modelengineers.MoRe_elk.core.alg.ILayoutPhase;
import com.modelengineers.MoRe_elk.core.alg.LayoutProcessorConfiguration;
import com.modelengineers.MoRe_elk.core.math.KVector;
import com.modelengineers.MoRe_elk.core.util.IElkProgressMonitor;

public final class SimpleNodePlacer
implements ILayoutPhase<LayeredPhases, LGraph> {
    @Override
    public LayoutProcessorConfiguration<LayeredPhases, LGraph> getLayoutProcessorConfiguration(LGraph graph) {
        return LayoutProcessorConfiguration.create();
    }

    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        KVector layerSize;
        monitor.begin("Simple node placement", 1.0f);
        Spacings spacings = layeredGraph.getProperty(InternalProperties.SPACINGS);
        double maxHeight = 0.0;
        for (Layer layer : layeredGraph.getLayers()) {
            layerSize = layer.getSize();
            layerSize.y = 0.0;
            LNode lastNode = null;
            for (LNode node : layer.getNodes()) {
                if (lastNode != null) {
                    layerSize.y += spacings.getMinimalVerticalSpacing(node, lastNode);
                }
                layerSize.y += node.getMargin().top + node.getSize().y + node.getMargin().bottom;
                lastNode = node;
            }
            maxHeight = Math.max(maxHeight, layerSize.y);
        }
        for (Layer layer : layeredGraph.getLayers()) {
            layerSize = layer.getSize();
            double pos = (maxHeight - layerSize.y) / 2.0;
            LNode lastNode = null;
            for (LNode node : layer.getNodes()) {
                if (lastNode != null) {
                    pos += spacings.getMinimalVerticalSpacing(node, lastNode);
                }
                node.getPosition().y = pos += node.getMargin().top;
                pos += node.getSize().y + node.getMargin().bottom;
                lastNode = node;
            }
        }
        monitor.done();
    }
}

