/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.p4nodes;

import com.modelengineers.MoRe_elk.alg.layered.LayeredPhases;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.Layer;
import com.modelengineers.MoRe_elk.alg.layered.options.InternalProperties;
import com.modelengineers.MoRe_elk.alg.layered.options.Spacings;
import com.modelengineers.MoRe_elk.core.alg.ILayoutPhase;
import com.modelengineers.MoRe_elk.core.alg.LayoutProcessorConfiguration;
import com.modelengineers.MoRe_elk.core.util.IElkProgressMonitor;

public final class InteractiveNodePlacer
implements ILayoutPhase<LayeredPhases, LGraph> {
    private Spacings spacings;

    @Override
    public LayoutProcessorConfiguration<LayeredPhases, LGraph> getLayoutProcessorConfiguration(LGraph graph) {
        return LayoutProcessorConfiguration.create();
    }

    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Interactive node placement", 1.0f);
        this.spacings = layeredGraph.getProperty(InternalProperties.SPACINGS);
        for (Layer layer : layeredGraph) {
            this.placeNodes(layer);
        }
        monitor.done();
    }

    private void placeNodes(Layer layer) {
        double minValidY = Double.NEGATIVE_INFINITY;
        LNode prevNode = null;
        for (LNode node : layer) {
            double spacing;
            LNode.NodeType nodeType = node.getType();
            if (nodeType != LNode.NodeType.NORMAL) {
                Double originalYCoordinate = node.getProperty(InternalProperties.ORIGINAL_DUMMY_NODE_POSITION);
                if (originalYCoordinate == null) {
                    minValidY = Math.max(minValidY, 0.0);
                    node.getPosition().y = minValidY + this.getSpacing(node, prevNode);
                } else {
                    node.getPosition().y = originalYCoordinate;
                }
            }
            if (node.getPosition().y < minValidY + (spacing = this.getSpacing(node, prevNode)) + node.getMargin().top) {
                node.getPosition().y = minValidY + spacing + node.getMargin().top;
            }
            minValidY = node.getPosition().y + node.getSize().y + node.getMargin().bottom;
            prevNode = node;
        }
    }

    private double getSpacing(LNode node, LNode prevNode) {
        if (prevNode == null) {
            return 0.0;
        }
        return this.spacings.getMinimalVerticalSpacing(node, prevNode);
    }
}

