/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.p3order.mes;

import com.google.common.collect.Lists;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.graph.Layer;
import com.modelengineers.MoRe_elk.alg.layered.p3order.mes.BinaryOrderProblem;
import com.modelengineers.MoRe_elk.core.options.PortSide;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class NorthSouthDummiesNextToCorrespondingNodeConstraint {
    private BinaryOrderProblem orderProblem;

    public NorthSouthDummiesNextToCorrespondingNodeConstraint(LGraph graph, BinaryOrderProblem orderProblem) {
        this.orderProblem = orderProblem;
        graph.getLayers().forEach(layer -> this.orderNorthSouthDummiesToCorrespondingNode((Layer)layer));
    }

    private void orderNorthSouthDummiesToCorrespondingNode(Layer layer) {
        this.orderNorthDummiesAboveCorrespondingNode(layer);
        this.orderSouthDummiesBelowCorrespondingNode(layer);
    }

    private void orderNorthDummiesAboveCorrespondingNode(Layer layer) {
        Map<LNode, List<LNode>> dummies = this.getNorthDummies(layer);
        this.orderAboveCorrespondingNode(dummies);
    }

    private void orderSouthDummiesBelowCorrespondingNode(Layer layer) {
        Map<LNode, List<LNode>> dummies = this.getSouthDummies(layer);
        this.orderBelowCorrespondingNode(dummies);
    }

    private Map<LNode, List<LNode>> getNorthDummies(Layer layer) {
        return this.getDummiesOfSide(layer, PortSide.NORTH);
    }

    private Map<LNode, List<LNode>> getSouthDummies(Layer layer) {
        return this.getDummiesOfSide(layer, PortSide.SOUTH);
    }

    private Map<LNode, List<LNode>> getDummiesOfSide(Layer layer, PortSide portSide) {
        return layer.getNodes().stream().collect(Collectors.toMap(node -> node, node -> this.getCorrespondingDummiesOfSide((LNode)node, portSide)));
    }

    private List<LNode> getCorrespondingDummiesOfSide(LNode node, PortSide portSide) {
        return this.getNorthOrSouthPortsSortedAsTheyShouldBeOrdered(node, portSide).stream().map(p -> p.getPortDummyNode()).filter(d -> d != null).collect(Collectors.toList());
    }

    private List<LPort> getNorthOrSouthPortsSortedAsTheyShouldBeOrdered(LNode node, PortSide portSide) {
        return node.getPortsAsList(portSide).stream().sorted(Comparator.comparing(NorthSouthDummiesNextToCorrespondingNodeConstraint::getSortingValueForNorthSouthPort)).collect(Collectors.toList());
    }

    private static double getSortingValueForNorthSouthPort(LPort port) {
        return NorthSouthDummiesNextToCorrespondingNodeConstraint.northSouthPortHasIncomingEdges(port) ? port.getPosition().x : -port.getPosition().x;
    }

    private static boolean northSouthPortHasIncomingEdges(LPort northSouthPort) {
        LNode northSouthDummyNode = northSouthPort.getPortDummyNode();
        return northSouthDummyNode != null && !northSouthDummyNode.getIncomingEdgesAsList().isEmpty();
    }

    private void orderAboveCorrespondingNode(Map<LNode, List<LNode>> dummies) {
        dummies.forEach((node, northDummies) -> this.orderAboveNode((LNode)node, (List<LNode>)northDummies));
    }

    private void orderAboveNode(LNode node, List<LNode> northDummies) {
        ArrayList nodeOrderFromBottomToTop = Lists.newArrayList((Object[])new LNode[]{node});
        nodeOrderFromBottomToTop.addAll(northDummies);
        this.enforceOrder(nodeOrderFromBottomToTop);
    }

    private void orderBelowCorrespondingNode(Map<LNode, List<LNode>> dummies) {
        dummies.forEach((node, southDummies) -> this.orderBelowNode((LNode)node, (List<LNode>)southDummies));
    }

    private void orderBelowNode(LNode node, List<LNode> southDummies) {
        Collections.reverse(southDummies);
        ArrayList nodeOrderFromBottomToTop = Lists.newArrayList(southDummies);
        nodeOrderFromBottomToTop.add(node);
        this.enforceOrder(nodeOrderFromBottomToTop);
    }

    private void enforceOrder(List<LNode> nodeOrderFromBottomToTop) {
        int ix = 1;
        while (ix < nodeOrderFromBottomToTop.size()) {
            LNode lowerNode = nodeOrderFromBottomToTop.get(ix - 1);
            LNode upperNode = nodeOrderFromBottomToTop.get(ix);
            this.orderProblem.setFirstNodeDirectlyAboveSecondNode(upperNode, lowerNode);
            ++ix;
        }
    }
}

