/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.p3order.mes;

import com.google.common.collect.Lists;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.graph.Layer;
import com.modelengineers.MoRe_elk.alg.layered.mesutils.MesUtilMethods;
import com.modelengineers.MoRe_elk.alg.layered.p3order.mes.ReachableNodesDetector;
import com.modelengineers.MoRe_elk.core.options.PortSide;
import com.modelengineers.MoRe_elk.core.util.Pair;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;

public class NodeCombinerDetector {
    private LGraph graph;
    private List<Pair<LNode, LNode>> pairsToCombine = Lists.newArrayList();
    private boolean forward;
    private List<LNode> visited = Lists.newArrayList();
    private ReachableNodesDetector reachableNodesDetector = new ReachableNodesDetector();

    public NodeCombinerDetector(LGraph graph) {
        this.graph = graph;
    }

    public List<Pair<LNode, LNode>> detect() {
        if (this.graph.getLayers().size() > 1) {
            this.detectCombinableNodes(true);
            this.detectCombinableNodes(false);
        }
        return this.pairsToCombine;
    }

    private void detectCombinableNodes(boolean searchForward) {
        this.forward = searchForward;
        this.visited.clear();
        this.graph.getNodesFromAllLayers().forEach(n -> this.detectFrom((LNode)n));
    }

    private void detectFrom(LNode node) {
        if (this.markVisited(node)) {
            this.detectFromNewNode(node);
        }
    }

    private boolean markVisited(LNode node) {
        if (!this.visited.contains(node)) {
            this.visited.add(node);
            return true;
        }
        return false;
    }

    private void detectFromNewNode(LNode node) {
        List<LNode> connectedNodesTopToBottom = this.getConnectedNodesTopToBottom(node);
        MesUtilMethods.getConsecutivePairsAsStream(connectedNodesTopToBottom).forEach(p -> this.tryToCombine((LNode)p.getFirst(), (LNode)p.getSecond(), node));
    }

    private List<LNode> getConnectedNodesTopToBottom(LNode node) {
        return node.getPortsSortedTopToBottom(this.forward ? PortSide.EAST : PortSide.WEST).stream().flatMap(p -> p.getConnectedNodes(this.forward).stream()).distinct().collect(Collectors.toList());
    }

    private void tryToCombine(LNode upperNode, LNode lowerNode, LNode previousNode) {
        if (this.shouldBeCombinedLookingBack(upperNode, lowerNode, previousNode)) {
            this.tryToCombineLookingForward(upperNode, lowerNode);
        }
    }

    private boolean shouldBeCombinedLookingBack(LNode upperNode, LNode lowerNode, LNode previousNode) {
        return this.arePotentiallyCombinable(upperNode, lowerNode, previousNode.getLayer()) && this.shouldBeCombinedBasedOnConnectionsToSameNode(upperNode, lowerNode, previousNode);
    }

    private boolean arePotentiallyCombinable(LNode upperNode, LNode lowerNode, Layer previousLayer) {
        return upperNode != null && lowerNode != null && this.isPotentiallyCombinable(upperNode, previousLayer) && this.isPotentiallyCombinable(lowerNode, previousLayer);
    }

    private boolean isPotentiallyCombinable(LNode node, Layer previousLayer) {
        return !node.isNorthSouthDummy() && node.getLayer().equals(previousLayer.getNextLayer(this.forward)) && node.getConnectedNodes(!this.forward).size() == 1;
    }

    private boolean shouldBeCombinedBasedOnConnectionsToSameNode(LNode upperNode, LNode lowerNode, LNode connectedNode) {
        List<LPort> upperPortsAtConnectedNode = upperNode.getConnectedPortsAt(connectedNode);
        List<LPort> lowerPortsAtConnectedNode = lowerNode.getConnectedPortsAt(connectedNode);
        return NodeCombinerDetector.haveOneConnectedNodeEach(upperPortsAtConnectedNode) && NodeCombinerDetector.haveOneConnectedNodeEach(lowerPortsAtConnectedNode) && NodeCombinerDetector.areDirectlyAbove(upperPortsAtConnectedNode, lowerPortsAtConnectedNode);
    }

    private static boolean haveOneConnectedNodeEach(List<LPort> ports) {
        return ports.stream().allMatch(p -> p.getConnectedNodes().size() == 1);
    }

    private static boolean areDirectlyAbove(List<LPort> a, List<LPort> b) {
        return NodeCombinerDetector.areAbove(a, b) && NodeCombinerDetector.noOtherPortsBetween(a, b);
    }

    private static boolean areAbove(List<LPort> a, List<LPort> b) {
        return NodeCombinerDetector.getMaxPosY(a) < NodeCombinerDetector.getMinPosY(b);
    }

    private static double getMaxPosY(List<LPort> ports) {
        return NodeCombinerDetector.getPosY(ports).max().getAsDouble();
    }

    private static double getMinPosY(List<LPort> ports) {
        return NodeCombinerDetector.getPosY(ports).min().getAsDouble();
    }

    private static DoubleStream getPosY(List<LPort> ports) {
        return ports.stream().mapToDouble(p -> p.getPosition().y);
    }

    private static boolean noOtherPortsBetween(List<LPort> upperPorts, List<LPort> lowerPorts) {
        LNode node = upperPorts.get(0).getNode();
        double minPosYOfUpperPorts = NodeCombinerDetector.getMinPosY(upperPorts);
        double maxPosYOfLowerPorts = NodeCombinerDetector.getMaxPosY(lowerPorts);
        PortSide side = upperPorts.get(0).getSide();
        return node.getPortsAsStream(side).allMatch(p -> upperPorts.contains(p) || lowerPorts.contains(p) || p.getPosition().y < minPosYOfUpperPorts || p.getPosition().y > maxPosYOfLowerPorts);
    }

    private void tryToCombineLookingForward(LNode upperNode, LNode lowerNode) {
        if (this.couldOrShouldBeCombinedLookingForward(upperNode, lowerNode)) {
            this.markAsCombined(upperNode, lowerNode);
            this.detectFrom(upperNode);
            this.detectFrom(lowerNode);
            this.tryToCombineNextNodes(upperNode, lowerNode);
        }
    }

    private boolean couldOrShouldBeCombinedLookingForward(LNode upperNode, LNode lowerNode) {
        return this.couldBeCombinedLookingForward(upperNode, lowerNode) || this.shouldBeCombinedLookingForward(upperNode, lowerNode);
    }

    private boolean couldBeCombinedLookingForward(LNode upperNode, LNode lowerNode) {
        return this.forwardNodesHaveNoOtherBackwardNodeInLayer(upperNode) && this.forwardNodesHaveNoOtherBackwardNodeInLayer(lowerNode);
    }

    private boolean forwardNodesHaveNoOtherBackwardNodeInLayer(LNode node) {
        List<LNode> forwardNodes = this.reachableNodesDetector.detect(node, this.forward);
        return forwardNodes.stream().noneMatch(n -> this.hasOtherBackwardNodeInLayer((LNode)n, node));
    }

    private boolean hasOtherBackwardNodeInLayer(LNode startNode, LNode node) {
        List<LNode> backwardNodes = this.reachableNodesDetector.detect(startNode, !this.forward);
        return backwardNodes.stream().anyMatch(n -> n != node && n.getLayer() == node.getLayer());
    }

    private boolean shouldBeCombinedLookingForward(LNode upperNode, LNode lowerNode) {
        if (NodeCombinerDetector.isLinearNode(upperNode) && NodeCombinerDetector.isLinearNode(lowerNode)) {
            LNode nextLowerNode;
            LNode nextUpperNode = upperNode.getConnectedNodes(this.forward).get(0);
            if (nextUpperNode == (nextLowerNode = lowerNode.getConnectedNodes(this.forward).get(0))) {
                return this.shouldBeCombinedBasedOnConnectionsToSameNode(upperNode, lowerNode, nextUpperNode);
            }
            return this.shouldBeCombinedLookingForward(nextUpperNode, nextLowerNode);
        }
        return false;
    }

    private static boolean isLinearNode(LNode node) {
        if (!node.isNorthSouthDummy() && !node.hasNorthSouthPort()) {
            List<LNode> connectedNodesForward = node.getConnectedNodes(true);
            List<LNode> connectedNodesBackward = node.getConnectedNodes(false);
            return connectedNodesForward.size() == 1 && connectedNodesBackward.size() == 1 && connectedNodesForward.get(0).isOneLayerNextTo(node, true) && connectedNodesBackward.get(0).isOneLayerNextTo(node, false);
        }
        return false;
    }

    private void markAsCombined(LNode upperNode, LNode lowerNode) {
        Pair<LNode, LNode> newPair = new Pair<LNode, LNode>(upperNode, lowerNode);
        if (!this.pairsToCombine.contains(newPair)) {
            this.pairsToCombine.add(newPair);
        }
    }

    private void tryToCombineNextNodes(LNode upperNode, LNode lowerNode) {
        LNode nextLowerNode;
        LNode nextUpperNode = this.getNextNodeToTryToCombine(upperNode, l -> (LNode)l.get(l.size() - 1));
        if (this.arePotentiallyCombinable(nextUpperNode, nextLowerNode = this.getNextNodeToTryToCombine(lowerNode, l -> (LNode)l.get(0)), upperNode.getLayer())) {
            this.tryToCombineLookingForward(nextUpperNode, nextLowerNode);
        }
    }

    private LNode getNextNodeToTryToCombine(LNode node, Function<List<LNode>, LNode> getFirstOrLast) {
        List<LNode> nextNodes = this.getConnectedNodesTopToBottom(node);
        if (nextNodes.size() == 1) {
            return nextNodes.get(0);
        }
        if (nextNodes.size() > 1 && this.allCombined(nextNodes)) {
            return getFirstOrLast.apply(nextNodes);
        }
        return null;
    }

    private boolean allCombined(List<LNode> nodes) {
        return nodes.stream().allMatch(n -> this.isCombined((LNode)n));
    }

    private boolean isCombined(LNode node) {
        return this.pairsToCombine.stream().anyMatch(p -> ((LNode)p.getFirst()).equals(node) || ((LNode)p.getSecond()).equals(node));
    }
}

