/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.p3order.mes;

import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.options.GreedySwitchType;
import com.modelengineers.MoRe_elk.alg.layered.options.LayeredOptions;
import com.modelengineers.MoRe_elk.alg.layered.p3order.LayerSweepCrossingMinimizer;
import com.modelengineers.MoRe_elk.alg.layered.p3order.mes.BinaryOrderProblem;
import com.modelengineers.MoRe_elk.alg.layered.p3order.mes.GraphSimplifier;
import com.modelengineers.MoRe_elk.alg.layered.p3order.mes.MesCrossingMinimizer;

public class MesCrossingMinimizerCaller {
    private static final double MEMORY_UPPER_LIMIT = 1500000.0;
    private LGraph graph;
    private GraphSimplifier graphSimplifier;

    public MesCrossingMinimizerCaller(LGraph layeredGraph) throws InterruptedException {
        this.graph = layeredGraph;
        this.graphSimplifier = new GraphSimplifier(this.graph);
        this.orderGraph();
    }

    private void orderGraph() throws InterruptedException {
        this.graphSimplifier.simplify();
        if (this.probablySufficientMemoryAvailable()) {
            this.tryCallingMesCrossingMinimizer();
            this.graphSimplifier.unsimplify(false);
        } else {
            this.orderGraphUsingHeuristic("Model would probably need too much memory.");
        }
    }

    private boolean probablySufficientMemoryAvailable() {
        return this.estimateMemoryConsumption() < 1500000.0;
    }

    private double estimateMemoryConsumption() {
        int powerForMemoryEstimation = 3;
        return this.graph.getLayers().stream().mapToDouble(layer -> Math.pow(layer.getNodes().size(), 3.0)).sum();
    }

    private void tryCallingMesCrossingMinimizer() throws InterruptedException {
        try {
            this.mesCrossingMinimization();
        }
        catch (BinaryOrderProblem.OrderProblemComplexityThresholdExceededException | OutOfMemoryError e) {
            this.orderGraphUsingHeuristic(e.getMessage());
        }
    }

    private void mesCrossingMinimization() throws InterruptedException {
        MesCrossingMinimizer minimizer = new MesCrossingMinimizer(this.graph);
        minimizer.order();
    }

    private void orderGraphUsingHeuristic(String optimizationBypassedInfo) {
        if (this.graph.loggingEnabled()) {
            System.out.println("MesCrossingMinimizer - Using heuristic P3 due to: " + optimizationBypassedInfo);
        }
        this.graphSimplifier.unsimplify(true);
        LayerSweepCrossingMinimizer singleComponentCrossingMinimizer = new LayerSweepCrossingMinimizer(LayerSweepCrossingMinimizer.CrossMinType.BARYCENTER);
        singleComponentCrossingMinimizer.orderNodesAndPorts(this.graph);
        this.orderGraphUsingGreedySwitch();
    }

    private void orderGraphUsingGreedySwitch() {
        if (this.graph.getProperty(LayeredOptions.CROSSING_MINIMIZATION_GREEDY_SWITCH_TYPE) != GreedySwitchType.OFF) {
            LayerSweepCrossingMinimizer singleComponentGreedySwitch = new LayerSweepCrossingMinimizer(LayerSweepCrossingMinimizer.CrossMinType.TWO_SIDED_GREEDY_SWITCH);
            singleComponentGreedySwitch.orderNodesAndPorts(this.graph);
        }
    }
}

