/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.p3order.mes;

import com.google.ortools.sat.Literal;
import com.modelengineers.MoRe_elk.alg.layered.ortools.CpSolverWrapper;
import com.modelengineers.MoRe_elk.alg.layered.p3order.mes.BinaryOrderProblem;
import com.modelengineers.MoRe_elk.alg.layered.p3order.mes.CEdge;
import com.modelengineers.MoRe_elk.alg.layered.p3order.mes.ICrossingObjectiveCore;

public class InterLayerCrossing
implements ICrossingObjectiveCore {
    private CEdge edgeA;
    private CEdge edgeB;
    private CrossingDirection direction;
    private BinaryOrderProblem orderProblem;
    private CpSolverWrapper solverWrapper;

    public InterLayerCrossing(CEdge edgeA, CEdge edgeB, CrossingDirection direction, BinaryOrderProblem orderProblem) {
        this.edgeA = edgeA;
        this.edgeB = edgeB;
        this.direction = direction;
        this.orderProblem = orderProblem;
        this.solverWrapper = orderProblem.getSolverWrapper();
    }

    @Override
    public boolean noObjectiveNeeded() {
        return this.edgeA.hasSameSourceAndTargetNodeAs(this.edgeB) || this.edgeA.hasCommonPortWith(this.edgeB);
    }

    @Override
    public Literal getLiteral() {
        Literal sourceABelowSourceB = this.orderProblem.sourceOfFirstEdgeIsBelowSourceOfSecondEdge(this.edgeA, this.edgeB);
        Literal targetABelowTargetB = this.orderProblem.targetOfFirstEdgeIsBelowTargetOfSecondEdge(this.edgeA, this.edgeB);
        return this.direction == CrossingDirection.UP_OR_DOWN ? this.getNormalCrossing(sourceABelowSourceB, targetABelowTargetB) : this.getUpDownCrossing(sourceABelowSourceB, targetABelowTargetB);
    }

    private Literal getNormalCrossing(Literal sourceABelowSourceB, Literal targetABelowTargetB) {
        return this.solverWrapper.xor(sourceABelowSourceB, targetABelowTargetB);
    }

    private Literal getUpDownCrossing(Literal sourceABelowSourceB, Literal targetABelowTargetB) {
        if (this.direction == CrossingDirection.UP) {
            return this.getUpCrossing(sourceABelowSourceB, targetABelowTargetB);
        }
        assert (this.direction == CrossingDirection.DOWN);
        return this.getDownCrossing(sourceABelowSourceB, targetABelowTargetB);
    }

    private Literal getUpCrossing(Literal sourceABelowSourceB, Literal targetABelowTargetB) {
        return this.solverWrapper.and(sourceABelowSourceB, targetABelowTargetB.not());
    }

    private Literal getDownCrossing(Literal sourceABelowSourceB, Literal targetABelowTargetB) {
        return this.solverWrapper.and(sourceABelowSourceB.not(), targetABelowTargetB);
    }

    static enum CrossingDirection {
        UP,
        DOWN,
        UP_OR_DOWN;

    }
}

