/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.p3order.mes;

import com.modelengineers.MoRe_elk.alg.layered.graph.LEdge;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.options.InternalProperties;
import com.modelengineers.MoRe_elk.core.options.PortSide;
import java.util.List;

public final class CEdge {
    private LEdge lEdge;

    public CEdge(LEdge lEdge) {
        this.lEdge = lEdge;
    }

    public int getNumCombinedEdges() {
        return Math.max(1, this.lEdge.getCombinedEdges().size());
    }

    public LPort getTargetSkippingLongEdges(boolean allCombinedNodesMustBeLongEdges) {
        return this.getPortSkippingLongEdges(this.lEdge, allCombinedNodesMustBeLongEdges, true);
    }

    private LPort getSourceSkippingLongEdges(boolean allCombinedNodesMustBeLongEdges) {
        return this.getPortSkippingLongEdges(this.lEdge, allCombinedNodesMustBeLongEdges, false);
    }

    private LPort getPortSkippingLongEdges(LEdge edge, boolean allCombinedNodesMustBeLongEdges, boolean forward) {
        LNode nextNode = edge.getNode(forward);
        return CEdge.isLongEdge(nextNode, allCombinedNodesMustBeLongEdges) ? this.getPortSkippingLongEdges(nextNode.getEdges(forward).get(0), allCombinedNodesMustBeLongEdges, forward) : edge.getPort(forward);
    }

    private static boolean isLongEdge(LNode node, boolean allCombinedNodesMustBeLongEdges) {
        if (allCombinedNodesMustBeLongEdges) {
            return node.getCombinedNodesOrNodeItself().stream().allMatch(n -> n.isLongEdge());
        }
        return node.getCombinedNodesOrNodeItself().stream().anyMatch(n -> n.isLongEdge());
    }

    public boolean isWideNodeInnerEdge() {
        return this.getSource().isWideNodeInnerPort();
    }

    public int getLeftLayerIndex() {
        return Math.min(this.getSourceNode().getLayer().getIndex(), this.getTargetNode().getLayer().getIndex());
    }

    public boolean isInLayerEdge() {
        return this.lEdge.isInLayerEdge();
    }

    public PortSide getInLayerSide() {
        return this.getSource().getSide();
    }

    public LPort getSource() {
        return this.lEdge.getSource();
    }

    public LPort getTarget() {
        return this.lEdge.getTarget();
    }

    public LNode getNode(boolean forward) {
        return forward ? this.getTargetNode() : this.getSourceNode();
    }

    public LNode getSourceNode() {
        return this.lEdge.getSourceNode();
    }

    public LNode getTargetNode() {
        return this.lEdge.getTargetNode();
    }

    public LNode getSourceNodeRespectingReversing() {
        return this.isReversed() ? this.getTargetNode() : this.getSourceNode();
    }

    private boolean isReversed() {
        return this.lEdge.getProperty(InternalProperties.REVERSED);
    }

    public boolean isSplit() {
        return this.getNumOfSplitEdges() > 1;
    }

    public int getNumOfSplitEdges() {
        if (this.isReversed()) {
            LPort targetPortSkippingLongEdge = this.getTargetSkippingLongEdges(true);
            return targetPortSkippingLongEdge.getIncomingEdges().size();
        }
        LPort sourcePortSkippingLongEdge = this.getSourceSkippingLongEdges(true);
        return sourcePortSkippingLongEdge.getOutgoingEdges().size();
    }

    public boolean hasSameSourceAndTargetNodeAs(CEdge edge) {
        return this.getSourceNode() == edge.getSourceNode() && this.getTargetNode() == edge.getTargetNode();
    }

    public boolean hasCommonPortWith(CEdge edge) {
        return this.getSource() == edge.getSource() || this.getSource() == edge.getTarget() || this.getTarget() == edge.getSource() || this.getTarget() == edge.getTarget();
    }

    public boolean isPartOfFeedbackLoop() {
        return !this.getFeedbackLoopIds().isEmpty();
    }

    public boolean isPartOfSameFeedbackLoopsAs(CEdge otherEdge) {
        List<Integer> feedbackLoopIdsOfOtherEdge = otherEdge.getFeedbackLoopIds();
        return this.getFeedbackLoopIds().stream().anyMatch(feedbackLoopIdsOfOtherEdge::contains);
    }

    private List<Integer> getFeedbackLoopIds() {
        return this.lEdge.getProperty(InternalProperties.FEEDBACK_LOOP_IDS);
    }

    public String toString() {
        return this.lEdge.toString();
    }
}

