/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.p3order.counting;

import com.modelengineers.MoRe_elk.alg.layered.graph.LEdge;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import java.util.List;

public interface IInitializable {
    public static void init(List<IInitializable> initializables, LNode[][] order) {
        int l = 0;
        while (l < order.length) {
            for (IInitializable i : initializables) {
                i.initAtLayerLevel(l, order);
            }
            int n = 0;
            while (n < order[l].length) {
                for (IInitializable i : initializables) {
                    i.initAtNodeLevel(l, n, order);
                }
                List<LPort> ports = order[l][n].getPorts();
                int p = 0;
                while (p < ports.size()) {
                    for (IInitializable i : initializables) {
                        i.initAtPortLevel(l, n, p, order);
                    }
                    LPort port = ports.get(p);
                    int e = 0;
                    for (LEdge edge : port.getConnectedEdges()) {
                        for (IInitializable i : initializables) {
                            i.initAtEdgeLevel(l, n, p, e++, edge, order);
                        }
                    }
                    ++p;
                }
                ++n;
            }
            ++l;
        }
        for (IInitializable i : initializables) {
            i.initAfterTraversal();
        }
    }

    default public void initAtLayerLevel(int l, LNode[][] nodeOrder) {
    }

    default public void initAtNodeLevel(int l, int n, LNode[][] nodeOrder) {
    }

    default public void initAtPortLevel(int l, int n, int p, LNode[][] nodeOrder) {
    }

    default public void initAtEdgeLevel(int l, int n, int p, int e, LEdge edge, LNode[][] nodeOrder) {
    }

    default public void initAfterTraversal() {
    }
}

