/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.p3order.counting;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.modelengineers.MoRe_elk.alg.layered.graph.LEdge;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.graph.Layer;
import com.modelengineers.MoRe_elk.core.options.PortSide;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;

public class HyperedgeCrossingsCounter {
    private final int[] portPos;

    public HyperedgeCrossingsCounter(int[] inLayerEdgeCount, boolean[] hasNorthSouthPorts, int[] portPos) {
        this.portPos = portPos;
    }

    /*
     * WARNING - void declaration
     */
    public int countCrossings(LNode[] leftLayer, LNode[] rightLayer) {
        void var14_58;
        void var14_57;
        int n;
        void var14_55;
        void var13_46;
        void var11_35;
        void var8_18;
        int sourceCount = 0;
        LNode[] lNodeArray = leftLayer;
        int n2 = leftLayer.length;
        int n22 = 0;
        while (n22 < n2) {
            LNode node = lNodeArray[n22];
            for (LPort lPort : node.getPorts()) {
                int portEdges = 0;
                for (LEdge lEdge : lPort.getOutgoingEdges()) {
                    if (node.getLayer() == lEdge.getTarget().getNode().getLayer()) continue;
                    ++portEdges;
                }
                if (portEdges <= 0) continue;
                this.portPos[lPort.id] = sourceCount++;
            }
            ++n22;
        }
        int targetCount = 0;
        LNode[] lNodeArray2 = rightLayer;
        int n3 = rightLayer.length;
        n2 = 0;
        while (n2 < n3) {
            LNode node = lNodeArray2[n2];
            int northInputPorts = 0;
            block12: for (LPort port : node.getPorts()) {
                if (port.getSide() != PortSide.NORTH) break;
                for (LEdge edge3 : port.getIncomingEdges()) {
                    if (node.getLayer() == edge3.getSource().getNode().getLayer()) continue;
                    ++northInputPorts;
                    continue block12;
                }
            }
            int otherInputPorts = 0;
            ListIterator<LPort> listIterator = node.getPorts().listIterator(node.getPorts().size());
            while (listIterator.hasPrevious()) {
                void var13_41;
                LPort port = listIterator.previous();
                boolean bl = false;
                for (LEdge lEdge : port.getIncomingEdges()) {
                    if (node.getLayer() == lEdge.getSource().getNode().getLayer()) continue;
                    ++var13_41;
                }
                if (var13_41 <= 0) continue;
                if (port.getSide() == PortSide.NORTH) {
                    this.portPos[port.id] = targetCount++;
                    continue;
                }
                this.portPos[port.id] = targetCount + northInputPorts + otherInputPorts;
                ++otherInputPorts;
            }
            targetCount += otherInputPorts;
            ++n2;
        }
        HashMap port2HyperedgeMap = Maps.newHashMap();
        LinkedHashSet hyperedgeSet = Sets.newLinkedHashSet();
        LNode[] otherInputPorts = leftLayer;
        int northInputPorts = leftLayer.length;
        boolean bl = false;
        while (var8_18 < northInputPorts) {
            LNode node = otherInputPorts[var8_18];
            for (LPort lPort : node.getPorts()) {
                for (LEdge lEdge : lPort.getOutgoingEdges()) {
                    LPort targetPort = lEdge.getTarget();
                    if (node.getLayer() == targetPort.getNode().getLayer()) continue;
                    Hyperedge sourceHE = (Hyperedge)port2HyperedgeMap.get(lPort);
                    Hyperedge targetHE = (Hyperedge)port2HyperedgeMap.get(targetPort);
                    if (sourceHE == null && targetHE == null) {
                        Hyperedge hyperedge = new Hyperedge();
                        hyperedgeSet.add(hyperedge);
                        hyperedge.edges.add(lEdge);
                        hyperedge.ports.add(lPort);
                        port2HyperedgeMap.put(lPort, hyperedge);
                        hyperedge.ports.add(targetPort);
                        port2HyperedgeMap.put(targetPort, hyperedge);
                        continue;
                    }
                    if (sourceHE == null) {
                        targetHE.edges.add(lEdge);
                        targetHE.ports.add(lPort);
                        port2HyperedgeMap.put(lPort, targetHE);
                        continue;
                    }
                    if (targetHE == null) {
                        sourceHE.edges.add(lEdge);
                        sourceHE.ports.add(targetPort);
                        port2HyperedgeMap.put(targetPort, sourceHE);
                        continue;
                    }
                    if (sourceHE == targetHE) {
                        sourceHE.edges.add(lEdge);
                        continue;
                    }
                    sourceHE.edges.add(lEdge);
                    for (LPort p : targetHE.ports) {
                        port2HyperedgeMap.put(p, sourceHE);
                    }
                    sourceHE.edges.addAll(targetHE.edges);
                    sourceHE.ports.addAll(targetHE.ports);
                    hyperedgeSet.remove(targetHE);
                }
            }
            ++var8_18;
        }
        Object[] hyperedges = hyperedgeSet.toArray(new Hyperedge[hyperedgeSet.size()]);
        Layer layer = leftLayer[0].getLayer();
        Layer rightLayerRef = rightLayer[0].getLayer();
        Object[] objectArray = hyperedges;
        int port = hyperedges.length;
        boolean bl2 = false;
        while (var11_35 < port) {
            Object he = objectArray[var11_35];
            ((Hyperedge)he).upperLeft = sourceCount;
            ((Hyperedge)he).upperRight = targetCount;
            for (LPort lPort : ((Hyperedge)he).ports) {
                int pos = this.portPos[lPort.id];
                if (lPort.getNode().getLayer() == layer) {
                    if (pos < ((Hyperedge)he).upperLeft) {
                        ((Hyperedge)he).upperLeft = pos;
                    }
                    if (pos <= ((Hyperedge)he).lowerLeft) continue;
                    ((Hyperedge)he).lowerLeft = pos;
                    continue;
                }
                if (lPort.getNode().getLayer() != rightLayerRef) continue;
                if (pos < ((Hyperedge)he).upperRight) {
                    ((Hyperedge)he).upperRight = pos;
                }
                if (pos <= ((Hyperedge)he).lowerRight) continue;
                ((Hyperedge)he).lowerRight = pos;
            }
            ++var11_35;
        }
        Arrays.sort(hyperedges);
        int[] southSequence = new int[hyperedges.length];
        int[] nArray = new int[targetCount + 1];
        int i = 0;
        while (i < hyperedges.length) {
            southSequence[i] = ((Hyperedge)hyperedges[i]).upperRight;
            nArray[southSequence[i]] = 1;
            ++i;
        }
        int delta = 0;
        boolean bl3 = false;
        while (var13_46 < nArray.length) {
            if (nArray[var13_46] == 1) {
                nArray[var13_46] = delta;
            } else {
                --delta;
            }
            ++var13_46;
        }
        boolean bl4 = false;
        boolean bl5 = false;
        while (var14_55 < southSequence.length) {
            void v0 = var14_55;
            southSequence[v0] = southSequence[v0] + nArray[southSequence[var14_55]];
            n = Math.max(n, southSequence[var14_55] + 1);
            ++var14_55;
        }
        boolean bl6 = true;
        while (var14_57 < n) {
            var14_57 *= 2;
        }
        int treeSize = 2 * var14_57 - 1;
        --var14_58;
        int[] tree = new int[treeSize];
        int crossings = 0;
        int k = 0;
        while (k < southSequence.length) {
            int index;
            int n4 = index = southSequence[k] + var14_58;
            tree[n4] = tree[n4] + 1;
            while (index > 0) {
                if (index % 2 > 0) {
                    crossings += tree[index + 1];
                }
                int n5 = index = (index - 1) / 2;
                tree[n5] = tree[n5] + 1;
            }
            ++k;
        }
        Object[] leftCorners = new HyperedgeCorner[hyperedges.length * 2];
        int i4 = 0;
        while (i4 < hyperedges.length) {
            leftCorners[2 * i4] = new HyperedgeCorner((Hyperedge)hyperedges[i4], ((Hyperedge)hyperedges[i4]).upperLeft, ((Hyperedge)hyperedges[i4]).lowerLeft, HyperedgeCorner.Type.UPPER);
            leftCorners[2 * i4 + 1] = new HyperedgeCorner((Hyperedge)hyperedges[i4], ((Hyperedge)hyperedges[i4]).lowerLeft, ((Hyperedge)hyperedges[i4]).upperLeft, HyperedgeCorner.Type.LOWER);
            ++i4;
        }
        Arrays.sort(leftCorners);
        int openHyperedges = 0;
        int i5 = 0;
        while (i5 < leftCorners.length) {
            switch (((HyperedgeCorner)leftCorners[i5]).type) {
                case UPPER: {
                    ++openHyperedges;
                    break;
                }
                case LOWER: {
                    crossings += --openHyperedges;
                }
            }
            ++i5;
        }
        Object[] rightCorners = new HyperedgeCorner[hyperedges.length * 2];
        int i6 = 0;
        while (i6 < hyperedges.length) {
            rightCorners[2 * i6] = new HyperedgeCorner((Hyperedge)hyperedges[i6], ((Hyperedge)hyperedges[i6]).upperRight, ((Hyperedge)hyperedges[i6]).lowerRight, HyperedgeCorner.Type.UPPER);
            rightCorners[2 * i6 + 1] = new HyperedgeCorner((Hyperedge)hyperedges[i6], ((Hyperedge)hyperedges[i6]).lowerRight, ((Hyperedge)hyperedges[i6]).upperRight, HyperedgeCorner.Type.LOWER);
            ++i6;
        }
        Arrays.sort(rightCorners);
        openHyperedges = 0;
        int i2 = 0;
        while (i2 < rightCorners.length) {
            switch (((HyperedgeCorner)rightCorners[i2]).type) {
                case UPPER: {
                    ++openHyperedges;
                    break;
                }
                case LOWER: {
                    crossings += --openHyperedges;
                }
            }
            ++i2;
        }
        return crossings;
    }

    private static class Hyperedge
    implements Comparable<Hyperedge> {
        private List<LEdge> edges = Lists.newArrayList();
        private List<LPort> ports = Lists.newArrayList();
        private int upperLeft;
        private int lowerLeft;
        private int upperRight;
        private int lowerRight;

        private Hyperedge() {
        }

        @Override
        public int compareTo(Hyperedge other) {
            if (this.upperLeft < other.upperLeft) {
                return -1;
            }
            if (this.upperLeft > other.upperLeft) {
                return 1;
            }
            if (this.upperRight < other.upperRight) {
                return -1;
            }
            if (this.upperRight > other.upperRight) {
                return 1;
            }
            return this.hashCode() - other.hashCode();
        }
    }

    private static class HyperedgeCorner
    implements Comparable<HyperedgeCorner> {
        private Hyperedge hyperedge;
        private int position;
        private int oppositePosition;
        private Type type;

        HyperedgeCorner(Hyperedge hyperedge, int position, int oppositePosition, Type type) {
            this.hyperedge = hyperedge;
            this.position = position;
            this.oppositePosition = oppositePosition;
            this.type = type;
        }

        @Override
        public int compareTo(HyperedgeCorner other) {
            if (this.position < other.position) {
                return -1;
            }
            if (this.position > other.position) {
                return 1;
            }
            if (this.oppositePosition < other.oppositePosition) {
                return -1;
            }
            if (this.oppositePosition > other.oppositePosition) {
                return 1;
            }
            if (this.hyperedge != other.hyperedge) {
                return this.hyperedge.hashCode() - other.hyperedge.hashCode();
            }
            if (this.type == Type.UPPER && other.type == Type.LOWER) {
                return -1;
            }
            if (this.type == Type.LOWER && other.type == Type.UPPER) {
                return 1;
            }
            return 0;
        }

        static enum Type {
            UPPER,
            LOWER;

        }
    }
}

