/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.p3order;

import com.google.common.collect.Lists;
import com.modelengineers.MoRe_elk.alg.layered.graph.Component;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.graph.Layer;
import com.modelengineers.MoRe_elk.alg.layered.options.InternalProperties;
import java.util.ArrayList;
import java.util.List;

public class SeparateComponentDetector {
    private LGraph graph;

    public SeparateComponentDetector(LGraph graph) {
        this.graph = graph;
    }

    public List<Component> getComponents() {
        List<List<LNode>> nodesOfComponents = this.getNodesOfComponents();
        ArrayList components = Lists.newArrayList();
        for (List<LNode> nodesOfComponent : nodesOfComponents) {
            components.add(SeparateComponentDetector.createComponent(this.graph, nodesOfComponent));
        }
        return components;
    }

    private List<List<LNode>> getNodesOfComponents() {
        List<LNode> nodesOfGraph = this.graph.getNodesFromAllLayers();
        nodesOfGraph.forEach(node -> {
            int n = node.id = 0;
        });
        ArrayList nodesOfComponents = Lists.newArrayList();
        for (LNode node2 : nodesOfGraph) {
            List<LNode> nodesOfComponent = SeparateComponentDetector.getNodesOfComponentAndMarkNodesAsVisited(node2);
            if (nodesOfComponent.isEmpty()) continue;
            nodesOfComponents.add(nodesOfComponent);
        }
        return nodesOfComponents;
    }

    private static List<LNode> getNodesOfComponentAndMarkNodesAsVisited(LNode nodeInComponent) {
        ArrayList nodesOfComponent = Lists.newArrayList();
        SeparateComponentDetector.dfs(nodeInComponent, nodesOfComponent);
        return nodesOfComponent;
    }

    private static void dfs(LNode node, List<LNode> nodesOfComponent) {
        if (node.id == 0) {
            node.id = 1;
            nodesOfComponent.add(node);
            for (LNode connNode : SeparateComponentDetector.getAllConnectedNodes(node)) {
                SeparateComponentDetector.dfs(connNode, nodesOfComponent);
            }
        }
    }

    private static List<LNode> getAllConnectedNodes(LNode node) {
        ArrayList<LNode> connectedNodes = new ArrayList<LNode>();
        for (LPort port1 : node.getPorts()) {
            for (LPort port2 : port1.getConnectedPorts()) {
                connectedNodes.add(port2.getNode());
            }
            LNode northSouthNode = port1.getProperty(InternalProperties.PORT_DUMMY);
            if (northSouthNode == null) continue;
            connectedNodes.add(northSouthNode);
        }
        if (node.getType() == LNode.NodeType.NORTH_SOUTH_PORT) {
            connectedNodes.add((LNode)node.getProperty(InternalProperties.ORIGIN));
        }
        return connectedNodes;
    }

    private static Component createComponent(LGraph graph, List<LNode> nodesOfComponent) {
        Component component = new Component(graph);
        SeparateComponentDetector.addNodesToComponent(component, nodesOfComponent);
        graph.getComponents().add(component);
        return component;
    }

    private static void addNodesToComponent(Component component, List<LNode> nodesOfComponent) {
        for (LNode node : nodesOfComponent) {
            if (node.isWideNode()) {
                LNode originWideNode = node.getOriginalWideNode();
                if (!component.getNodes().contains(originWideNode)) {
                    SeparateComponentDetector.addNodeToComponent(component, originWideNode);
                }
            }
            SeparateComponentDetector.addNodeToComponent(component, node);
        }
    }

    private static void addNodeToComponent(Component component, LNode node) {
        if (node.getNestedGraph() != null) {
            List<LNode> nodesInNestedGraph = SeparateComponentDetector.getNodesInNestedGraph(node.getNestedGraph());
            SeparateComponentDetector.addNodesToComponent(component, nodesInNestedGraph);
        }
        node.setComponent(component);
    }

    private static List<LNode> getNodesInNestedGraph(LGraph nestedGraph) {
        ArrayList nodesInNestedGraph = Lists.newArrayList();
        for (Layer layer : nestedGraph.getLayers()) {
            nodesInNestedGraph.addAll(layer.getNodes());
        }
        return nodesInNestedGraph;
    }
}

