/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.p3order;

import com.modelengineers.MoRe_elk.alg.layered.LayeredPhases;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.intermediate.IntermediateProcessorStrategy;
import com.modelengineers.MoRe_elk.alg.layered.options.GreedySwitchType;
import com.modelengineers.MoRe_elk.alg.layered.options.LayeredOptions;
import com.modelengineers.MoRe_elk.alg.layered.p3order.LGraphSplitter;
import com.modelengineers.MoRe_elk.alg.layered.p3order.LayerSweepCrossingMinimizer;
import com.modelengineers.MoRe_elk.alg.layered.p3order.SeparateComponentSorter;
import com.modelengineers.MoRe_elk.alg.layered.p3order.mes.MesCrossingMinimizerCaller;
import com.modelengineers.MoRe_elk.core.alg.ILayoutPhase;
import com.modelengineers.MoRe_elk.core.alg.LayoutProcessorConfiguration;
import com.modelengineers.MoRe_elk.core.util.IElkProgressMonitor;
import java.util.List;

public class SeparateComponentCrossingMinimizer
implements ILayoutPhase<LayeredPhases, LGraph> {
    private LGraphSplitter graphSplitter;
    private List<LGraph> unsortedComponents;
    private List<LGraph> sortedComponents;
    private static final LayoutProcessorConfiguration<LayeredPhases, LGraph> INTERMEDIATE_PROCESSING_CONFIGURATION = LayoutProcessorConfiguration.create().addBefore(LayeredPhases.P3_NODE_ORDERING, IntermediateProcessorStrategy.LONG_EDGE_SPLITTER).addBefore(LayeredPhases.P4_NODE_PLACEMENT, IntermediateProcessorStrategy.IN_LAYER_CONSTRAINT_PROCESSOR).after(LayeredPhases.P5_EDGE_ROUTING).add(IntermediateProcessorStrategy.LONG_EDGE_JOINER);

    @Override
    public void process(LGraph graph, IElkProgressMonitor progressMonitor) throws InterruptedException {
        progressMonitor.begin("Minimize crossings component by component ", 1.0f);
        this.splitIntoComponents(graph);
        this.orderComponents(progressMonitor);
        this.sortComponents();
        this.updateOrderOfWholeGraph();
        this.changeOrderOfPortBlocksToReduceUnwantedCrossings(graph);
        progressMonitor.done();
    }

    private void splitIntoComponents(LGraph graph) {
        this.graphSplitter = new LGraphSplitter(graph);
        this.unsortedComponents = this.graphSplitter.split();
    }

    private void orderComponents(IElkProgressMonitor progressMonitor) throws InterruptedException {
        for (LGraph comp : this.unsortedComponents) {
            this.order(comp, progressMonitor);
        }
    }

    private void order(LGraph component, IElkProgressMonitor progressMonitor) throws InterruptedException {
        new MesCrossingMinimizerCaller(component);
    }

    private void sortComponents() {
        this.sortedComponents = new SeparateComponentSorter(this.unsortedComponents).sort();
    }

    private void updateOrderOfWholeGraph() {
        this.sortedComponents.forEach(c -> this.graphSplitter.moveNodesBackToOriginalGraph((LGraph)c));
    }

    private void changeOrderOfPortBlocksToReduceUnwantedCrossings(LGraph graph) {
        if (graph.getProperty(LayeredOptions.CROSSING_MINIMIZATION_GREEDY_SWITCH_TYPE) != GreedySwitchType.OFF) {
            new LayerSweepCrossingMinimizer(null).orderFirstAndLastSeparateLayer(graph);
        }
    }

    @Override
    public LayoutProcessorConfiguration<LayeredPhases, LGraph> getLayoutProcessorConfiguration(LGraph graph) {
        LayoutProcessorConfiguration<LayeredPhases, LGraph> configuration = LayoutProcessorConfiguration.createFrom(INTERMEDIATE_PROCESSING_CONFIGURATION);
        configuration.addBefore(LayeredPhases.P1_CYCLE_BREAKING, IntermediateProcessorStrategy.FEEDBACK_LOOP_PROCESSOR);
        configuration.addBefore(LayeredPhases.P3_NODE_ORDERING, IntermediateProcessorStrategy.PORT_LIST_SORTER);
        return configuration;
    }
}

