/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.p3order;

import com.modelengineers.MoRe_elk.alg.layered.graph.Component;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.Layer;
import com.modelengineers.MoRe_elk.alg.layered.p3order.SeparateComponentDetector;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class LGraphSplitter {
    private LGraph graph;
    private Map<Layer, Layer> originalLayer = new HashMap<Layer, Layer>();

    public LGraphSplitter(LGraph graph) {
        this.graph = graph;
    }

    public List<LGraph> split() {
        return this.getComponents().stream().map(c -> this.buildComponentGraph((Component)c)).collect(Collectors.toList());
    }

    private List<Component> getComponents() {
        return new SeparateComponentDetector(this.graph).getComponents();
    }

    private LGraph buildComponentGraph(Component component) {
        LGraph newGraph = new LGraph();
        newGraph.getComponents().add(component);
        newGraph.copyProperties(this.graph);
        this.moveNodesOfComponentToGraph(component, newGraph);
        return newGraph;
    }

    private void moveNodesOfComponentToGraph(Component component, LGraph newGraph) {
        for (Layer layer : this.graph.getLayers()) {
            List<LNode> layerNodesInComponent = layer.getNodes().stream().filter(component.getNodes()::contains).collect(Collectors.toList());
            if (layerNodesInComponent.isEmpty()) continue;
            Layer layerOfNewGraph = new Layer(newGraph);
            this.originalLayer.put(layerOfNewGraph, layer);
            LGraphSplitter.moveNodesToLayer(layerNodesInComponent, layerOfNewGraph);
            newGraph.getLayers().add(layerOfNewGraph);
        }
    }

    private static void moveNodesToLayer(List<LNode> nodesInOldLayer, Layer newLayer) {
        while (!nodesInOldLayer.isEmpty()) {
            LNode node = nodesInOldLayer.get(0);
            LGraphSplitter.moveNodeToLayer(node, newLayer);
            nodesInOldLayer.remove(node);
        }
    }

    private static void moveNodeToLayer(LNode node, Layer newLayer) {
        node.setLayer(null);
        node.setGraph(newLayer.getGraph());
        node.setLayer(newLayer);
    }

    public void moveNodesBackToOriginalGraph(LGraph component) {
        component.getLayers().forEach(l -> LGraphSplitter.moveNodesToLayer(l.getNodes(), this.originalLayer.get(l)));
    }
}

