/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.p2layers.mes;

import com.google.ortools.linearsolver.MPVariable;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.mesutils.MesUtilMethods;
import com.modelengineers.MoRe_elk.alg.layered.options.LayeredOptions;
import com.modelengineers.MoRe_elk.alg.layered.ortools.MPSolverWrapperInt;
import com.modelengineers.MoRe_elk.alg.layered.p2layers.mes.FinalLayeringProblem;
import com.modelengineers.MoRe_elk.core.options.Alignment;
import com.modelengineers.MoRe_elk.core.options.PortSide;
import java.util.List;
import java.util.stream.Collectors;

public class SimilarNodesShouldBeInSimilarLayersObjectives {
    private static final double COEFF_SIMILAR_NODES_IN_SIMILAR_LAYERS = 40000.0;
    private FinalLayeringProblem finalLayeringProblem;
    private List<LNode> nodes;
    private MPSolverWrapperInt solver;
    private LNode maxSimilarNode;
    private double maxSimilarity;

    public SimilarNodesShouldBeInSimilarLayersObjectives(FinalLayeringProblem finalLayeringProblem, List<LNode> nodes, MPSolverWrapperInt solver) throws InterruptedException {
        this.finalLayeringProblem = finalLayeringProblem;
        this.nodes = nodes;
        this.solver = solver;
        this.similarNodesShouldBeInSimilarLayers();
    }

    private void similarNodesShouldBeInSimilarLayers() throws InterruptedException {
        int ixNode = 0;
        while (ixNode < this.nodes.size() - 1) {
            MesUtilMethods.checkInterrupt();
            LNode node = this.nodes.get(ixNode);
            if (SimilarNodesShouldBeInSimilarLayersObjectives.isNodeToAlign(node)) {
                this.maxSimilarRemainingNodeShouldBeInSameLayer(node, ixNode);
            }
            ++ixNode;
        }
    }

    private void maxSimilarRemainingNodeShouldBeInSameLayer(LNode node, int ixNode) {
        this.determineMaxSimilarNodeInRemainingNodes(node, ixNode);
        if (this.maxSimilarity > 0.0) {
            MPVariable absLayerDiff = this.solver.makeAbsDiffVar(this.finalLayeringProblem.getLayer(node), this.finalLayeringProblem.getLayer(this.maxSimilarNode));
            this.solver.setObjectiveCoeff(absLayerDiff, 40000.0 * this.maxSimilarity);
        }
    }

    private void determineMaxSimilarNodeInRemainingNodes(LNode node, int ixNode) {
        this.maxSimilarNode = null;
        this.maxSimilarity = 0.0;
        int ixCurrentNode = ixNode + 1;
        while (ixCurrentNode < this.nodes.size()) {
            double currentSimilarity;
            LNode currentNode = this.nodes.get(ixCurrentNode);
            if (SimilarNodesShouldBeInSimilarLayersObjectives.isNodeToAlign(currentNode) && (currentSimilarity = this.getNodeSimilarity(node, currentNode)) > this.maxSimilarity) {
                this.maxSimilarNode = currentNode;
                this.maxSimilarity = currentSimilarity;
            }
            ++ixCurrentNode;
        }
    }

    private static boolean isNodeToAlign(LNode node) {
        return !node.isFirstSeparate() && !node.isLastSeparate() && (!node.isWideNode() || SimilarNodesShouldBeInSimilarLayersObjectives.isFirstWideNodeToAlignLeft(node) || SimilarNodesShouldBeInSimilarLayersObjectives.isLastWideNodeToAlignRight(node));
    }

    private static boolean isFirstWideNodeToAlignLeft(LNode node) {
        return node.getProperty(LayeredOptions.ALIGNMENT).equals((Object)Alignment.LEFT) && node.isFirstNonLabelWideNodeDummy();
    }

    private static boolean isLastWideNodeToAlignRight(LNode node) {
        return node.getProperty(LayeredOptions.ALIGNMENT).equals((Object)Alignment.RIGHT) && node.isLastNonLabelWideNodeDummy();
    }

    private double getNodeSimilarity(LNode a, LNode b) {
        double similarity = 1.0;
        similarity *= this.getLayerSimilarity(a, b);
        similarity *= this.getDataFlowSimilarity(a, b);
        similarity *= SimilarNodesShouldBeInSimilarLayersObjectives.getBlockTypeSimilarity(a, b);
        similarity *= SimilarNodesShouldBeInSimilarLayersObjectives.getWidthSimilarity(a, b);
        similarity *= Math.pow(SimilarNodesShouldBeInSimilarLayersObjectives.getHeightSimilarity(a, b), 0.25);
        similarity *= Math.pow(SimilarNodesShouldBeInSimilarLayersObjectives.getNumWestPortsSimilarity(a, b), 0.5);
        similarity *= SimilarNodesShouldBeInSimilarLayersObjectives.getNumTopPortsSimilarity(a, b);
        return similarity *= SimilarNodesShouldBeInSimilarLayersObjectives.getFlippedNodeSimilarity(a, b);
    }

    private double getLayerSimilarity(LNode a, LNode b) {
        if (this.areSourceEndNodesWithDifferentTargetsAndTooLittleOverlap(a, b)) {
            return 0.0;
        }
        return this.getLayerSimilarityForOtherNodes(a, b);
    }

    private boolean areSourceEndNodesWithDifferentTargetsAndTooLittleOverlap(LNode a, LNode b) {
        return SimilarNodesShouldBeInSimilarLayersObjectives.areSourceEndNodesWithDifferentTargets(a, b) && this.getOverlapPercentage(a, b) < 60.0;
    }

    private double getOverlapPercentage(LNode a, LNode b) {
        int leftA = this.getLayerWithoutSimilarity(a.getFirstWideNodeDummy());
        int rightA = this.getLayerWithoutSimilarity(a.getLastWideNodeDummy());
        int leftB = this.getLayerWithoutSimilarity(b.getFirstWideNodeDummy());
        int rightB = this.getLayerWithoutSimilarity(b.getLastWideNodeDummy());
        return SimilarNodesShouldBeInSimilarLayersObjectives.getOverlapPercentage(leftA, rightA, leftB, rightB);
    }

    private static double getOverlapPercentage(int leftA, int rightA, int leftB, int rightB) {
        int maxLeft = Math.max(leftA, leftB);
        int minRight = Math.min(rightA, rightB);
        if (minRight < maxLeft) {
            return 0.0;
        }
        int overlapLength = minRight - maxLeft + 1;
        return (double)overlapLength / (double)Math.min(rightA - leftA + 1, rightB - leftB + 1) * 100.0;
    }

    private double getLayerSimilarityForOtherNodes(LNode a, LNode b) {
        double relLayerDiff = this.getRelativeLayerDiff(a, b);
        if (relLayerDiff <= 0.0) {
            return 1.0;
        }
        if (relLayerDiff == 1.0) {
            return 0.9;
        }
        if (relLayerDiff == 2.0) {
            return 0.8;
        }
        if (relLayerDiff == 3.0) {
            return 0.6;
        }
        if (relLayerDiff == 4.0) {
            return 0.4;
        }
        if (relLayerDiff == 5.0) {
            return 0.15;
        }
        return 0.05;
    }

    private double getRelativeLayerDiff(LNode a, LNode b) {
        double relLayerDiff;
        int layerA = this.getLayerWithoutSimilarity(a);
        int layerB = this.getLayerWithoutSimilarity(b);
        int absLayerDiff = Math.abs(layerA - layerB);
        if (SimilarNodesShouldBeInSimilarLayersObjectives.areSourceEndNodesWithDifferentTargets(a, b)) {
            relLayerDiff = absLayerDiff;
        } else {
            long minNumWideNodes = Math.min(a.getNumNonLabelWideNodeDummies(), b.getNumNonLabelWideNodeDummies());
            relLayerDiff = (long)absLayerDiff - (minNumWideNodes - 1L);
        }
        return relLayerDiff;
    }

    private static boolean areSourceEndNodesWithDifferentTargets(LNode a, LNode b) {
        return SimilarNodesShouldBeInSimilarLayersObjectives.isSourceEndNode(a) && SimilarNodesShouldBeInSimilarLayersObjectives.isSourceEndNode(b) && !a.getTrueTargetNodes().equals(b.getTrueTargetNodes());
    }

    private static boolean isSourceEndNode(LNode node) {
        return !node.hasTrueSourceNodes() && node.hasTrueTargetNodes();
    }

    private double getDataFlowSimilarity(LNode a, LNode b) {
        List<LNode> targetNodesA = a.getTrueTargetNodes();
        List<LNode> targetNodesB = b.getTrueTargetNodes();
        if (targetNodesA.contains(b) || targetNodesB.contains(a)) {
            return 0.0;
        }
        if (SimilarNodesShouldBeInSimilarLayersObjectives.areSourceEndNodesToAlign(a, b, targetNodesA, targetNodesB)) {
            return 1.0;
        }
        if (this.areSourceEndNodesConnectedToCascadingNodes(a, b, targetNodesA, targetNodesB)) {
            return 0.0;
        }
        if (this.areSingleFlippedNodesInFeedbackLoopsThatShouldNotBeAligned(a, b)) {
            return 0.0;
        }
        return 0.1;
    }

    private static boolean areSourceEndNodesToAlign(LNode a, LNode b, List<LNode> targetNodesA, List<LNode> targetNodesB) {
        return SimilarNodesShouldBeInSimilarLayersObjectives.isSourceEndNode(a) && SimilarNodesShouldBeInSimilarLayersObjectives.isSourceEndNode(b) && targetNodesA.equals(targetNodesB) && SimilarNodesShouldBeInSimilarLayersObjectives.hasOutgoingEdgeLabel(a) == SimilarNodesShouldBeInSimilarLayersObjectives.hasOutgoingEdgeLabel(b);
    }

    private static boolean hasOutgoingEdgeLabel(LNode node) {
        return node.getLastWideNodeDummy().getOutgoingEdgesAsList().stream().anyMatch(e -> e.getSource().labelWasRemovedByLabelMerger());
    }

    private boolean areSourceEndNodesConnectedToCascadingNodes(LNode a, LNode b, List<LNode> targetNodesA, List<LNode> targetNodesB) {
        return SimilarNodesShouldBeInSimilarLayersObjectives.isSourceEndNode(a) && SimilarNodesShouldBeInSimilarLayersObjectives.isSourceEndNode(b) && (SimilarNodesShouldBeInSimilarLayersObjectives.getTrueTargetNodes(targetNodesA).containsAll(targetNodesB) || SimilarNodesShouldBeInSimilarLayersObjectives.getTrueTargetNodes(targetNodesB).containsAll(targetNodesA));
    }

    private static List<LNode> getTrueTargetNodes(List<LNode> nodes) {
        return nodes.stream().flatMap(n -> n.getTrueTargetNodes().stream()).collect(Collectors.toList());
    }

    private boolean areSingleFlippedNodesInFeedbackLoopsThatShouldNotBeAligned(LNode a, LNode b) {
        int layerA = this.getLayerWithoutSimilarity(a);
        int layerB = this.getLayerWithoutSimilarity(b);
        return a.isSingleFlippedNodeInFeedbackLoop() && b.isSingleFlippedNodeInFeedbackLoop() && (layerA > this.getMinLayerWithoutSimilarityOfSourceNodes(b) || layerB > this.getMinLayerWithoutSimilarityOfSourceNodes(a));
    }

    private int getMinLayerWithoutSimilarityOfSourceNodes(LNode node) {
        return node.getTrueSourceNodes().stream().mapToInt(s -> this.getLayerWithoutSimilarity((LNode)s)).min().getAsInt();
    }

    public int getLayerWithoutSimilarity(LNode node) {
        return this.finalLayeringProblem.getLayerWithoutSimilarity(node);
    }

    private static double getBlockTypeSimilarity(LNode a, LNode b) {
        String blockTypeB;
        String blockTypeA = SimilarNodesShouldBeInSimilarLayersObjectives.getBlockType(a);
        if (!blockTypeA.equals(blockTypeB = SimilarNodesShouldBeInSimilarLayersObjectives.getBlockType(b))) {
            return 0.15;
        }
        if ((blockTypeA.equals("Goto") || blockTypeA.equals("From")) && !a.getTrueConnectedNodes().equals(b.getTrueConnectedNodes())) {
            return 0.15;
        }
        return 1.0;
    }

    private static String getBlockType(LNode node) {
        String origBlockType = node.getMesBlockParam("BlockType");
        if (origBlockType == null) {
            return "";
        }
        if (origBlockType.equals("Reference")) {
            return "SubSystem";
        }
        return origBlockType;
    }

    private static double getWidthSimilarity(LNode a, LNode b) {
        double widthA = a.getOrigin().getWidth();
        double widthB = b.getOrigin().getWidth();
        return SimilarNodesShouldBeInSimilarLayersObjectives.getSimilarity(widthA, widthB);
    }

    private static double getHeightSimilarity(LNode a, LNode b) {
        double widthA = a.getOrigin().getHeight();
        double widthB = b.getOrigin().getHeight();
        return SimilarNodesShouldBeInSimilarLayersObjectives.getSimilarity(widthA, widthB);
    }

    private static double getNumWestPortsSimilarity(LNode a, LNode b) {
        double numPortsA = SimilarNodesShouldBeInSimilarLayersObjectives.getCountForWestPortsSimilarity(a);
        double numPortsB = SimilarNodesShouldBeInSimilarLayersObjectives.getCountForWestPortsSimilarity(b);
        return SimilarNodesShouldBeInSimilarLayersObjectives.getSimilarity(numPortsA, numPortsB);
    }

    private static double getCountForWestPortsSimilarity(LNode node) {
        double numWestPorts = node.getFirstWideNodeDummy().getNumWestPorts();
        if (numWestPorts == 0.0 && node.hasTruePorts(PortSide.NORTH)) {
            numWestPorts += 0.5;
        }
        return numWestPorts;
    }

    private static double getSimilarity(double a, double b) {
        assert (a >= 0.0);
        assert (b >= 0.0);
        if (Math.max(a, b) == 0.0) {
            return 1.0;
        }
        return 1.0 - Math.abs((a - b) / Math.max(a, b));
    }

    private static double getNumTopPortsSimilarity(LNode a, LNode b) {
        boolean hasTopPortsB;
        boolean hasTopPortsA = a.hasTruePorts(PortSide.NORTH);
        if (hasTopPortsA ^ (hasTopPortsB = b.hasTruePorts(PortSide.NORTH))) {
            return 0.5;
        }
        return 1.0;
    }

    private static double getFlippedNodeSimilarity(LNode a, LNode b) {
        if (SimilarNodesShouldBeInSimilarLayersObjectives.isLeftRightNode(a) && SimilarNodesShouldBeInSimilarLayersObjectives.isRightLeftNode(b) || SimilarNodesShouldBeInSimilarLayersObjectives.isRightLeftNode(a) && SimilarNodesShouldBeInSimilarLayersObjectives.isLeftRightNode(b)) {
            return 0.0;
        }
        return 1.0;
    }

    private static boolean isLeftRightNode(LNode node) {
        List<LPort> westPorts = node.getTruePorts(PortSide.WEST);
        List<LPort> eastPorts = node.getTruePorts(PortSide.EAST);
        return (westPorts.stream().anyMatch(LPort::hasIncomingEdges) || eastPorts.stream().anyMatch(LPort::hasOutgoingEdges)) && westPorts.stream().noneMatch(LPort::hasOutgoingEdges) && eastPorts.stream().noneMatch(LPort::hasIncomingEdges);
    }

    private static boolean isRightLeftNode(LNode node) {
        List<LPort> westPorts = node.getTruePorts(PortSide.WEST);
        List<LPort> eastPorts = node.getTruePorts(PortSide.EAST);
        return (westPorts.stream().anyMatch(LPort::hasOutgoingEdges) || eastPorts.stream().anyMatch(LPort::hasIncomingEdges)) && westPorts.stream().noneMatch(LPort::hasIncomingEdges) && eastPorts.stream().noneMatch(LPort::hasOutgoingEdges);
    }
}

