/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.p2layers.mes;

import com.google.common.collect.Lists;
import com.modelengineers.MoRe_elk.alg.layered.graph.LEdge;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.p2layers.mes.LayerBasedOnOrderProblem;
import com.modelengineers.MoRe_elk.core.options.PortSide;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class SatelliteAndBaseNodesConstraints {
    private static final double SATELLITE_WIDTH_THRESHOLD = 37.0;
    private static final double MIN_VERTICAL_NODE_NODE_SPACING = 5.0;
    private List<LNode> nodes;
    private LayerBasedOnOrderProblem layerBasedOnOrderProblem;
    private Map<LNode, Boolean> isSatellite = new HashMap<LNode, Boolean>();
    private List<LNode> remainingNonSatellites;
    private List<LNode> nonSatellitesToBeDistanced = Lists.newArrayList();
    private List<LNode> nonSatellitesNotToBeDistanced = Lists.newArrayList();
    private List<LNode> satellites;
    private List<LNode> nodesInAdjLayerOfBase = Lists.newArrayList();
    private List<LPort> portsOfBaseOnSatSide;
    private LNode base;
    private PortSide portSideOfBase;
    private PortSide portSideOfSatellite;
    private int maxWideNodeDummiesInSatellites;
    private List<LNode> nodesLeftFromBaseInRangeOfMaxWideNodeDummies;

    public SatelliteAndBaseNodesConstraints(LayerBasedOnOrderProblem layerBasedOnOrderProblem, List<LNode> nodes) {
        this.layerBasedOnOrderProblem = layerBasedOnOrderProblem;
        this.nodes = nodes;
        this.setConstraintsForSatellitesAndNonSatellites();
    }

    private void setConstraintsForSatellitesAndNonSatellites() {
        this.determineSatellites();
        this.getBaseNodes().forEach(n -> this.setConstraintsForNonSatellites((LNode)n));
    }

    private void determineSatellites() {
        this.nodes.forEach(n -> {
            Boolean bl = this.isSatellite.put((LNode)n, this.determineSatellite((LNode)n));
        });
    }

    private boolean determineSatellite(LNode node) {
        return SatelliteAndBaseNodesConstraints.hasPortsOnEastXorWestSide(node) && SatelliteAndBaseNodesConstraints.isConnectedToOnlyOneOtherNode(node) && this.noOtherPortBetweenConnectedTargetPorts(node) && SatelliteAndBaseNodesConstraints.allConnectedEdgesHaveInAndOutportOnOppositeSides(node) && !node.isSeparate();
    }

    private static boolean hasPortsOnEastXorWestSide(LNode node) {
        return SatelliteAndBaseNodesConstraints.allPortsAreOnSameSide(node) && SatelliteAndBaseNodesConstraints.isEastOrWestPort(node);
    }

    private static boolean allPortsAreOnSameSide(LNode node) {
        return node.getTruePorts().stream().map(n -> n.getSide()).distinct().count() == 1L;
    }

    private static boolean isEastOrWestPort(LNode node) {
        PortSide portSide = node.getTruePorts().get(0).getSide();
        return PortSide.isEastWest(portSide);
    }

    private static boolean isConnectedToOnlyOneOtherNode(LNode node) {
        return node.getTrueConnectedNodes().size() == 1;
    }

    private boolean noOtherPortBetweenConnectedTargetPorts(LNode node) {
        int[] ixOfConnectedPorts = node.getTrueConnectedPorts().stream().mapToInt(p -> p.getTrueSideIndex()).distinct().sorted().toArray();
        int i = 0;
        while (i < ixOfConnectedPorts.length - 1) {
            if (ixOfConnectedPorts[i + 1] - ixOfConnectedPorts[i] != 1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean allConnectedEdgesHaveInAndOutportOnOppositeSides(LNode node) {
        PortSide portSide = node.getTruePorts().get(0).getSide();
        return node.getTruePorts().stream().allMatch(p -> p.hasEdges() && !portSide.equals((Object)p.getFirstConnectedPort().getSide()));
    }

    private Stream<LNode> getBaseNodes() {
        return this.nodes.stream().filter(n -> n.isFirstWideNodeDummyOrNonWideNode() && this.isConnectedToSatellite((LNode)n));
    }

    private boolean isConnectedToSatellite(LNode node) {
        return node.getTrueConnectedNodes().stream().anyMatch(n -> this.isSatellite((LNode)n));
    }

    private boolean isSatellite(LNode node) {
        return this.isSatellite.get(node);
    }

    private void setConstraintsForNonSatellites(LNode baseNode) {
        this.base = baseNode;
        this.setConstraintsForNonSatellitesOnSide(PortSide.EAST);
        this.setConstraintsForNonSatellitesOnSide(PortSide.WEST);
    }

    private void setConstraintsForNonSatellitesOnSide(PortSide nonSatSide) {
        this.satellites = this.getSatelliteNodesOnSide(this.base, nonSatSide);
        if (!this.satellites.isEmpty()) {
            this.init(nonSatSide);
            this.determineNonSatellitesToBeDistanced();
            this.distanceNonSatellitesFromSatellites();
        }
    }

    public List<LNode> getSatelliteNodesOnSide(LNode baseNode, PortSide satSide) {
        List<LNode> connectedNodesOnSide = baseNode.getTrueConnectedNodes();
        return connectedNodesOnSide.stream().filter(n -> this.nodeIsOnSide((LNode)n, baseNode, satSide) && this.isSatellite((LNode)n)).collect(Collectors.toList());
    }

    private boolean nodeIsOnSide(LNode node, LNode baseNode, PortSide portSide) {
        return portSide == PortSide.WEST && this.layerBasedOnOrderProblem.leftFromDueToOrder(node, baseNode) || portSide == PortSide.EAST && this.layerBasedOnOrderProblem.leftFromDueToOrder(baseNode, node);
    }

    private void init(PortSide satSide) {
        this.portSideOfBase = satSide;
        this.portSideOfSatellite = this.portSideOfBase.opposed();
        this.portsOfBaseOnSatSide = this.getConnectedPortsOfBaseOnSatSide();
        this.nodesInAdjLayerOfBase = Lists.newArrayList(this.satellites);
        this.remainingNonSatellites = this.getNonSatelliteNodes(this.portSideOfBase);
        this.nonSatellitesToBeDistanced = Lists.newArrayList();
        if (satSide == PortSide.WEST) {
            this.maxWideNodeDummiesInSatellites = this.getMaxWideNodeDummiesInSatellites();
            this.nodesLeftFromBaseInRangeOfMaxWideNodeDummies = this.getNodesBackward(this.base, this.maxWideNodeDummiesInSatellites);
        }
    }

    private List<LPort> getConnectedPortsOfBaseOnSatSide() {
        return this.base.getTruePortsSortedTopToBottom(this.portSideOfBase).stream().filter(p -> p.hasEdges()).collect(Collectors.toList());
    }

    private List<LNode> getNonSatelliteNodes(PortSide portSide) {
        return this.getConnectedNodesOnSide(portSide).filter(n -> !this.isSatellite((LNode)n) && !n.isSeparate() && this.nodeIsOnSide((LNode)n, this.getConnectedWideNodeDummyOfBase((LNode)n, portSide), this.portSideOfBase) && this.areConnectedByHorizontalEdge((LNode)n, this.getConnectedWideNodeDummyOfBase((LNode)n, portSide))).distinct().collect(Collectors.toList());
    }

    private Stream<LNode> getConnectedNodesOnSide(PortSide portSide) {
        return this.base.getTruePorts(portSide).stream().flatMap(p -> p.getConnectedNodes().stream());
    }

    private LNode getConnectedWideNodeDummyOfBase(LNode node, PortSide portSide) {
        return this.base.getTruePorts(portSide).stream().filter(p -> this.isConnectedToNode((LPort)p, node)).map(p -> p.getNode()).findFirst().get();
    }

    private boolean isConnectedToNode(LPort port, LNode node) {
        return port.getConnectedNodes().contains(node);
    }

    private boolean areConnectedByHorizontalEdge(LNode node1, LNode node2) {
        return StreamSupport.stream(node1.getConnectedEdges().spliterator(), false).anyMatch(e -> this.isHorizontalEdgeBetween((LEdge)e, node1, node2));
    }

    private boolean isHorizontalEdgeBetween(LEdge edge, LNode node1, LNode node2) {
        return (edge.getSourceNode().equals(node1) && edge.getTargetNode().equals(node2) || edge.getSourceNode().equals(node2) && edge.getTargetNode().equals(node1)) && LayerBasedOnOrderProblem.getEdgeDirection(edge) == LayerBasedOnOrderProblem.EdgeDirection.HORIZONTAL;
    }

    private int getMaxWideNodeDummiesInSatellites() {
        return this.satellites.stream().mapToInt(s -> s.getNumWideNodeDummies()).max().getAsInt();
    }

    private List<LNode> getNodesBackward(LNode node, int maxDistance) {
        ArrayList nodeList = Lists.newArrayList();
        this.addNodesBackward(nodeList, node, 0, maxDistance);
        return nodeList;
    }

    private void addNodesBackward(List<LNode> nodeList, LNode node, int distance, int stopDistance) {
        if (distance < stopDistance) {
            nodeList.add(node);
            node.getSourceNodes().stream().filter(s -> this.areConnectedByHorizontalEdge((LNode)s, node) && this.layerBasedOnOrderProblem.leftFromDueToOrder((LNode)s, node)).forEach(s -> this.addNodesBackward(nodeList, (LNode)s, distance + 1, stopDistance));
        }
    }

    private void determineNonSatellitesToBeDistanced() {
        this.checkNonSatellitesConnectedToTopPort();
        this.checkFirstNonSatellites();
        this.checkLastNonSatellites();
        this.checkRemainingNonSatellites();
    }

    private void checkNonSatellitesConnectedToTopPort() {
        this.nonSatellitesToBeDistanced.addAll(this.getNonSatelliteNodes(PortSide.NORTH));
    }

    private void checkFirstNonSatellites() {
        List<LNode> nonSatellitesConnectedToFirstPortOfBase = this.getNonSatellitesConnectedToFirstOrLastBasePort(true);
        this.checkNonSatellites(nonSatellitesConnectedToFirstPortOfBase);
    }

    private void checkLastNonSatellites() {
        List<LNode> nonSatellitesConnectedToLastPortOfBase = this.getNonSatellitesConnectedToFirstOrLastBasePort(false);
        this.checkNonSatellites(nonSatellitesConnectedToLastPortOfBase);
    }

    private List<LNode> getNonSatellitesConnectedToFirstOrLastBasePort(boolean first) {
        return this.remainingNonSatellites.stream().filter(n -> this.isConnectedToFirstOrLastPortOfBase((LNode)n, first)).collect(Collectors.toList());
    }

    private boolean isConnectedToFirstOrLastPortOfBase(LNode nonSatellite, boolean first) {
        return this.getFirstOrLastConnectedPortOfBase(first).getConnectedNodes().contains(nonSatellite);
    }

    private LPort getFirstOrLastConnectedPortOfBase(boolean firstPort) {
        return firstPort ? this.portsOfBaseOnSatSide.get(0) : this.portsOfBaseOnSatSide.get(this.portsOfBaseOnSatSide.size() - 1);
    }

    private void checkRemainingNonSatellites() {
        this.base.getTruePortsSortedTopToBottom().forEach(p -> this.checkRemainingNonSatellitesConnectedTo((LPort)p));
    }

    private void checkRemainingNonSatellitesConnectedTo(LPort port) {
        List<LNode> nonSatellitesConnectedToPort = port.getConnectedNodes().stream().filter(n -> this.remainingNonSatellites.contains(n)).collect(Collectors.toList());
        this.checkNonSatellites(nonSatellitesConnectedToPort);
    }

    private void checkNonSatellites(List<LNode> nonSatellites) {
        if (!nonSatellites.isEmpty()) {
            this.checkNonEmptyNonSatellites(nonSatellites);
            this.remainingNonSatellites.removeAll(nonSatellites);
        }
    }

    private void checkNonEmptyNonSatellites(List<LNode> nonSatellites) {
        if (this.shouldNonSatellitesBeDistanced(nonSatellites)) {
            this.nonSatellitesToBeDistanced.addAll(nonSatellites);
        } else {
            nonSatellites.forEach(ns -> this.treatNonSatellitesNotToBeDistanced((LNode)ns));
        }
    }

    private boolean shouldNonSatellitesBeDistanced(List<LNode> nonSatellites) {
        if (this.oneOfNodesHasRotatedPort(nonSatellites)) {
            return this.allSatellitesHaveRotatedPorts();
        }
        if (this.hasConnectedTopPort(this.base) || this.hasConnectedBottomPort(this.base) || this.oneOfNodesIsOnlyConnectedByTopOrBottomPort(nonSatellites) || this.oneOfNodesIsConnectedToOtherNodesOnBaseSide(nonSatellites) || this.isSatelliteConnectedInBetween(nonSatellites) || this.oneOfNonSatOnOtherSideNotDistancedFromSatellites(nonSatellites) || this.oneOfNodesIsConnectedToSamePortAsSatellite(nonSatellites)) {
            return true;
        }
        return !this.isSpaceFor(nonSatellites);
    }

    private boolean allSatellitesHaveRotatedPorts() {
        return this.satellites.stream().allMatch(s -> SatelliteAndBaseNodesConstraints.hasRotatedPort(s));
    }

    private boolean hasConnectedTopPort(LNode node) {
        return node.getTruePorts(PortSide.NORTH).stream().anyMatch(p -> p.hasEdges());
    }

    private boolean hasConnectedBottomPort(LNode node) {
        return node.getTruePorts(PortSide.SOUTH).stream().anyMatch(p -> p.hasEdges());
    }

    private boolean oneOfNodesIsOnlyConnectedByTopOrBottomPort(List<LNode> nonSatellites) {
        return nonSatellites.stream().anyMatch(n -> this.isOnlyConnectedByTopOrBottomPort((LNode)n));
    }

    private boolean isOnlyConnectedByTopOrBottomPort(LNode node) {
        return node.getPortsAsList(this.portSideOfSatellite).isEmpty();
    }

    private boolean oneOfNodesHasRotatedPort(List<LNode> nonSatellites) {
        return nonSatellites.stream().anyMatch(n -> SatelliteAndBaseNodesConstraints.hasRotatedPort(n));
    }

    private static boolean hasRotatedPort(LNode node) {
        return node.getTruePorts().stream().anyMatch(p -> SatelliteAndBaseNodesConstraints.isRotatedPort(p));
    }

    private static boolean isRotatedPort(LPort port) {
        return !port.getIncomingEdges().isEmpty() && port.getSide() == PortSide.EAST || !port.getOutgoingEdges().isEmpty() && port.getSide() == PortSide.WEST;
    }

    private boolean oneOfNodesIsConnectedToOtherNodesOnBaseSide(List<LNode> nonSatellites) {
        return nonSatellites.stream().anyMatch(n -> this.isConnectedToOtherNodesOnBaseSide((LNode)n));
    }

    private boolean isConnectedToOtherNodesOnBaseSide(LNode node) {
        return node.getTruePorts(this.portSideOfSatellite).stream().flatMap(p -> p.getConnectedPortsAsStream()).anyMatch(cp -> !cp.getNode().getFirstWideNodeDummy().equals(this.base));
    }

    private boolean isSatelliteConnectedInBetween(List<LNode> nonSatellites) {
        List<Integer> ixOfPortsOfBaseConnectedToNonSat = this.getIxOfPortsOfBaseConnectedTo(nonSatellites);
        return this.isSatelliteConnectedToBasePortInBetween(ixOfPortsOfBaseConnectedToNonSat);
    }

    private List<Integer> getIxOfPortsOfBaseConnectedTo(List<LNode> nonSatellites) {
        return nonSatellites.stream().flatMap(n -> this.getIxOfPortsOfBaseConnectedToNonSat((LNode)n)).collect(Collectors.toList());
    }

    private Stream<Integer> getIxOfPortsOfBaseConnectedToNonSat(LNode nonSatellite) {
        Stream<LEdge> edgesFromOrToNonSat = this.getEdgesFromOrTo(nonSatellite);
        return this.getIxOfPortsOfBaseThatAreConnectedToNonSat(edgesFromOrToNonSat);
    }

    private Stream<LEdge> getEdgesFromOrTo(LNode nonSatellite) {
        return nonSatellite.getTruePorts(this.portSideOfSatellite).stream().flatMap(LPort::getConnectedEdgesAsStream);
    }

    private Stream<Integer> getIxOfPortsOfBaseThatAreConnectedToNonSat(Stream<LEdge> edgesFromOrToNonSat) {
        return edgesFromOrToNonSat.map(e -> this.portsOfBaseOnSatSide.indexOf(this.getBasePortOfEdge((LEdge)e))).filter(ix -> ix != -1).sorted();
    }

    private LPort getBasePortOfEdge(LEdge edge) {
        return this.nodeIsOneOfWideNodeDummiesOfBase(edge.getSourceNode()) ? edge.getSource() : edge.getTarget();
    }

    private boolean nodeIsOneOfWideNodeDummiesOfBase(LNode node) {
        return this.base.getOrigin().equals(node.getOrigin());
    }

    private boolean isSatelliteConnectedToBasePortInBetween(List<Integer> ixOfPortsOfBaseConnectedToNonSat) {
        int ixStart = ixOfPortsOfBaseConnectedToNonSat.get(0) + 1;
        int ixEndExclusive = ixOfPortsOfBaseConnectedToNonSat.get(ixOfPortsOfBaseConnectedToNonSat.size() - 1);
        return IntStream.range(ixStart, ixEndExclusive).anyMatch(ix -> this.portsOfBaseOnSatSide.get(ix).getConnectedNodes().stream().anyMatch(n -> this.isSatellite((LNode)n)));
    }

    private boolean oneOfNonSatOnOtherSideNotDistancedFromSatellites(List<LNode> nonSatellites) {
        return nonSatellites.stream().anyMatch(n -> this.isNonSatelliteNotToBeDistanced((LNode)n));
    }

    private boolean isNonSatelliteNotToBeDistanced(LNode nonSat) {
        return nonSat.getWideNodeDummiesOrNodeItself().stream().anyMatch(n -> this.nonSatellitesNotToBeDistanced.contains(n));
    }

    private boolean oneOfNodesIsConnectedToSamePortAsSatellite(List<LNode> nonSatellites) {
        return nonSatellites.stream().anyMatch(n -> this.isConnectedToSamePortAsSatellite((LNode)n));
    }

    private boolean isConnectedToSamePortAsSatellite(LNode nonSatellite) {
        List<LPort> ports = this.getPortsOfBaseConnectedToNonSat(nonSatellite);
        return ports.stream().anyMatch(p -> this.isConnectedToSatellite((LPort)p));
    }

    private List<LPort> getPortsOfBaseConnectedToNonSat(LNode nonSatellite) {
        return this.getEdgesFromOrTo(nonSatellite).map(e -> this.getBasePortOfEdge((LEdge)e)).collect(Collectors.toList());
    }

    private boolean isConnectedToSatellite(LPort port) {
        return port.getConnectedPortsAsStream().anyMatch(p -> this.isSatellite(p.getNode()));
    }

    private boolean isSpaceFor(List<LNode> nonSatellites) {
        return this.isConnectedToFirstOrLastPortOfBase(nonSatellites.get(0)) ? this.isSpaceForFirstOrLastNonSat(nonSatellites) : this.isSpaceForNonSatellitesInTheMiddle(nonSatellites);
    }

    private boolean isConnectedToFirstOrLastPortOfBase(LNode node) {
        return this.isConnectedToFirstOrLastPortOfBase(node, true) || this.isConnectedToFirstOrLastPortOfBase(node, false);
    }

    private boolean isSpaceForFirstOrLastNonSat(List<LNode> nonSatellites) {
        boolean first = this.isConnectedToFirstOrLastPortOfBase(nonSatellites.get(0), true);
        boolean distanceNonSatIfStraightEdgeIsNotPossible = this.portSideOfBase != PortSide.WEST || this.getWidthOfMostWideSatellite() < 37.0 || this.neighborIsSatellite(nonSatellites.get(0), first);
        return distanceNonSatIfStraightEdgeIsNotPossible ? this.canFirstOrLastNonSatelliteBePlacedWithStraightEdge(nonSatellites, first) : this.heightOfLeftFirstOrLastNonSatelliteIsWithinLimit(nonSatellites.get(0));
    }

    private double getWidthOfMostWideSatellite() {
        return this.satellites.stream().mapToDouble(n -> n.getTrueSize().x).max().getAsDouble();
    }

    private boolean neighborIsSatellite(LNode nonSatellite, boolean first) {
        List<LNode> nextLowerOrHigherConnectedNode = this.getNodesConnectedToNextHigherOrLowerPortOfBase(nonSatellite, first);
        return this.isSatellite(nextLowerOrHigherConnectedNode.get(0));
    }

    private List<LNode> getNodesConnectedToNextHigherOrLowerPortOfBase(LNode nonSatellite, boolean lower) {
        LPort nextHigherOrLowerConnectedPortOfBase = this.getNextHigherOrLowerConnPortOfBase(Lists.newArrayList((Object[])new LNode[]{nonSatellite}), lower);
        return nextHigherOrLowerConnectedPortOfBase.getConnectedNodes();
    }

    private LPort getNextHigherOrLowerConnPortOfBase(List<LNode> nonSatellites, boolean below) {
        List<Integer> ixOfPortsOfBaseConnectedToNonSat = this.getIxOfPortsOfBaseConnectedTo(nonSatellites);
        int nextHigherOrLowerPortIndexOfBase = this.getPortIndexToStartFrom(ixOfPortsOfBaseConnectedToNonSat, below);
        List<LPort> connectedPorts = this.getConnectedPortsFromIndex(below, nextHigherOrLowerPortIndexOfBase);
        return below ? connectedPorts.get(0) : connectedPorts.get(connectedPorts.size() - 1);
    }

    private int getPortIndexToStartFrom(List<Integer> ixOfBasePortsThatAreContdToNonSat, boolean below) {
        IntStream portIndices = ixOfBasePortsThatAreContdToNonSat.stream().mapToInt(i -> i);
        return below ? portIndices.max().orElse(-1) + 1 : portIndices.min().orElse(-1);
    }

    private List<LPort> getConnectedPortsFromIndex(boolean below, int portIxToStartFrom) {
        return this.getPortsBelowOrAboveStartIndex(below, portIxToStartFrom).stream().filter(p -> p.hasEdges()).collect(Collectors.toList());
    }

    private List<LPort> getPortsBelowOrAboveStartIndex(boolean below, int portIxToStartFrom) {
        return below ? this.portsOfBaseOnSatSide.subList(portIxToStartFrom, this.portsOfBaseOnSatSide.size()) : this.portsOfBaseOnSatSide.subList(0, portIxToStartFrom);
    }

    private boolean canFirstOrLastNonSatelliteBePlacedWithStraightEdge(List<LNode> nonSatellites, boolean first) {
        double yPositionOccupiedAboveOrBelow = this.getYPositionOccupiedAboveOrBelow(nonSatellites, first);
        double minOrMaxYPosThatNonSatMightOccupy = this.getMinOrMaxYPosThatNonSatMightOccupy(nonSatellites, first);
        return first ? minOrMaxYPosThatNonSatMightOccupy + 5.0 < yPositionOccupiedAboveOrBelow : yPositionOccupiedAboveOrBelow + 5.0 < minOrMaxYPosThatNonSatMightOccupy;
    }

    private double getYPositionOccupiedAboveOrBelow(List<LNode> nonSatellites, boolean below) {
        LPort nextHigherOrLowerConnPortOfBase = this.getNextHigherOrLowerConnPortOfBase(nonSatellites, below);
        List<LNode> connNodesInAdjLayerOfBase = nextHigherOrLowerConnPortOfBase.getConnectedNodes().stream().filter(n -> this.nodesInAdjLayerOfBase.contains(n)).collect(Collectors.toList());
        return connNodesInAdjLayerOfBase.isEmpty() ? nextHigherOrLowerConnPortOfBase.getPosition().y : this.getMinOrMaxYPosThatNonSatMightOccupy(connNodesInAdjLayerOfBase, !below);
    }

    private double getMinOrMaxYPosThatNonSatMightOccupy(List<LNode> nonSatellites, boolean below) {
        DoubleStream minOrMaxYPosStream = nonSatellites.stream().mapToDouble(n -> this.getMinOrMaxYPosThatNonSatMightOccupy((LNode)n, below));
        double minOrMaxYPos = below ? minOrMaxYPosStream.min().getAsDouble() : minOrMaxYPosStream.max().getAsDouble();
        LNode nodeWithMinYPos = nonSatellites.stream().filter(n -> this.getMinOrMaxYPosThatNonSatMightOccupy((LNode)n, below) == minOrMaxYPos).findFirst().get();
        double yDistRemainingNonSatOccupy = nonSatellites.stream().mapToDouble(n -> n.getSize().y).sum() - nodeWithMinYPos.getSize().y + (double)(nonSatellites.size() - 1) * 5.0;
        return below ? minOrMaxYPos + yDistRemainingNonSatOccupy : minOrMaxYPos - yDistRemainingNonSatOccupy;
    }

    private double getMinOrMaxYPosThatNonSatMightOccupy(LNode nonSatellite, boolean max) {
        Stream<LPort> connectedPortsOfNonSat = nonSatellite.getTruePortsSortedTopToBottom(this.portSideOfSatellite).stream().filter(p -> p.hasEdges());
        DoubleStream yPos = connectedPortsOfNonSat.mapToDouble(p -> this.getYPosOccupiedIfEdgeOfPortIsStraight(nonSatellite, (LPort)p, max));
        OptionalDouble minOrMax = max ? yPos.max() : yPos.min();
        return minOrMax.getAsDouble();
    }

    private double getYPosOccupiedIfEdgeOfPortIsStraight(LNode nonSatellite, LPort port, boolean max) {
        LPort lowestOrHighestConnectedPortOfBase = this.getLowestOrHighestConnPortOfBase(port, max);
        double yPosOfLowestOrHighestConnectedPortOfBase = lowestOrHighestConnectedPortOfBase.getPosition().y;
        double yDistanceOfPortToTopOrBottomOfNode = this.getYDistanceOfPortToTopOrBottomOfNode(nonSatellite, max, port);
        return yPosOfLowestOrHighestConnectedPortOfBase + yDistanceOfPortToTopOrBottomOfNode;
    }

    private LPort getLowestOrHighestConnPortOfBase(LPort nonSatPort, boolean highest) {
        List portsOfBaseConnToNonSatPort = this.portsOfBaseOnSatSide.stream().filter(p -> p.getConnectedPortsAsStream().anyMatch(cp -> cp.equals(nonSatPort))).collect(Collectors.toList());
        return highest ? (LPort)portsOfBaseConnToNonSatPort.get(0) : (LPort)portsOfBaseConnToNonSatPort.get(portsOfBaseConnToNonSatPort.size() - 1);
    }

    private double getYDistanceOfPortToTopOrBottomOfNode(LNode nonSatellite, boolean start, LPort nonSatPort) {
        return start ? nonSatellite.getSize().y - nonSatPort.getPosition().y : -nonSatPort.getPosition().y;
    }

    private boolean heightOfLeftFirstOrLastNonSatelliteIsWithinLimit(LNode nonSatellite) {
        double totalHeightOfNodesConnectedToBaseInAdjLayer = this.nodesInAdjLayerOfBase.stream().mapToDouble(n -> n.getSize().y).sum();
        double maxAllowedTotalHeightOfNonSatellites = this.base.getSize().y * 2.0 - totalHeightOfNodesConnectedToBaseInAdjLayer;
        return nonSatellite.getSize().y < maxAllowedTotalHeightOfNonSatellites;
    }

    private boolean isSpaceForNonSatellitesInTheMiddle(List<LNode> nonSatellites) {
        double availableSpace = this.getAvailableSpace(nonSatellites);
        double totalHeightOfNonSatellites = nonSatellites.stream().mapToDouble(n -> n.getSize().y).sum();
        return totalHeightOfNonSatellites < availableSpace - 10.0;
    }

    private double getAvailableSpace(List<LNode> nonSatellites) {
        double allowedHeightUpperBoundary = this.getYPositionOccupiedAboveOrBelow(nonSatellites, false);
        double allowedHeightLowerBoundary = this.getYPositionOccupiedAboveOrBelow(nonSatellites, true);
        return allowedHeightLowerBoundary - allowedHeightUpperBoundary;
    }

    private void treatNonSatellitesNotToBeDistanced(LNode nonSat) {
        this.nodesInAdjLayerOfBase.add(nonSat);
        this.nonSatellitesNotToBeDistanced.add(nonSat);
        if (this.portSideOfBase == PortSide.WEST) {
            this.distanceNodesDirectlyOrIndirectlyConnectedToNodeOtherThanBase(nonSat);
        }
    }

    private void distanceNodesDirectlyOrIndirectlyConnectedToNodeOtherThanBase(LNode nonSatellite) {
        List<LNode> nodesThatShouldKeepDistance = this.getLeftNodesWithTargetNotDirectlyOrIndirectlyConnectedToBase(nonSatellite);
        if (!nodesThatShouldKeepDistance.isEmpty()) {
            this.nonSatellitesToBeDistanced.addAll(nodesThatShouldKeepDistance);
        }
    }

    private List<LNode> getLeftNodesWithTargetNotDirectlyOrIndirectlyConnectedToBase(LNode nonSat) {
        List<LNode> nodesToCheck = this.getNodesBackward(nonSat, this.maxWideNodeDummiesInSatellites);
        return nodesToCheck.stream().filter(n -> n.getTargetNodes().stream().anyMatch(t -> !this.nodesLeftFromBaseInRangeOfMaxWideNodeDummies.contains(t))).collect(Collectors.toList());
    }

    private void distanceNonSatellitesFromSatellites() {
        if (!this.nonSatellitesToBeDistanced.isEmpty()) {
            List<LNode> nodesToBeDistanced = this.getNodesToBeDistancedFromSatellites();
            this.distanceNodesFromSatellites(nodesToBeDistanced);
        }
    }

    private List<LNode> getNodesToBeDistancedFromSatellites() {
        return this.nonSatellitesToBeDistanced.stream().flatMap(n -> this.getNodesToBeDistancedFromSatellites((LNode)n).stream()).collect(Collectors.toList());
    }

    private List<LNode> getNodesToBeDistancedFromSatellites(LNode nonSatellite) {
        return this.hasSatelliteOnBaseSide(nonSatellite) ? this.getSatelliteNodesOnSide(nonSatellite, this.portSideOfSatellite) : Lists.newArrayList((Object[])new LNode[]{nonSatellite});
    }

    private boolean hasSatelliteOnBaseSide(LNode node) {
        return node.getTruePorts(this.portSideOfSatellite).stream().anyMatch(p -> this.isConnectedToSatellite((LPort)p));
    }

    private void distanceNodesFromSatellites(List<LNode> nodesToBeDistanced) {
        if (this.portSideOfBase == PortSide.WEST) {
            this.layerBasedOnOrderProblem.setLayeringConstraintToKeepAtLeastOneLayerGap(nodesToBeDistanced, this.satellites);
        } else {
            this.layerBasedOnOrderProblem.setLayeringConstraintToKeepAtLeastOneLayerGap(this.satellites, nodesToBeDistanced);
        }
    }
}

