/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.p2layers.mes;

import com.google.ortools.linearsolver.MPVariable;
import com.modelengineers.MoRe_elk.alg.layered.graph.LEdge;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.ortools.MPSolverWrapperInt;
import com.modelengineers.MoRe_elk.core.options.PortSide;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class OrderProblem {
    private static final double COEFF_BACK_EDGE = 100.0;
    private static final double COEFF_BACK_EDGE_ATTENUATION_FACTOR_FOR_DELAY_NODE = 0.9;
    private static final double COEFF_ADDITIONAL_BACK_EDGE_BRANCH = 1.0;
    private static final double COEFF_GOTO_NOT_LEFT_OF_FROM = 1.0;
    private MPSolverWrapperInt solver;
    private List<LNode> nodes;
    private Map<LNode, MPVariable> nodeToLayerMap;
    private Map<LEdge, MPVariable> isBackEdgeMap = new HashMap<LEdge, MPVariable>();

    public OrderProblem(MPSolverWrapperInt solver, List<LNode> nodes, Map<LNode, MPVariable> nodeToLayerMap) {
        this.solver = solver;
        this.nodes = nodes;
        this.nodeToLayerMap = nodeToLayerMap;
        this.addConstraintsAndObjectivesToSolver();
    }

    private void addConstraintsAndObjectivesToSolver() {
        this.treatEdgesBetweenNodes();
        this.treatBranchedEdges();
        this.treatGotoFromNodes();
    }

    private void treatEdgesBetweenNodes() {
        int i = 0;
        while (i < this.nodes.size()) {
            int j = i + 1;
            while (j < this.nodes.size()) {
                this.treatEdgesBetweenNodes(this.nodes.get(i), this.nodes.get(j));
                ++j;
            }
            ++i;
        }
    }

    private void treatEdgesBetweenNodes(LNode a, LNode b) {
        List<LEdge> edges = a.getEdgesConnectedWith(b);
        if (!edges.isEmpty()) {
            if (OrderProblem.areDummiesOfSameWideNode(a, b)) {
                this.treatEdgesBetweenDummiesOfSameWideNode(a, b, edges);
            } else if (a.isLastSeparate() && b.isLastSeparate() || a.isFirstSeparate() && b.isFirstSeparate()) {
                this.haveToBeInSameLayer(a, b);
            } else if (a.isFirstSeparate() || b.isLastSeparate()) {
                this.hasToBeLeftFrom(a, b);
            } else if (b.isFirstSeparate() || a.isLastSeparate()) {
                this.hasToBeLeftFrom(b, a);
            } else {
                this.treatEdgesOnLeftSideOfFirstNode(a, b, edges);
                this.treatEdgesOnLeftSideOfFirstNode(b, a, edges);
            }
        }
    }

    private static boolean areDummiesOfSameWideNode(LNode a, LNode b) {
        return a.isWideNode() && b.isWideNode() && a.getOriginalWideNode().equals(b.getOriginalWideNode());
    }

    private void treatEdgesBetweenDummiesOfSameWideNode(LNode a, LNode b, List<LEdge> edges) {
        if (edges.get(0).getTargetNode().equals(b)) {
            this.hasToBeDirectlyLeftFrom(a, b);
        } else {
            this.hasToBeDirectlyLeftFrom(b, a);
        }
    }

    private void hasToBeDirectlyLeftFrom(LNode a, LNode b) {
        this.solver.diffHasToBeInRange(this.getLayer(b), this.getLayer(a), 1.0, 1.0);
    }

    private void haveToBeInSameLayer(LNode a, LNode b) {
        this.solver.diffHasToBe(this.getLayer(a), this.getLayer(b), 0.0);
    }

    private void hasToBeLeftFrom(LNode a, LNode b) {
        this.solver.diffHasToBeInRange(this.getLayer(b), this.getLayer(a), 1.0, this.nodes.size() - 1);
    }

    private MPVariable getLayer(LNode node) {
        return this.nodeToLayerMap.get(node);
    }

    private void treatEdgesOnLeftSideOfFirstNode(LNode a, LNode b, List<LEdge> edges) {
        List<LEdge> edgesOnLeftSideOfA = edges.stream().filter(e -> OrderProblem.edgeShouldBeOnLeftSide(e, a)).collect(Collectors.toList());
        if (!edgesOnLeftSideOfA.isEmpty()) {
            this.treatHorizontalEdges(b, a, edgesOnLeftSideOfA);
        }
    }

    private static boolean edgeShouldBeOnLeftSide(LEdge edge, LNode node) {
        boolean edgeShouldBeFromRightToLeft;
        PortSide fromSide = edge.getSourceSide();
        PortSide toSide = edge.getTargetSide();
        boolean edgeShouldBeFromLeftToRight = toSide != PortSide.EAST && fromSide != PortSide.WEST;
        boolean bl = edgeShouldBeFromRightToLeft = !edgeShouldBeFromLeftToRight && fromSide != toSide;
        return edge.getTargetNode() == node && edgeShouldBeFromLeftToRight || edge.getSourceNode() == node && edgeShouldBeFromRightToLeft;
    }

    private void treatHorizontalEdges(LNode left, LNode right, List<LEdge> edges) {
        MPVariable isBackEdge = this.solver.makeIsLessThanOrEqualToVar(this.getLayer(right), this.getLayer(left));
        double delayNodeAttenuation = this.shouldCoeffBackEdgeBeAttenuated(left, right) ? 0.9 : 1.0;
        this.solver.setObjectiveCoeff(isBackEdge, 100.0 * delayNodeAttenuation * (double)edges.size());
        edges.forEach(e -> {
            MPVariable mPVariable2 = this.isBackEdgeMap.put((LEdge)e, isBackEdge);
        });
    }

    private boolean shouldCoeffBackEdgeBeAttenuated(LNode left, LNode right) {
        return left.isDelayNode() && !left.hasTrueNorthSouthPort() && this.isNoneOfTargetNodesGotoNode(left) && left.isInSameFeedbackLoopAs(right);
    }

    private boolean isNoneOfTargetNodesGotoNode(LNode left) {
        return left.getTrueTargetNodesSkippingLongEdgeDummies().stream().noneMatch(n -> n.getMesBlockParam("BlockType").equals("Goto"));
    }

    private void treatBranchedEdges() {
        Stream<LPort> portsWithBranchedEdges = this.nodes.stream().flatMap(n -> n.getPorts().stream()).filter(p -> p.getOutgoingEdges().size() > 1);
        portsWithBranchedEdges.forEach(p -> this.treatBranchedEdges((LPort)p));
    }

    private void treatBranchedEdges(LPort port) {
        List<MPVariable> outgoingEdgesAreBackEdges = this.getOutgoingEdgesOfPortAreBackEdgesList(port);
        MPVariable sumOfBackEdges = this.solver.makeSumVar(outgoingEdgesAreBackEdges);
        MPVariable sumOfBackEdgesMinus1 = this.solver.makeDiffVar(sumOfBackEdges, 1);
        MPVariable sumOfBackEdgesMinus1Pos = this.solver.makePosVar(sumOfBackEdgesMinus1);
        this.solver.setObjectiveCoeff(sumOfBackEdgesMinus1Pos, -100.0);
        this.solver.setObjectiveCoeff(sumOfBackEdgesMinus1, 1.0);
    }

    private List<MPVariable> getOutgoingEdgesOfPortAreBackEdgesList(LPort port) {
        return port.getOutgoingEdges().stream().map(e -> this.isBackEdgeMap.get(e)).filter(v -> v != null).collect(Collectors.toList());
    }

    private void treatGotoFromNodes() {
        int i = 0;
        while (i < this.nodes.size()) {
            LNode node1 = this.nodes.get(i);
            int j = 0;
            while (j < this.nodes.size()) {
                LNode node2 = this.nodes.get(j);
                if (node1.isLastGotoWideNodeDummyWithFirstFromWideNodeDummy(node2)) {
                    this.gotoShouldBeLeftOfFromNode(node1, node2);
                }
                ++j;
            }
            ++i;
        }
    }

    private void gotoShouldBeLeftOfFromNode(LNode gotoNode, LNode fromNode) {
        MPVariable gotoIsNotLeftOfFrom = this.solver.makeIsLessThanOrEqualToVar(this.getLayer(fromNode), this.getLayer(gotoNode));
        this.solver.setObjectiveCoeff(gotoIsNotLeftOfFrom, 1.0);
    }
}

