/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.p2layers.mes;

import com.google.ortools.linearsolver.MPSolver;
import com.google.ortools.linearsolver.MPVariable;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.mesutils.MesUtilMethods;
import com.modelengineers.MoRe_elk.alg.layered.ortools.MPSolverWrapperInt;
import com.modelengineers.MoRe_elk.alg.layered.p2layers.mes.FinalLayeringProblem;
import com.modelengineers.MoRe_elk.alg.layered.p2layers.mes.LayerBasedOnOrderProblem;
import com.modelengineers.MoRe_elk.alg.layered.p2layers.mes.MesLayerer;
import com.modelengineers.MoRe_elk.alg.layered.p2layers.mes.OrderProblem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class MesLayererCore {
    private static final boolean PRINT_SOLVER_VARIABLES_FOR_DEBUGGING = false;
    private MPSolverWrapperInt solver;
    private Map<LNode, MPVariable> nodeToLayerMap;
    private List<LNode> nodes;
    private LGraph graph;
    private int[] layersOfNodesForOrder;
    private int[] layersOfNodesBasedOnOrder;
    private int[] finalLayersOfNodes;

    public MesLayererCore(List<LNode> nodes) {
        this.nodes = nodes;
        this.graph = nodes.get(0).getGraph();
    }

    public int[] computeLayers() throws InterruptedException {
        if (this.nodes.size() == 1) {
            return new int[1];
        }
        return this.computeLayersForMoreThanOneNode();
    }

    private int[] computeLayersForMoreThanOneNode() throws InterruptedException {
        this.computeLayersForNodeOrder();
        this.computeLayersBasedOnOrder();
        this.computeFinalLayers();
        return this.finalLayersOfNodes;
    }

    private void computeLayersForNodeOrder() throws InterruptedException {
        this.setUpSolverWithLayerVars();
        new OrderProblem(this.solver, this.nodes, this.nodeToLayerMap);
        this.layersOfNodesForOrder = this.computeLayersWithSolver(OrderProblem.class.getSimpleName());
    }

    private void computeLayersBasedOnOrder() throws InterruptedException {
        this.setUpSolverWithLayerVars();
        new LayerBasedOnOrderProblem(this.solver, this.nodes, this.nodeToLayerMap, this.layersOfNodesForOrder);
        this.layersOfNodesBasedOnOrder = this.computeLayersWithSolver(LayerBasedOnOrderProblem.class.getSimpleName());
    }

    private void computeFinalLayers() throws InterruptedException {
        new FinalLayeringProblem(this.solver, this.nodes, this.nodeToLayerMap, this.layersOfNodesBasedOnOrder);
        this.finalLayersOfNodes = this.computeLayersWithSolver(FinalLayeringProblem.class.getSimpleName());
    }

    private void setUpSolverWithLayerVars() throws InterruptedException {
        this.solver = new MPSolverWrapperInt();
        this.createLayerOfNodesVars();
    }

    private void createLayerOfNodesVars() throws InterruptedException {
        this.nodeToLayerMap = new HashMap<LNode, MPVariable>();
        int i = 0;
        while (i < this.nodes.size()) {
            MesUtilMethods.checkInterrupt();
            LNode node = this.nodes.get(i);
            node.id = i++;
            this.nodeToLayerMap.put(node, this.solver.makeIntVar(0.0, this.nodes.size() - 1, "L_" + node));
        }
    }

    private int[] computeLayersWithSolver(String problemName) throws InterruptedException {
        this.runSolver(problemName);
        return this.getLayersFromSolver();
    }

    private void runSolver(String problemName) throws InterruptedException {
        this.solver.setMinimization();
        MesUtilMethods.measureRuntime(() -> this.solver.solve(), this.getPrintPrefix(problemName), this.graph.loggingEnabled());
        assert (this.solver.getResultStatus() == MPSolver.ResultStatus.OPTIMAL);
        this.printSolverVariables(problemName);
    }

    private void printSolverVariables(String problemName) {
    }

    private String getPrintPrefix(String problemName) {
        return String.valueOf(MesLayerer.PRINT_PREFIX) + " - " + problemName;
    }

    private int[] getLayersFromSolver() {
        int[] layersOfNodes = new int[this.nodes.size()];
        int n = 0;
        while (n < this.nodes.size()) {
            LNode node = this.nodes.get(n);
            layersOfNodes[n] = (int)this.nodeToLayerMap.get(node).solutionValue();
            ++n;
        }
        return layersOfNodes;
    }
}

