/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.options;

import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraphElement;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.options.LayeredOptions;
import com.modelengineers.MoRe_elk.alg.layered.p4nodes.bk.DataFlowDistance;
import com.modelengineers.MoRe_elk.core.util.Pair;
import com.modelengineers.MoRe_elk.graph.properties.IProperty;
import com.modelengineers.MoRe_elk.graph.properties.IPropertyHolder;
import java.util.HashMap;

public final class Spacings {
    private LGraph graph;
    private IProperty<Double>[][] nodeTypeSpacingOptionsHorizontal;
    private IProperty<Double>[][] nodeTypeSpacingOptionsVertical;
    private HashMap<Pair<LNode, LNode>, Double> verticalSpacings;
    private DataFlowDistance forwardDataFlow;
    private DataFlowDistance backwardDataFlow;
    static final double[] EXTRA_SPACINGS_FOR_DATA_FLOW_DISTANCE = new double[]{0.0, 10.0, 20.0, 40.0, 70.0};

    public Spacings(LGraph graph) {
        this.graph = graph;
        int n = LNode.NodeType.values().length;
        this.nodeTypeSpacingOptionsHorizontal = new IProperty[n][n];
        this.nodeTypeSpacingOptionsVertical = new IProperty[n][n];
        this.verticalSpacings = new HashMap();
        this.precalculateNodeTypeSpacings();
    }

    private void precalculateNodeTypeSpacings() {
        this.nodeTypeSpacing(LNode.NodeType.NORMAL, LayeredOptions.SPACING_NODE_NODE, LayeredOptions.SPACING_NODE_NODE_BETWEEN_LAYERS);
        this.nodeTypeSpacing(LNode.NodeType.NORMAL, LNode.NodeType.LONG_EDGE, LayeredOptions.SPACING_EDGE_NODE, LayeredOptions.SPACING_EDGE_NODE_BETWEEN_LAYERS);
        this.nodeTypeSpacing(LNode.NodeType.NORMAL, LNode.NodeType.NORTH_SOUTH_PORT, LayeredOptions.SPACING_EDGE_NODE);
        this.nodeTypeSpacing(LNode.NodeType.NORMAL, LNode.NodeType.EXTERNAL_PORT, LayeredOptions.SPACING_EDGE_NODE);
        this.nodeTypeSpacing(LNode.NodeType.NORMAL, LNode.NodeType.LABEL, LayeredOptions.SPACING_NODE_NODE, LayeredOptions.SPACING_NODE_NODE_BETWEEN_LAYERS);
        this.nodeTypeSpacing(LNode.NodeType.NORMAL, LNode.NodeType.WIDE_NODE, LayeredOptions.SPACING_NODE_NODE, LayeredOptions.SPACING_NODE_NODE_BETWEEN_LAYERS);
        this.nodeTypeSpacing(LNode.NodeType.LONG_EDGE, LayeredOptions.SPACING_EDGE_EDGE, LayeredOptions.SPACING_EDGE_EDGE_OR_EDGE_NODE_BETWEEN_LAYERS_ADAPTIVE_LOWER_BOUND);
        this.nodeTypeSpacing(LNode.NodeType.LONG_EDGE, LNode.NodeType.NORTH_SOUTH_PORT, LayeredOptions.SPACING_EDGE_EDGE);
        this.nodeTypeSpacing(LNode.NodeType.LONG_EDGE, LNode.NodeType.EXTERNAL_PORT, LayeredOptions.SPACING_EDGE_EDGE);
        this.nodeTypeSpacing(LNode.NodeType.LONG_EDGE, LNode.NodeType.LABEL, LayeredOptions.SPACING_EDGE_NODE, LayeredOptions.SPACING_EDGE_NODE_BETWEEN_LAYERS);
        this.nodeTypeSpacing(LNode.NodeType.LONG_EDGE, LNode.NodeType.WIDE_NODE, LayeredOptions.SPACING_EDGE_NODE, LayeredOptions.SPACING_EDGE_NODE_BETWEEN_LAYERS);
        this.nodeTypeSpacing(LNode.NodeType.NORTH_SOUTH_PORT, LayeredOptions.SPACING_EDGE_EDGE);
        this.nodeTypeSpacing(LNode.NodeType.NORTH_SOUTH_PORT, LNode.NodeType.EXTERNAL_PORT, LayeredOptions.SPACING_EDGE_EDGE);
        this.nodeTypeSpacing(LNode.NodeType.NORTH_SOUTH_PORT, LNode.NodeType.LABEL, LayeredOptions.SPACING_LABEL_NODE);
        this.nodeTypeSpacing(LNode.NodeType.NORTH_SOUTH_PORT, LNode.NodeType.WIDE_NODE, LayeredOptions.SPACING_EDGE_NODE);
        this.nodeTypeSpacing(LNode.NodeType.EXTERNAL_PORT, LayeredOptions.SPACING_PORT_PORT);
        this.nodeTypeSpacing(LNode.NodeType.EXTERNAL_PORT, LNode.NodeType.LABEL, LayeredOptions.SPACING_LABEL_PORT_VERTICAL, LayeredOptions.SPACING_LABEL_PORT_HORIZONTAL);
        this.nodeTypeSpacing(LNode.NodeType.EXTERNAL_PORT, LNode.NodeType.WIDE_NODE, LayeredOptions.SPACING_EDGE_NODE);
        this.nodeTypeSpacing(LNode.NodeType.LABEL, LayeredOptions.SPACING_EDGE_EDGE, LayeredOptions.SPACING_EDGE_EDGE);
        this.nodeTypeSpacing(LNode.NodeType.LABEL, LNode.NodeType.WIDE_NODE, LayeredOptions.SPACING_EDGE_EDGE);
        this.nodeTypeSpacing(LNode.NodeType.WIDE_NODE, LayeredOptions.SPACING_NODE_NODE, LayeredOptions.SPACING_NODE_NODE_BETWEEN_LAYERS);
        this.nodeTypeSpacing(LNode.NodeType.BREAKING_POINT, LayeredOptions.SPACING_EDGE_EDGE, LayeredOptions.SPACING_EDGE_EDGE_OR_EDGE_NODE_BETWEEN_LAYERS_ADAPTIVE_LOWER_BOUND);
        this.nodeTypeSpacing(LNode.NodeType.BREAKING_POINT, LNode.NodeType.NORMAL, LayeredOptions.SPACING_EDGE_NODE, LayeredOptions.SPACING_EDGE_NODE_BETWEEN_LAYERS);
        this.nodeTypeSpacing(LNode.NodeType.BREAKING_POINT, LNode.NodeType.LABEL, LayeredOptions.SPACING_EDGE_NODE, LayeredOptions.SPACING_EDGE_NODE_BETWEEN_LAYERS);
        this.nodeTypeSpacing(LNode.NodeType.BREAKING_POINT, LNode.NodeType.LONG_EDGE, LayeredOptions.SPACING_EDGE_NODE, LayeredOptions.SPACING_EDGE_NODE_BETWEEN_LAYERS);
    }

    private void nodeTypeSpacing(LNode.NodeType nt, IProperty<Double> spacing) {
        this.nodeTypeSpacingOptionsVertical[nt.ordinal()][nt.ordinal()] = spacing;
    }

    private void nodeTypeSpacing(LNode.NodeType nt, IProperty<Double> spacingVert, IProperty<Double> spacingHorz) {
        this.nodeTypeSpacingOptionsVertical[nt.ordinal()][nt.ordinal()] = spacingVert;
        this.nodeTypeSpacingOptionsHorizontal[nt.ordinal()][nt.ordinal()] = spacingHorz;
    }

    private void nodeTypeSpacing(LNode.NodeType n1, LNode.NodeType n2, IProperty<Double> spacing) {
        this.nodeTypeSpacingOptionsVertical[n1.ordinal()][n2.ordinal()] = spacing;
        this.nodeTypeSpacingOptionsVertical[n2.ordinal()][n1.ordinal()] = spacing;
    }

    private void nodeTypeSpacing(LNode.NodeType n1, LNode.NodeType n2, IProperty<Double> spacingVert, IProperty<Double> spacingHorz) {
        this.nodeTypeSpacingOptionsVertical[n1.ordinal()][n2.ordinal()] = spacingVert;
        this.nodeTypeSpacingOptionsVertical[n2.ordinal()][n1.ordinal()] = spacingVert;
        this.nodeTypeSpacingOptionsHorizontal[n1.ordinal()][n2.ordinal()] = spacingHorz;
        this.nodeTypeSpacingOptionsHorizontal[n2.ordinal()][n1.ordinal()] = spacingHorz;
    }

    public double getHorizontalSpacing(LGraphElement e1, LGraphElement e2) {
        if (e1 instanceof LNode && e2 instanceof LNode) {
            return this.getHorizontalSpacing((LNode)e1, (LNode)e2);
        }
        throw new UnspecifiedSpacingException();
    }

    public double getHorizontalSpacing(LNode n1, LNode n2) {
        return this.getLocalSpacing(n1, n2, this.nodeTypeSpacingOptionsHorizontal);
    }

    public double getHorizontalSpacing(LNode.NodeType nt1, LNode.NodeType nt2) {
        return this.getLocalSpacing(nt1, nt2, this.nodeTypeSpacingOptionsHorizontal);
    }

    public double getVerticalSpacing(LNode n1, LNode n2) {
        return this.verticalSpacings.computeIfAbsent(new Pair<LNode, LNode>(n1, n2), key -> this.calculateVerticalSpacing(n1, n2));
    }

    private double calculateVerticalSpacing(LNode n1, LNode n2) {
        double minmalSpacing = this.getMinimalVerticalSpacing(n1, n2);
        if (this.spacingShouldBeAdaptedDueToDifferentComponents(n1, n2)) {
            return this.adaptSpacingDueToDifferentComponents(minmalSpacing, n1, n2);
        }
        if (this.spacingShouldBeAdaptedDueToDataFlowDistance(n1, n2)) {
            return this.adaptSpacingDueToDataFlowDistance(minmalSpacing, n1, n2);
        }
        return minmalSpacing;
    }

    private boolean spacingShouldBeAdaptedDueToDifferentComponents(LNode currentNode, LNode neighbor) {
        return currentNode.getComponent() != null && neighbor.getComponent() != null && currentNode.getComponent().getIndex() != neighbor.getComponent().getIndex() && currentNode.getGraph().getProperty(LayeredOptions.NODE_PLACEMENT_BK_SPACING_COMPONENT_COMPONENT_MES_MORE) != false;
    }

    private double adaptSpacingDueToDifferentComponents(double spacing, LNode currentNode, LNode neighbor) {
        double spacingBetweenComponents = this.getSpacingBetweenNodesOfNeighboringComponents(currentNode, neighbor);
        return Math.max(spacing, spacingBetweenComponents);
    }

    private boolean spacingShouldBeAdaptedDueToDataFlowDistance(LNode currentNode, LNode neighbor) {
        return Spacings.spacingShouldBeAdaptedDueToDataFlowDistance(currentNode) && Spacings.spacingShouldBeAdaptedDueToDataFlowDistance(neighbor);
    }

    private static boolean spacingShouldBeAdaptedDueToDataFlowDistance(LNode node) {
        return node.isNormal() || node.isWideNode() || node.isLongEdge();
    }

    private double adaptSpacingDueToDataFlowDistance(double minmalSpacing, LNode currentNode, LNode neighbor) {
        double extraSpacingForDataFlowDistance = this.getExtraSpacingForDataFlowDistance(currentNode, neighbor);
        return minmalSpacing + extraSpacingForDataFlowDistance;
    }

    public double getExtraSpacingForDataFlowDistance(LNode n1, LNode n2) {
        int dataFlowDistance = this.getDataFlowDistance(n1, n2);
        return this.getExtraSpacingForDataFlowDistance(dataFlowDistance - 1);
    }

    private int getDataFlowDistance(LNode currentNode, LNode neighborNode) {
        int targetDistance = this.getForwardDataFlowDistance().getDistance(currentNode, neighborNode);
        if (DataFlowDistance.isInvalid(targetDistance)) {
            return this.getBackwardDataFlowDistance().getDistance(currentNode, neighborNode);
        }
        return targetDistance;
    }

    private DataFlowDistance getForwardDataFlowDistance() {
        if (this.forwardDataFlow == null) {
            this.forwardDataFlow = new DataFlowDistance(this.graph, true);
        }
        return this.forwardDataFlow;
    }

    private DataFlowDistance getBackwardDataFlowDistance() {
        if (this.backwardDataFlow == null) {
            this.backwardDataFlow = new DataFlowDistance(this.graph, false);
        }
        return this.backwardDataFlow;
    }

    private double getExtraSpacingForDataFlowDistance(int dataFlowDistance) {
        int ixExtraSpacing = this.convertToCorrespondingIndexOfExtraSpacing(dataFlowDistance);
        return EXTRA_SPACINGS_FOR_DATA_FLOW_DISTANCE[ixExtraSpacing];
    }

    private int convertToCorrespondingIndexOfExtraSpacing(int dataFlowDistance) {
        if (dataFlowDistance < 0) {
            return EXTRA_SPACINGS_FOR_DATA_FLOW_DISTANCE.length / 2;
        }
        if (dataFlowDistance >= EXTRA_SPACINGS_FOR_DATA_FLOW_DISTANCE.length) {
            return EXTRA_SPACINGS_FOR_DATA_FLOW_DISTANCE.length - 1;
        }
        return dataFlowDistance;
    }

    public double getMinimalVerticalSpacing(LNode n1, LNode n2) {
        return this.getLocalSpacing(n1, n2, this.nodeTypeSpacingOptionsVertical);
    }

    private double getLocalSpacing(LNode n1, LNode n2, IProperty<Double>[][] nodeTypeSpacingMapping) {
        LNode.NodeType t1 = n1.getType();
        LNode.NodeType t2 = n2.getType();
        IProperty<Double> layoutOption = nodeTypeSpacingMapping[t1.ordinal()][t2.ordinal()];
        Double s1 = Spacings.getIndividualOrDefault(n1, layoutOption);
        Double s2 = Spacings.getIndividualOrDefault(n2, layoutOption);
        return Math.max(s1, s2);
    }

    private double getLocalSpacing(LNode.NodeType nt1, LNode.NodeType nt2, IProperty<Double>[][] nodeTypeSpacingMapping) {
        IProperty<Double> layoutOption = nodeTypeSpacingMapping[nt1.ordinal()][nt2.ordinal()];
        return this.graph.getProperty(layoutOption);
    }

    public static <T> T getIndividualOrDefault(LNode node, IProperty<T> property) {
        IPropertyHolder individualSpacings;
        T result = null;
        if (node.hasProperty(LayeredOptions.SPACING_INDIVIDUAL) && (individualSpacings = (IPropertyHolder)node.getProperty(LayeredOptions.SPACING_INDIVIDUAL)).hasProperty(property)) {
            result = individualSpacings.getProperty(property);
        }
        if (result == null) {
            result = node.getGraph().getProperty(property);
        }
        return result;
    }

    private double getSpacingBetweenNodesOfNeighboringComponents(LNode n1, LNode n2) {
        int numberOfNodesInComponentOfN2;
        double spacingBetweenComponents = 0.0;
        int numberOfNodesInComponentOfN1 = n1.getComponent().getNumberOfNormalNodes();
        int maxNumberOfNodesInComponent = Math.max(numberOfNodesInComponentOfN1, numberOfNodesInComponentOfN2 = n2.getComponent().getNumberOfNormalNodes());
        spacingBetweenComponents = (double)maxNumberOfNodesInComponent < this.graph.getProperty(LayeredOptions.SPACING_NUM_OF_NODES_IN_COMP_FOR_MIN_SPACING_MES_MORE) ? this.graph.getProperty(LayeredOptions.SPACING_NODE_NODE_FROM_DIFF_COMP_MIN_MES_MORE) : ((double)maxNumberOfNodesInComponent < this.graph.getProperty(LayeredOptions.SPACING_NUM_OF_NODES_IN_COMP_FOR_MID_SPACING_MES_MORE) ? this.graph.getProperty(LayeredOptions.SPACING_NODE_NODE_FROM_DIFF_COMP_MID_MES_MORE).doubleValue() : this.graph.getProperty(LayeredOptions.SPACING_NODE_NODE_FROM_DIFF_COMP_MAX_MES_MORE).doubleValue());
        return spacingBetweenComponents;
    }

    public static class UnspecifiedSpacingException
    extends RuntimeException {
        private static final long serialVersionUID = 1609767701465615319L;

        public UnspecifiedSpacingException() {
        }

        public UnspecifiedSpacingException(String msg) {
            super(msg);
        }
    }
}

