/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.mesutils;

import com.google.common.base.Stopwatch;
import com.modelengineers.MoRe_elk.alg.layered.mesutils.Operation;
import com.modelengineers.MoRe_elk.core.util.Pair;
import com.modelengineers.MoRe_elk.graph.ElkEdge;
import com.modelengineers.MoRe_elk.graph.ElkNode;
import com.modelengineers.MoRe_elk.graph.util.ElkGraphUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class MesUtilMethods {
    private MesUtilMethods() {
    }

    public static <T> List<T> iterableToList(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false).collect(Collectors.toList());
    }

    public static long measureRuntime(Operation operation, String printPrefix, boolean log) throws InterruptedException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        MesUtilMethods.log("start ...", printPrefix, log);
        operation.execute();
        stopwatch.stop();
        long timeToSolveInMs = stopwatch.elapsed(TimeUnit.MILLISECONDS);
        MesUtilMethods.log("end - runtime (ms): " + timeToSolveInMs, printPrefix, log);
        return timeToSolveInMs;
    }

    private static void log(String message, String printPrefix, boolean log) {
        if (log) {
            System.out.println(String.valueOf(printPrefix) + " - " + message);
        }
    }

    public static int roundUpToMultipleOfFive(double number) {
        return (int)Math.ceil(number / 5.0) * 5;
    }

    public static int roundDownToMultipleOfFive(double number) {
        return (int)Math.floor(number / 5.0) * 5;
    }

    public static boolean isMultipleOfFive(double value) {
        return value % 5.0 == 0.0;
    }

    public static int min(int[] array) {
        return Arrays.stream(array).min().orElseThrow(() -> new IllegalArgumentException("Array must not be empty"));
    }

    public static Integer indexOfMax(int[] array) {
        return IntStream.range(0, array.length).boxed().max(Comparator.comparingInt(i -> array[i])).orElse(null);
    }

    public static List<Integer> getIndicesOfValuesLessThan(int[] array, int c) {
        return IntStream.range(0, array.length).filter(i -> array[i] < c).boxed().collect(Collectors.toList());
    }

    public static <T, U> List<T> mapConsecutivePairs(List<U> list, BiFunction<U, U, T> func) {
        return IntStream.range(0, list.size() - 1).mapToObj(i -> func.apply(list.get(i), list.get(i + 1))).collect(Collectors.toList());
    }

    public static <T> Stream<Pair<T, T>> getConsecutivePairsAsStream(List<T> list) {
        return IntStream.range(0, list.size() - 1).mapToObj(i -> new Pair(list.get(i), list.get(i + 1)));
    }

    public static <T> List<T> sorted(Iterable<T> iterable, ToDoubleFunction<T> keyExtractor) {
        return StreamSupport.stream(iterable.spliterator(), false).sorted(Comparator.comparingDouble(keyExtractor)).collect(Collectors.toList());
    }

    public static <T> List<List<T>> splitExcludingIndices(List<T> list, List<Integer> indices) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        int ixStart = 0;
        for (int ixEndExcluding : indices) {
            MesUtilMethods.addSubListIfNotEmpty(result, list, ixStart, ixEndExcluding);
            ixStart = ixEndExcluding + 1;
        }
        MesUtilMethods.addSubListIfNotEmpty(result, list, ixStart, list.size());
        return result;
    }

    private static <T> void addSubListIfNotEmpty(List<List<T>> result, List<T> list, int ixStart, int ixEndExcluding) {
        if (ixStart < ixEndExcluding) {
            result.add(new ArrayList<T>(list.subList(ixStart, ixEndExcluding)));
        }
    }

    public static <T> Stream<Pair<T, T>> getUniquePairsAsStream(List<T> list) {
        return IntStream.range(0, list.size()).boxed().flatMap(i -> IntStream.range(i + 1, list.size()).mapToObj(j -> new Pair(list.get((int)i), list.get(j))));
    }

    public static <T> Stream<Pair<T, T>> getAllPairsAsStream(List<T> list) {
        return IntStream.range(0, list.size()).boxed().flatMap(i -> IntStream.range(0, list.size()).mapToObj(j -> new Pair(list.get((int)i), list.get(j))));
    }

    public static <A, B> Stream<Pair<A, B>> getAllPairsAsStream(List<A> a, List<B> b) {
        return a.stream().flatMap(x -> b.stream().map(y -> new Pair<Object, Object>(x, y)));
    }

    public static <T> boolean setEquals(List<T> a, List<T> b) {
        if (a.size() == b.size()) {
            HashSet<T> sa = new HashSet<T>(a);
            HashSet<T> sb = new HashSet<T>(b);
            return sa.equals(sb);
        }
        return false;
    }

    @SafeVarargs
    public static <T> List<T> concatLists(List<T> ... lists) {
        return Arrays.stream(lists).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static <T> void replaceElements(List<T> target, List<T> source) {
        target.clear();
        target.addAll(source);
    }

    public static <T> T getLastElementOrNull(List<T> list) {
        return list.isEmpty() ? null : (T)list.get(list.size() - 1);
    }

    public static Integer getMaxOrNull(Stream<Integer> stream) {
        return stream.max(Integer::compareTo).orElse(null);
    }

    public static String getNameOfNode(ElkNode node) {
        return node.getIdentifier().substring(node.getIdentifier().lastIndexOf("/") + 1);
    }

    public static String getDescription(ElkEdge edge) {
        String sourceNode = MesUtilMethods.getNameOfNode(ElkGraphUtil.getSourceNode(edge));
        String targetNode = MesUtilMethods.getNameOfNode(ElkGraphUtil.getTargetNode(edge));
        return "edge from " + sourceNode + " to " + targetNode;
    }

    public static void checkInterrupt() throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException("Work was interrupted");
        }
    }

    public static void runAsThreadWithInterruptHandling(Runnable run, Runnable runOnInterrupt) throws InterruptedException {
        Thread thread = new Thread(run);
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            runOnInterrupt.run();
            throw e;
        }
    }
}

