/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.mestestutils;

import com.modelengineers.MoRe_elk.core.util.ElkUtil;
import com.modelengineers.MoRe_elk.graph.ElkBendPoint;
import com.modelengineers.MoRe_elk.graph.ElkNode;
import com.modelengineers.MoRe_elk.graph.ElkPort;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TripleBranches {
    private ElkNode graph;

    public TripleBranches(ElkNode graph) {
        this.graph = graph;
    }

    public boolean found() {
        Stream<ElkPort> srcPorts = this.graph.getContainedEdges().stream().map(e -> (ElkPort)e.getSources().get(0)).distinct();
        return srcPorts.anyMatch(p -> TripleBranches.hasTripleBranches(p));
    }

    private static boolean hasTripleBranches(ElkPort srcPort) {
        Stream bendPoints = srcPort.getOutgoingEdges().stream().flatMap(e -> e.getSections().stream()).flatMap(s -> s.getBendPoints().stream()).distinct();
        return bendPoints.anyMatch(bp -> TripleBranches.isTripleBranchPoint(bp, srcPort));
    }

    private static boolean isTripleBranchPoint(ElkBendPoint bendPoint, ElkPort srcPort) {
        List<ElkUtil.Segment> segments = srcPort.getOutgoingEdges().stream().flatMap(e -> ElkUtil.getSegments(e).stream()).collect(Collectors.toList());
        return TripleBranches.upwardSegmentStartsAt(segments, bendPoint) && TripleBranches.downwardSegmentStartsAt(segments, bendPoint) && TripleBranches.horizontalSegmentGoesThrough(segments, bendPoint);
    }

    private static boolean upwardSegmentStartsAt(List<ElkUtil.Segment> segments, ElkBendPoint bendPoint) {
        return segments.stream().anyMatch(s -> s.isVertical() && s.getLowerPoint().x == bendPoint.getX() && s.getLowerPoint().y == bendPoint.getY());
    }

    private static boolean downwardSegmentStartsAt(List<ElkUtil.Segment> segments, ElkBendPoint bendPoint) {
        return segments.stream().anyMatch(s -> s.isVertical() && s.getHigherPoint().x == bendPoint.getX() && s.getHigherPoint().y == bendPoint.getY());
    }

    private static boolean horizontalSegmentGoesThrough(List<ElkUtil.Segment> segments, ElkBendPoint bendPoint) {
        return segments.stream().anyMatch(s -> s.isHorizontal() && s.getLowerPoint().y == bendPoint.getY() && s.getLeftPoint().x < bendPoint.getX() && s.getRightPoint().x > bendPoint.getX());
    }
}

