/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.mestestutils;

import com.modelengineers.MoRe_elk.alg.layered.mesutils.MesUtilMethods;
import com.modelengineers.MoRe_elk.core.util.ElkUtil;
import com.modelengineers.MoRe_elk.graph.ElkEdge;
import com.modelengineers.MoRe_elk.graph.ElkNode;
import com.modelengineers.MoRe_elk.graph.util.ElkGraphUtil;
import java.util.List;

public class StackingEdgeSteps {
    private static final int NUM_MAX_ALLOWED_STACKING_STEPS = 7;
    private ElkNode graph;

    public StackingEdgeSteps(ElkNode graph) {
        this.graph = graph;
    }

    public String getErrorMsg() {
        ElkNode nodeConnectedToStackingSteps = this.graph.getChildren().stream().filter(n -> StackingEdgeSteps.connectedEdgesFormStackingSteps(n)).findFirst().orElse(null);
        return nodeConnectedToStackingSteps == null ? "" : StackingEdgeSteps.getErrorMessage(nodeConnectedToStackingSteps);
    }

    private static boolean connectedEdgesFormStackingSteps(ElkNode node) {
        return StackingEdgeSteps.incomingEdgesFormStackingSteps(node) || StackingEdgeSteps.outgoingEdgesFormStackingSteps(node);
    }

    private static boolean incomingEdgesFormStackingSteps(ElkNode node) {
        Iterable<ElkEdge> incomingEdges = ElkGraphUtil.allIncomingEdges(node);
        return StackingEdgeSteps.formStackingSteps(incomingEdges, true);
    }

    private static boolean outgoingEdgesFormStackingSteps(ElkNode node) {
        Iterable<ElkEdge> outgoingEdges = ElkGraphUtil.allOutgoingEdges(node);
        return StackingEdgeSteps.formStackingSteps(outgoingEdges, false);
    }

    private static boolean formStackingSteps(Iterable<ElkEdge> edges, boolean incoming) {
        List<Boolean> pairStack = StackingEdgeSteps.checkStackingPairWise(edges, incoming);
        return StackingEdgeSteps.getLongestStack(pairStack) > 7;
    }

    private static List<Boolean> checkStackingPairWise(Iterable<ElkEdge> edges, boolean incoming) {
        List<ElkEdge> edgesSortedByPortOrder = StackingEdgeSteps.getEdgesSortedByPortOrder(edges, incoming);
        return MesUtilMethods.mapConsecutivePairs(edgesSortedByPortOrder, (a, b) -> StackingEdgeSteps.isPairOfEdgesToCheck(a, b) && StackingEdgeSteps.edgesFormStackingStep(a, b) != false);
    }

    private static List<ElkEdge> getEdgesSortedByPortOrder(Iterable<ElkEdge> edges, boolean incoming) {
        return MesUtilMethods.sorted(edges, edge -> edge.getPort(incoming).getY());
    }

    private static boolean isPairOfEdgesToCheck(ElkEdge edgeI, ElkEdge edgeJ) {
        return !StackingEdgeSteps.haveSameSourcePort(edgeI, edgeJ) && !edgeI.hasSameSourceAndTargetNodeAs(edgeJ) && StackingEdgeSteps.areUnsplit(edgeI, edgeJ);
    }

    private static boolean haveSameSourcePort(ElkEdge edgeI, ElkEdge edgeJ) {
        return ElkGraphUtil.getSourcePort(edgeI) == ElkGraphUtil.getSourcePort(edgeJ);
    }

    private static boolean areUnsplit(ElkEdge edgeI, ElkEdge edgeJ) {
        return !edgeI.isSplit() && !edgeJ.isSplit();
    }

    private static Boolean edgesFormStackingStep(ElkEdge edgeI, ElkEdge edgeJ) {
        if (StackingEdgeSteps.verticalOverlapOfVerticalSegment(edgeI, edgeJ) && StackingEdgeSteps.horizontalOverlapOfHorizontalSegment(edgeI, edgeJ)) {
            return true;
        }
        return false;
    }

    private static boolean verticalOverlapOfVerticalSegment(ElkEdge edgeI, ElkEdge edgeJ) {
        List<ElkUtil.Segment> verticalSegmentsI = ElkUtil.getVerticalSegments(edgeI);
        List<ElkUtil.Segment> verticalSegmentsJ = ElkUtil.getVerticalSegments(edgeJ);
        return verticalSegmentsI.stream().anyMatch(vSI -> StackingEdgeSteps.verticalOverlap(vSI, verticalSegmentsJ));
    }

    private static boolean verticalOverlap(ElkUtil.Segment verticalSegmentI, List<ElkUtil.Segment> verticalSegmentsJ) {
        return verticalSegmentsJ.stream().anyMatch(vSJ -> vSJ.overlapsVertically(verticalSegmentI));
    }

    private static boolean horizontalOverlapOfHorizontalSegment(ElkEdge edgeI, ElkEdge edgeJ) {
        List<ElkUtil.Segment> horizontalSegmentsI = ElkUtil.getHorizontalSegments(edgeI);
        List<ElkUtil.Segment> horizontalSegmentsJ = ElkUtil.getHorizontalSegments(edgeJ);
        return horizontalSegmentsI.stream().anyMatch(hSI -> StackingEdgeSteps.horizontalOverlap(hSI, horizontalSegmentsJ));
    }

    private static boolean horizontalOverlap(ElkUtil.Segment horizontalSegmentI, List<ElkUtil.Segment> horizontalSegmentsJ) {
        return horizontalSegmentsJ.stream().anyMatch(hSJ -> hSJ.overlapsHorizontally(horizontalSegmentI));
    }

    private static int getLongestStack(List<Boolean> pairStack) {
        int longestLength = 0;
        int currentLength = 0;
        for (Boolean stack : pairStack) {
            currentLength = stack.booleanValue() ? ++currentLength : 0;
            if (currentLength <= longestLength) continue;
            longestLength = currentLength;
        }
        return longestLength;
    }

    private static String getErrorMessage(ElkNode nodeConnectedToStackingSteps) {
        return "Stacking Steps connected to " + MesUtilMethods.getNameOfNode(nodeConnectedToStackingSteps);
    }
}

