/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.mestestutils;

import com.modelengineers.MoRe_elk.core.options.CoreOptions;
import com.modelengineers.MoRe_elk.graph.ElkNode;
import com.modelengineers.MoRe_elk.graph.ElkShape;
import java.util.Comparator;
import java.util.List;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class PortBlockOrder {
    private ElkNode graph;

    public PortBlockOrder(ElkNode graph) {
        this.graph = graph;
    }

    public boolean allInportBlocksAreOrderedByPortNumber() {
        return this.allPortBlocksAreOrderedByPortNumber("Inport");
    }

    public boolean allOutportBlocksAreOrderedByPortNumber() {
        return this.allPortBlocksAreOrderedByPortNumber("Outport");
    }

    private boolean allPortBlocksAreOrderedByPortNumber(String blockType) {
        List<ElkNode> portBlocksSortedByPortNumber = PortBlockOrder.sorted(this.getPortBlocks(blockType), PortBlockOrder::getPortNumber);
        return PortBlockOrder.yOrderOfNodesCorrespondsToOrderInList(portBlocksSortedByPortNumber);
    }

    private static boolean yOrderOfNodesCorrespondsToOrderInList(List<ElkNode> nodes) {
        return nodes.equals(PortBlockOrder.sorted(nodes, ElkShape::getY));
    }

    private List<ElkNode> getPortBlocks(String blockType) {
        List<ElkNode> portBlocks = this.graph.getChildren().stream().filter(n -> PortBlockOrder.isBlockOfType(n, blockType)).collect(Collectors.toList());
        assert (portBlocks.size() > 0);
        return portBlocks;
    }

    private static boolean isBlockOfType(ElkNode node, String type) {
        return node.getProperty(CoreOptions.MES_BLOCK_PARAMETERS_MAP).getParam("BlockType").equals(type);
    }

    private static <T> List<T> sorted(List<T> list, ToDoubleFunction<? super T> keyExtractor) {
        return list.stream().sorted(Comparator.comparingDouble(keyExtractor)).collect(Collectors.toList());
    }

    private static double getPortNumber(ElkNode node) {
        return Integer.parseInt(node.getProperty(CoreOptions.MES_BLOCK_PARAMETERS_MAP).getParam("Port"));
    }

    public boolean areOutportBlocksWithGivenNumbersInGivenOrder(int ... portNumbers) {
        return this.arePortBlocksWithGivenNumbersInGivenOrder("Outport", portNumbers);
    }

    private boolean arePortBlocksWithGivenNumbersInGivenOrder(String blockType, int ... portNumbers) {
        return PortBlockOrder.yOrderOfNodesCorrespondsToOrderInList(this.getPortBlocks(blockType, portNumbers));
    }

    private List<ElkNode> getPortBlocks(String blockType, int ... portNumbers) {
        List<ElkNode> portBlocks = this.getPortBlocks(blockType);
        return IntStream.of(portNumbers).mapToObj(pn -> this.getPortBlock(portBlocks, pn)).collect(Collectors.toList());
    }

    private ElkNode getPortBlock(List<ElkNode> portBlocks, int portNumber) {
        return portBlocks.stream().filter(pb -> PortBlockOrder.getPortNumber(pb) == (double)portNumber).findFirst().get();
    }
}

